function [ resistance, turns, level, diammax, meters, cost, weight ] = make_inductor2(inductance, inner_diameter, coil_length, wire_gauge)

%Output 
%resistance - Ohms
%turns - number of turns
%level - number of layers
%diammax - outer diameter mm
%meters - length of wire in meters

%Input
%inductance mH
%inner_diameter mm
%coil_length mm
%wire_gague AWG

%Translated from http://www.coolcircuit.com/tools/multi_layer_coil_calculator/lO.js
%LM = eval(form1.LM.value); %Inductance?
%dM = eval(form1.dM.value);
%lM = eval(form1.lM.value);
%DM = eval(form1.DM.value);
%wM = eval(form1.wM.value);
%WM = eval(form1.WM.value);

%inductance = eval(form1.inductance.value)*LM;
MM_PER_INCH = 25.4;


%gauge = form1.gauge.options[form1.gauge.options.selectedIndex].text;
diameter = inner_diameter*1/MM_PER_INCH; %diameter = eval(form1.diameter.value)*dM;
coilLen = coil_length*1/MM_PER_INCH; % coilLen = eval(form1.coilLength.value)*lM;
%gauge diameter_in_xunit diameter_in_y_unit lbs/m r_meter $_per_meter
gauge = [
[1 0.2893 0.1264 0 0 ]
[2 0.2576 0.1593 0 0 ]
[3 0.2294 0.2009 0 0 ]
[4 0.2043 0.2533  0 0]
[5 0.1819 0.3195  0 0]
[6 0.1643 0.3952  0 0]
[7 0.1466 0.4981  0 0]
[8 0.1306 0.6281  0 0]
[9 0.1165 0.7925  0 0]
[10 0.1039 0.9988  0 0]
[11 0.0927 1.2600  0 0]
[12 0.0827 1.59  0 0]
[13 0.0739 2.00  0 0]
[14 0.0660 2.52 0.0415 0.44]
[15 0.0589 3.18 0 0]
[16 0.0525 4.02 0 0]
[17 0.0469 5.05 0 0]
[18 0.0418 6.39 0 0]
[19 0.0374 8.05 0 0]
[20 0.0334 10.1 0 0]
[21 0.0299 12.8 0 0]
[22 0.0267 16.2 0 0]
[23 0.0239 20.31 0 0]
[24 0.0213 25.67 0 0]
[25 0.0191 32.37 0 0]
[26 0.0170 41.02 0 0]
[27 0.0153 51.43 0 0]
[28 0.0136 65.33 0 0]
[29 0.0123 81.22 0 0]
[30 0.0109 103.2 0 0]
[31 0.0098 130.9 0 0]
[32 0.0088 162.0 0 0]
[33 0.0079 205.7 0 0]
[34 0.0071 261.3 0 0]
[35 0.0063 330.7 0 0]
[36 0.0057 414.8 0 0]
[37 0.0051 512.1 0 0]
[38 0.0045 648.2 0 0]
[39 0.0040 846.6 0 0]
[40 0.0036 1079.0 0 0]
[41 0.0032 1323.0 0 0]
[42 0.0028 1659.0 0 0]
[43 0.0025 2143.0 0 0]
[44 0.0023 2593.0 0 0]
[45 0.00206 3348.0 0 0]
];

selected_gauge = gauge(wire_gauge,:);
wireSize = selected_gauge(2);
res = selected_gauge(3);

currentInd = 0;
turns = 1;
diamavg = 0.0;
diammax = diameter;
turnsPerLevel = coilLen / wireSize;
while ( currentInd < inductance )
%start while
diamavg = 0.0;
diammax = diameter;
tempTurns = turns;
  while ( tempTurns > 0.0 )
  if ( tempTurns < turnsPerLevel )
   %start if
   diamavg = diamavg + diammax * tempTurns;
  %end if
  else
   %start else
   diamavg = diamavg + diammax * turnsPerLevel;
   %end else
  end
  diammax = diammax + (2.0*wireSize);
  tempTurns = tempTurns - turnsPerLevel;
  end%end while ( tempTurns > 0.0 )
diamavg = diamavg/turns;

diammax = diammax * 25.4;

currentInd = ( diamavg / 1000.0 ) * diamavg * turns * turns / (( 18.0 * diamavg ) + ( 40.0 * coilLen ));
turns = turns + 1;
end %end while ( currentInd < inductance )
feet = ( diamavg * turns * 3.14159 ) / 12.0;
meters = feet * 0.3048;

resistance = (res * feet ) / 1000.0;
level = turns / turnsPerLevel;

cost = 0.44*meters; %FIX
weight = 0.0415*meters; %FIX
%disp_samep( Roundoff( resistance ), Roundoff((wireSize*1000)/wM), Roundoff(turns), Roundoff(feet/WM), Roundoff(diammax/DM), Roundoff(level), Roundoff(turnsPerLevel));


end

