clc;
hold off;
%clear;

vc_initial = 42;
%Read values from spreadsheet
if ~(exist('filename'))
    load_from_spreadsheet
end


inner_diameter = 15; %mm Inner diameter 
inductor_length = 30; %mm Inductor length
gauge = 11; %AWG Gauge 

fs = 10; %Number of firing cycles

%new_bank_at = [1, 3, 4, 5, 6, 7, 8, 9, 10];%Stages in which the voltage will go back to 100%
new_bank_at = [];

inductor_resistance = zeros(fs, 1);
I_max = zeros(fs, 1);

for j=[1:length(inductance_needed)]
    l = inductance_needed_mh(j);
    [r, turns, level, diammax, meters] = make_inductor2(l, inner_diameter, inductor_length, gauge);
    inductor_resistance(j) = r;
end

resistance = inductor_resistance + capacitor_resistance/1000;

alpha = (resistance)./(2.*inductance_needed);

beta = sqrt(1./(inductance_needed.*capacitance)-resistance.^2 ./(4.*inductance_needed.^2));

%Considering stage 1 only
%n = 1000;

%t = linspace(0, fs.*firing_period(1)*10^-6, n);

%I = (vc_initial(1)./(beta(1)*(inductance_needed(1)))).*exp(-alpha(1).*t).*sin(beta(1).*t);
%Vc = vc_initial(1).*exp(-alpha(1).*t).*cos(beta(1).*t); %Capacitor voltage


n = 100000; %Samples per stage
%t = zeros([1 n*fs]);
%I = zeros([1 n*fs]);
%Vc = zeros([1 n*fs]);

V0 = zeros([1 fs+1]);

if ~(exist('V0_init')) %Keeps voltages goign lower and lower through repetitive sims
    V0_init = vc_initial(1); 
end

V0(1) = V0_init;



prev_start = 1;
prev_end = n;
t = [];
Vc = [];
I = [];
E = [];
start_i = 1;

stage_lines = zeros([1 fs]);
for i=[1:fs]
    
    t_stage = linspace(0, firing_period(i)*10^-6, n);
    
    if length(t) > 0
        t_normalized = linspace(t(length(t)), t(length(t))+firing_period(i)*10^-6, n);
    else
        t_normalized = linspace(0, firing_period(i)*10^-6, n);
    end
    
    I_stage = (V0(i)./(beta(i)*(inductance_needed(i)))).*exp(-alpha(i).*t_stage).*sin(beta(i).*t_stage);
    Vc_stage = V0(i).*exp(-alpha(i).*t_stage).*cos(beta(i).*t_stage); %Capacitor voltage
    
    mx = max(I_stage);
    if (mx < 0.1)
        mx = min(I_stage);
    end
    I_max(i) = mx;
    
    if any(i+1==new_bank_at) %Checks if it's a new capacitor bank on the next stage
        V0(i+1) = V0_init;
    else
        V0(i+1) = Vc_stage(length(Vc_stage));
    end
    
    E_stage = .5*capacitance(i).*Vc_stage.^2 + .5*inductance_needed(i).*I_stage.^2;
    
    t = horzcat(t, t_normalized);
    I = horzcat(I, I_stage);
    Vc = horzcat(Vc, Vc_stage);
    E = horzcat(E, E_stage);
    
    
    stage_lines(i) = t(length(t));

end

%HOLD ON
plot (t, Vc, 'b', t, I, 'r', t, E, 'g')
hold on;
xlabel('time (s)');
ylabel ({'Current (A) (Red)'; 'Voltage (V) (Blue)'; 'Total Energy (J) (Green)'});

plot([0 max(t)], [0 0], 'k');
for i=[1:length(stage_lines)]
    plot([stage_lines(i), stage_lines(i)],  [min([I(:);Vc(:)]) max([I(:);Vc(:)])], 'k');
end

%xlswrite(filename, V0', 'F2:F27') %in Volts

%plot (t, I)
