clc;
hold off;
clear;

V0 = 227.1271;

L = 0.0344;

C = 1.1765;

R = 1.5984;


alpha = (R)./(2.*L);

beta = sqrt(1./(L.*C)-R.^2 ./(4.*L.^2));

n = 100000; %Samples per stage

tau = 0.2;

t = linspace(0, tau, n);
I = (V0./(beta*(L))).*exp(-alpha.*t).*sin(beta.*t);
Vc = V0.*exp(-alpha.*t).*cos(beta.*t); %Capacitor voltage

E = 1/2*C.*Vc.^2 + 1/2*L.*I.^2;
E = E*100;

%HOLD ON
plot (t, Vc, 'b', t, I, 'r')%, t, E, 'g')
hold on;
xlabel('time (s)');
ylabel ({'Current (A) (Red)'; 'Voltage (V) (Blue)'; 'Total Energy (J) (Green)'});

plot([0 max(t)], [0 0], 'k');

%plot (t, I)
