/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebaseauth;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.util.SparseArray;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseException;
import com.google.firebase.FirebaseTooManyRequestsException;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthProvider;
import com.google.firebase.auth.FacebookAuthProvider;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseAuthInvalidCredentialsException;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.GithubAuthProvider;
import com.google.firebase.auth.GoogleAuthProvider;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.TwitterAuthProvider;
import com.google.firebase.auth.UserInfo;
import com.google.firebase.auth.UserProfileChangeRequest;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class FirebaseAuthPlugin
implements MethodChannel.MethodCallHandler {
    private final PluginRegistry.Registrar registrar;
    private final SparseArray<FirebaseAuth.AuthStateListener> authStateListeners = new SparseArray();
    private final SparseArray<PhoneAuthProvider.ForceResendingToken> forceResendingTokens = new SparseArray();
    private final MethodChannel channel;
    private int nextHandle = 0;
    private static final String ERROR_REASON_EXCEPTION = "exception";

    public static void registerWith(PluginRegistry.Registrar registrar) {
        MethodChannel channel = new MethodChannel(registrar.messenger(), "plugins.flutter.io/firebase_auth");
        channel.setMethodCallHandler((MethodChannel.MethodCallHandler)new FirebaseAuthPlugin(registrar, channel));
    }

    private FirebaseAuthPlugin(PluginRegistry.Registrar registrar, MethodChannel channel) {
        this.registrar = registrar;
        this.channel = channel;
        FirebaseApp.initializeApp((Context)registrar.context());
    }

    private FirebaseAuth getAuth(MethodCall call) {
        Map arguments = (Map)call.arguments;
        String appName = (String)arguments.get("app");
        FirebaseApp app = FirebaseApp.getInstance((String)appName);
        return FirebaseAuth.getInstance((FirebaseApp)app);
    }

    public void onMethodCall(MethodCall call, MethodChannel.Result result) {
        switch (call.method) {
            case "currentUser": {
                this.handleCurrentUser(call, result, this.getAuth(call));
                break;
            }
            case "signInAnonymously": {
                this.handleSignInAnonymously(call, result, this.getAuth(call));
                break;
            }
            case "createUserWithEmailAndPassword": {
                this.handleCreateUserWithEmailAndPassword(call, result, this.getAuth(call));
                break;
            }
            case "fetchProvidersForEmail": {
                this.handleFetchProvidersForEmail(call, result, this.getAuth(call));
                break;
            }
            case "sendPasswordResetEmail": {
                this.handleSendPasswordResetEmail(call, result, this.getAuth(call));
                break;
            }
            case "sendEmailVerification": {
                this.handleSendEmailVerification(call, result, this.getAuth(call));
                break;
            }
            case "reload": {
                this.handleReload(call, result, this.getAuth(call));
                break;
            }
            case "delete": {
                this.handleDelete(call, result, this.getAuth(call));
                break;
            }
            case "signInWithEmailAndPassword": {
                this.handleSignInWithEmailAndPassword(call, result, this.getAuth(call));
                break;
            }
            case "signInWithGoogle": {
                this.handleSignInWithGoogle(call, result, this.getAuth(call));
                break;
            }
            case "signInWithCustomToken": {
                this.handleSignInWithCustomToken(call, result, this.getAuth(call));
                break;
            }
            case "signInWithFacebook": {
                this.handleSignInWithFacebook(call, result, this.getAuth(call));
                break;
            }
            case "signInWithTwitter": {
                this.handleSignInWithTwitter(call, result, this.getAuth(call));
                break;
            }
            case "signInWithGithub": {
                this.handleSignInWithGithub(call, result, this.getAuth(call));
                break;
            }
            case "signOut": {
                this.handleSignOut(call, result, this.getAuth(call));
                break;
            }
            case "getIdToken": {
                this.handleGetToken(call, result, this.getAuth(call));
                break;
            }
            case "reauthenticateWithEmailAndPassword": {
                this.handleReauthenticateWithEmailAndPassword(call, result, this.getAuth(call));
                break;
            }
            case "reauthenticateWithGoogleCredential": {
                this.handleReauthenticateWithGoogleCredential(call, result, this.getAuth(call));
                break;
            }
            case "reauthenticateWithFacebookCredential": {
                this.handleReauthenticateWithFacebookCredential(call, result, this.getAuth(call));
                break;
            }
            case "reauthenticateWithTwitterCredential": {
                this.handleReauthenticateWithTwitterCredential(call, result, this.getAuth(call));
                break;
            }
            case "reauthenticateWithGithubCredential": {
                this.handleReauthenticateWithGithubCredential(call, result, this.getAuth(call));
                break;
            }
            case "linkWithEmailAndPassword": {
                this.handleLinkWithEmailAndPassword(call, result, this.getAuth(call));
                break;
            }
            case "linkWithGoogleCredential": {
                this.handleLinkWithGoogleCredential(call, result, this.getAuth(call));
                break;
            }
            case "linkWithFacebookCredential": {
                this.handleLinkWithFacebookCredential(call, result, this.getAuth(call));
                break;
            }
            case "linkWithTwitterCredential": {
                this.handleLinkWithTwitterCredential(call, result, this.getAuth(call));
                break;
            }
            case "linkWithGithubCredential": {
                this.handleLinkWithGithubCredential(call, result, this.getAuth(call));
                break;
            }
            case "updateEmail": {
                this.handleUpdateEmail(call, result, this.getAuth(call));
                break;
            }
            case "updatePassword": {
                this.handleUpdatePassword(call, result, this.getAuth(call));
                break;
            }
            case "updateProfile": {
                this.handleUpdateProfile(call, result, this.getAuth(call));
                break;
            }
            case "startListeningAuthState": {
                this.handleStartListeningAuthState(call, result, this.getAuth(call));
                break;
            }
            case "stopListeningAuthState": {
                this.handleStopListeningAuthState(call, result, this.getAuth(call));
                break;
            }
            case "verifyPhoneNumber": {
                this.handleVerifyPhoneNumber(call, result, this.getAuth(call));
                break;
            }
            case "signInWithPhoneNumber": {
                this.handleSignInWithPhoneNumber(call, result, this.getAuth(call));
                break;
            }
            case "setLanguageCode": {
                this.handleSetLanguageCode(call, result, this.getAuth(call));
                break;
            }
            default: {
                result.notImplemented();
            }
        }
    }

    private void handleSignInWithPhoneNumber(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        Map arguments = (Map)call.arguments;
        String verificationId = (String)arguments.get("verificationId");
        String smsCode = (String)arguments.get("smsCode");
        PhoneAuthCredential phoneAuthCredential = PhoneAuthProvider.getCredential((String)verificationId, (String)smsCode);
        firebaseAuth.signInWithCredential((AuthCredential)phoneAuthCredential).addOnCompleteListener((OnCompleteListener)new SignInCompleteListener(result));
    }

    private void handleVerifyPhoneNumber(MethodCall call, MethodChannel.Result result, final FirebaseAuth firebaseAuth) {
        final int handle = (Integer)call.argument("handle");
        String phoneNumber = (String)call.argument("phoneNumber");
        int timeout = (Integer)call.argument("timeout");
        PhoneAuthProvider.OnVerificationStateChangedCallbacks verificationCallbacks = new PhoneAuthProvider.OnVerificationStateChangedCallbacks(){

            public void onVerificationCompleted(PhoneAuthCredential phoneAuthCredential) {
                firebaseAuth.signInWithCredential((AuthCredential)phoneAuthCredential).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<AuthResult>(){

                    public void onComplete(@NonNull Task<AuthResult> task) {
                        if (task.isSuccessful()) {
                            HashMap<String, Integer> arguments = new HashMap<String, Integer>();
                            arguments.put("handle", handle);
                            FirebaseAuthPlugin.this.channel.invokeMethod("phoneVerificationCompleted", arguments);
                        }
                    }
                });
            }

            public void onVerificationFailed(FirebaseException e) {
                HashMap<String, Object> arguments = new HashMap<String, Object>();
                arguments.put("handle", handle);
                arguments.put(FirebaseAuthPlugin.ERROR_REASON_EXCEPTION, FirebaseAuthPlugin.this.getVerifyPhoneNumberExceptionMap(e));
                FirebaseAuthPlugin.this.channel.invokeMethod("phoneVerificationFailed", arguments);
            }

            public void onCodeSent(String verificationId, PhoneAuthProvider.ForceResendingToken forceResendingToken) {
                HashMap<String, Object> arguments = new HashMap<String, Object>();
                arguments.put("handle", handle);
                arguments.put("verificationId", verificationId);
                arguments.put("forceResendingToken", forceResendingToken.hashCode());
                FirebaseAuthPlugin.this.channel.invokeMethod("phoneCodeSent", arguments);
            }

            public void onCodeAutoRetrievalTimeOut(String verificationId) {
                HashMap<String, Object> arguments = new HashMap<String, Object>();
                arguments.put("handle", handle);
                arguments.put("verificationId", verificationId);
                FirebaseAuthPlugin.this.channel.invokeMethod("phoneCodeAutoRetrievalTimeout", arguments);
            }
        };
        if (call.argument("forceResendingToken") != null) {
            int forceResendingTokenKey = (Integer)call.argument("forceResendingToken");
            PhoneAuthProvider.ForceResendingToken forceResendingToken = (PhoneAuthProvider.ForceResendingToken)this.forceResendingTokens.get(forceResendingTokenKey);
            PhoneAuthProvider.getInstance().verifyPhoneNumber(phoneNumber, (long)timeout, TimeUnit.MILLISECONDS, this.registrar.activity(), verificationCallbacks, forceResendingToken);
        } else {
            PhoneAuthProvider.getInstance().verifyPhoneNumber(phoneNumber, (long)timeout, TimeUnit.MILLISECONDS, this.registrar.activity(), verificationCallbacks);
        }
        result.success(null);
    }

    private Map<String, Object> getVerifyPhoneNumberExceptionMap(FirebaseException e) {
        HashMap<String, Object> exceptionMap = new HashMap<String, Object>();
        String errorCode = "verifyPhoneNumberError";
        if (e instanceof FirebaseAuthInvalidCredentialsException) {
            errorCode = "invalidCredential";
        } else if (e instanceof FirebaseAuthException) {
            errorCode = "firebaseAuth";
        } else if (e instanceof FirebaseTooManyRequestsException) {
            errorCode = "quotaExceeded";
        } else if (e instanceof FirebaseApiNotAvailableException) {
            errorCode = "apiNotAvailable";
        }
        exceptionMap.put("code", errorCode);
        exceptionMap.put("message", e.getMessage());
        return exceptionMap;
    }

    private void handleLinkWithEmailAndPassword(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        Map arguments = (Map)call.arguments;
        String email = (String)arguments.get("email");
        String password = (String)arguments.get("password");
        AuthCredential credential = EmailAuthProvider.getCredential((String)email, (String)password);
        firebaseAuth.getCurrentUser().linkWithCredential(credential).addOnCompleteListener((OnCompleteListener)new SignInCompleteListener(result));
    }

    private void handleCurrentUser(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        FirebaseUser user = firebaseAuth.getCurrentUser();
        if (user == null) {
            result.success(null);
            return;
        }
        Map<String, Object> userMap = this.mapFromUser(user);
        result.success(userMap);
    }

    private void handleSignInAnonymously(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        firebaseAuth.signInAnonymously().addOnCompleteListener((OnCompleteListener)new SignInCompleteListener(result));
    }

    private void handleCreateUserWithEmailAndPassword(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        Map arguments = (Map)call.arguments;
        String email = (String)arguments.get("email");
        String password = (String)arguments.get("password");
        firebaseAuth.createUserWithEmailAndPassword(email, password).addOnCompleteListener((OnCompleteListener)new SignInCompleteListener(result));
    }

    private void handleFetchProvidersForEmail(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        Map arguments = (Map)call.arguments;
        String email = (String)arguments.get("email");
        firebaseAuth.fetchProvidersForEmail(email).addOnCompleteListener((OnCompleteListener)new ProvidersCompleteListener(result));
    }

    private void handleSendPasswordResetEmail(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        Map arguments = (Map)call.arguments;
        String email = (String)arguments.get("email");
        firebaseAuth.sendPasswordResetEmail(email).addOnCompleteListener((OnCompleteListener)new TaskVoidCompleteListener(result));
    }

    private void handleSendEmailVerification(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        firebaseAuth.getCurrentUser().sendEmailVerification().addOnCompleteListener((OnCompleteListener)new TaskVoidCompleteListener(result));
    }

    private void handleReload(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        firebaseAuth.getCurrentUser().reload().addOnCompleteListener((OnCompleteListener)new TaskVoidCompleteListener(result));
    }

    private void handleSignInWithEmailAndPassword(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        Map arguments = (Map)call.arguments;
        String email = (String)arguments.get("email");
        String password = (String)arguments.get("password");
        firebaseAuth.signInWithEmailAndPassword(email, password).addOnCompleteListener((OnCompleteListener)new SignInCompleteListener(result));
    }

    private void handleDelete(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        firebaseAuth.getCurrentUser().delete().addOnCompleteListener((OnCompleteListener)new TaskVoidCompleteListener(result));
    }

    private void handleSignInWithGoogle(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        Map arguments = (Map)call.arguments;
        String idToken = (String)arguments.get("idToken");
        String accessToken = (String)arguments.get("accessToken");
        AuthCredential credential = GoogleAuthProvider.getCredential((String)idToken, (String)accessToken);
        firebaseAuth.signInWithCredential(credential).addOnCompleteListener((OnCompleteListener)new SignInCompleteListener(result));
    }

    private void handleReauthenticateWithEmailAndPassword(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        Map arguments = (Map)call.arguments;
        String email = (String)arguments.get("email");
        String password = (String)arguments.get("password");
        AuthCredential credential = EmailAuthProvider.getCredential((String)email, (String)password);
        firebaseAuth.getCurrentUser().reauthenticate(credential).addOnCompleteListener((OnCompleteListener)new TaskVoidCompleteListener(result));
    }

    private void handleReauthenticateWithGoogleCredential(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        Map arguments = (Map)call.arguments;
        String idToken = (String)arguments.get("idToken");
        String accessToken = (String)arguments.get("accessToken");
        AuthCredential credential = GoogleAuthProvider.getCredential((String)idToken, (String)accessToken);
        firebaseAuth.getCurrentUser().reauthenticate(credential).addOnCompleteListener((OnCompleteListener)new TaskVoidCompleteListener(result));
    }

    private void handleReauthenticateWithFacebookCredential(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        Map arguments = (Map)call.arguments;
        String accessToken = (String)arguments.get("accessToken");
        AuthCredential credential = FacebookAuthProvider.getCredential((String)accessToken);
        firebaseAuth.getCurrentUser().reauthenticate(credential).addOnCompleteListener((OnCompleteListener)new TaskVoidCompleteListener(result));
    }

    private void handleReauthenticateWithTwitterCredential(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        Map arguments = (Map)call.arguments;
        String authToken = (String)arguments.get("authToken");
        String authTokenSecret = (String)arguments.get("authTokenSecret");
        AuthCredential credential = TwitterAuthProvider.getCredential((String)authToken, (String)authTokenSecret);
        firebaseAuth.getCurrentUser().reauthenticate(credential).addOnCompleteListener((OnCompleteListener)new TaskVoidCompleteListener(result));
    }

    private void handleReauthenticateWithGithubCredential(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        String token = (String)call.argument("token");
        AuthCredential credential = GithubAuthProvider.getCredential((String)token);
        firebaseAuth.getCurrentUser().reauthenticate(credential).addOnCompleteListener((OnCompleteListener)new TaskVoidCompleteListener(result));
    }

    private void handleLinkWithGoogleCredential(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        Map arguments = (Map)call.arguments;
        String idToken = (String)arguments.get("idToken");
        String accessToken = (String)arguments.get("accessToken");
        AuthCredential credential = GoogleAuthProvider.getCredential((String)idToken, (String)accessToken);
        firebaseAuth.getCurrentUser().linkWithCredential(credential).addOnCompleteListener((OnCompleteListener)new SignInCompleteListener(result));
    }

    private void handleLinkWithFacebookCredential(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        Map arguments = (Map)call.arguments;
        String accessToken = (String)arguments.get("accessToken");
        AuthCredential credential = FacebookAuthProvider.getCredential((String)accessToken);
        firebaseAuth.getCurrentUser().linkWithCredential(credential).addOnCompleteListener((OnCompleteListener)new SignInCompleteListener(result));
    }

    private void handleLinkWithTwitterCredential(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        Map arguments = (Map)call.arguments;
        String authToken = (String)arguments.get("authToken");
        String authTokenSecret = (String)arguments.get("authTokenSecret");
        AuthCredential credential = TwitterAuthProvider.getCredential((String)authToken, (String)authTokenSecret);
        firebaseAuth.getCurrentUser().linkWithCredential(credential).addOnCompleteListener((OnCompleteListener)new SignInCompleteListener(result));
    }

    private void handleLinkWithGithubCredential(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        String token = (String)call.argument("token");
        AuthCredential credential = GithubAuthProvider.getCredential((String)token);
        firebaseAuth.getCurrentUser().linkWithCredential(credential).addOnCompleteListener((OnCompleteListener)new SignInCompleteListener(result));
    }

    private void handleSignInWithFacebook(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        Map arguments = (Map)call.arguments;
        String accessToken = (String)arguments.get("accessToken");
        AuthCredential credential = FacebookAuthProvider.getCredential((String)accessToken);
        firebaseAuth.signInWithCredential(credential).addOnCompleteListener((OnCompleteListener)new SignInCompleteListener(result));
    }

    private void handleSignInWithTwitter(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        String authToken = (String)call.argument("authToken");
        String authTokenSecret = (String)call.argument("authTokenSecret");
        AuthCredential credential = TwitterAuthProvider.getCredential((String)authToken, (String)authTokenSecret);
        firebaseAuth.signInWithCredential(credential).addOnCompleteListener((OnCompleteListener)new SignInCompleteListener(result));
    }

    private void handleSignInWithGithub(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        String token = (String)call.argument("token");
        AuthCredential credential = GithubAuthProvider.getCredential((String)token);
        firebaseAuth.signInWithCredential(credential).addOnCompleteListener((OnCompleteListener)new SignInCompleteListener(result));
    }

    private void handleSignInWithCustomToken(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        Map arguments = (Map)call.arguments();
        String token = (String)arguments.get("token");
        firebaseAuth.signInWithCustomToken(token).addOnCompleteListener((OnCompleteListener)new SignInCompleteListener(result));
    }

    private void handleSignOut(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        firebaseAuth.signOut();
        result.success(null);
    }

    private void handleGetToken(MethodCall call, final MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        Map arguments = (Map)call.arguments;
        boolean refresh = (Boolean)arguments.get("refresh");
        firebaseAuth.getCurrentUser().getIdToken(refresh).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<GetTokenResult>(){

            public void onComplete(@NonNull Task<GetTokenResult> task) {
                if (task.isSuccessful()) {
                    String idToken = ((GetTokenResult)task.getResult()).getToken();
                    result.success((Object)idToken);
                } else {
                    result.error(FirebaseAuthPlugin.ERROR_REASON_EXCEPTION, task.getException().getMessage(), null);
                }
            }
        });
    }

    private void handleUpdateEmail(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        Map arguments = (Map)call.arguments;
        firebaseAuth.getCurrentUser().updateEmail((String)arguments.get("email")).addOnCompleteListener((OnCompleteListener)new TaskVoidCompleteListener(result));
    }

    private void handleUpdatePassword(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        Map arguments = (Map)call.arguments;
        firebaseAuth.getCurrentUser().updatePassword((String)arguments.get("password")).addOnCompleteListener((OnCompleteListener)new TaskVoidCompleteListener(result));
    }

    private void handleUpdateProfile(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        Map arguments = (Map)call.arguments;
        UserProfileChangeRequest.Builder builder = new UserProfileChangeRequest.Builder();
        if (arguments.containsKey("displayName")) {
            builder.setDisplayName((String)arguments.get("displayName"));
        }
        if (arguments.containsKey("photoUrl")) {
            builder.setPhotoUri(Uri.parse((String)((String)arguments.get("photoUrl"))));
        }
        firebaseAuth.getCurrentUser().updateProfile(builder.build()).addOnCompleteListener((OnCompleteListener)new TaskVoidCompleteListener(result));
    }

    private void handleStartListeningAuthState(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        final int handle = this.nextHandle++;
        FirebaseAuth.AuthStateListener listener = new FirebaseAuth.AuthStateListener(){

            public void onAuthStateChanged(@NonNull FirebaseAuth firebaseAuth) {
                FirebaseUser user = firebaseAuth.getCurrentUser();
                Map userMap = FirebaseAuthPlugin.this.mapFromUser(user);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", handle);
                if (userMap != null) {
                    map.put("user", userMap);
                }
                FirebaseAuthPlugin.this.channel.invokeMethod("onAuthStateChanged", Collections.unmodifiableMap(map));
            }
        };
        firebaseAuth.addAuthStateListener(listener);
        this.authStateListeners.append(handle, (Object)listener);
        result.success((Object)handle);
    }

    private void handleStopListeningAuthState(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        Map arguments = (Map)call.arguments();
        Integer id = (Integer)arguments.get("id");
        FirebaseAuth.AuthStateListener listener = (FirebaseAuth.AuthStateListener)this.authStateListeners.get(id.intValue());
        if (listener != null) {
            firebaseAuth.removeAuthStateListener(listener);
            this.authStateListeners.remove(id.intValue());
            result.success(null);
        } else {
            result.error(ERROR_REASON_EXCEPTION, String.format("Listener with identifier '%d' not found.", id), null);
        }
    }

    private void handleSetLanguageCode(MethodCall call, MethodChannel.Result result, FirebaseAuth firebaseAuth) {
        Map arguments = (Map)call.arguments;
        String language = (String)arguments.get("language");
        firebaseAuth.setLanguageCode(language);
        result.success(null);
    }

    private Map<String, Object> userInfoToMap(UserInfo userInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("providerId", userInfo.getProviderId());
        map.put("uid", userInfo.getUid());
        if (userInfo.getDisplayName() != null) {
            map.put("displayName", userInfo.getDisplayName());
        }
        if (userInfo.getPhotoUrl() != null) {
            map.put("photoUrl", userInfo.getPhotoUrl().toString());
        }
        if (userInfo.getEmail() != null) {
            map.put("email", userInfo.getEmail());
        }
        if (userInfo.getPhoneNumber() != null) {
            map.put("phoneNumber", userInfo.getPhoneNumber());
        }
        return map;
    }

    private Map<String, Object> mapFromUser(FirebaseUser user) {
        if (user != null) {
            ArrayList<Map<String, Object>> providerData = new ArrayList<Map<String, Object>>();
            for (UserInfo userInfo : user.getProviderData()) {
                if (userInfo.getProviderId().equals("phone")) continue;
                providerData.add(Collections.unmodifiableMap(this.userInfoToMap(userInfo)));
            }
            Map<String, Object> userMap = this.userInfoToMap((UserInfo)user);
            userMap.put("creationTimestamp", user.getMetadata().getCreationTimestamp());
            userMap.put("lastSignInTimestamp", user.getMetadata().getLastSignInTimestamp());
            userMap.put("isAnonymous", user.isAnonymous());
            userMap.put("isEmailVerified", user.isEmailVerified());
            userMap.put("providerData", Collections.unmodifiableList(providerData));
            return Collections.unmodifiableMap(userMap);
        }
        return null;
    }

    private class ProvidersCompleteListener
    implements OnCompleteListener<ProviderQueryResult> {
        private final MethodChannel.Result result;

        ProvidersCompleteListener(MethodChannel.Result result) {
            this.result = result;
        }

        public void onComplete(@NonNull Task<ProviderQueryResult> task) {
            if (!task.isSuccessful()) {
                Exception e = task.getException();
                this.result.error(FirebaseAuthPlugin.ERROR_REASON_EXCEPTION, e.getMessage(), null);
            } else {
                List providers = ((ProviderQueryResult)task.getResult()).getProviders();
                this.result.success((Object)providers);
            }
        }
    }

    private class TaskVoidCompleteListener
    implements OnCompleteListener<Void> {
        private final MethodChannel.Result result;

        TaskVoidCompleteListener(MethodChannel.Result result) {
            this.result = result;
        }

        public void onComplete(@NonNull Task<Void> task) {
            if (!task.isSuccessful()) {
                Exception e = task.getException();
                this.result.error(FirebaseAuthPlugin.ERROR_REASON_EXCEPTION, e.getMessage(), null);
            } else {
                this.result.success(null);
            }
        }
    }

    private class SignInCompleteListener
    implements OnCompleteListener<AuthResult> {
        private final MethodChannel.Result result;

        SignInCompleteListener(MethodChannel.Result result) {
            this.result = result;
        }

        public void onComplete(@NonNull Task<AuthResult> task) {
            if (!task.isSuccessful()) {
                Exception e = task.getException();
                this.result.error(FirebaseAuthPlugin.ERROR_REASON_EXCEPTION, e.getMessage(), null);
            } else {
                FirebaseUser user = ((AuthResult)task.getResult()).getUser();
                Map userMap = Collections.unmodifiableMap(FirebaseAuthPlugin.this.mapFromUser(user));
                this.result.success(userMap);
            }
        }
    }
}

