/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.firebase.database;

import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.MutableData;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import com.google.firebase.database.ValueEventListener;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FirebaseDatabasePlugin
implements MethodChannel.MethodCallHandler {
    private static final String TAG = "FirebaseDatabasePlugin";
    private final MethodChannel channel;
    private static final String EVENT_TYPE_CHILD_ADDED = "_EventType.childAdded";
    private static final String EVENT_TYPE_CHILD_REMOVED = "_EventType.childRemoved";
    private static final String EVENT_TYPE_CHILD_CHANGED = "_EventType.childChanged";
    private static final String EVENT_TYPE_CHILD_MOVED = "_EventType.childMoved";
    private static final String EVENT_TYPE_VALUE = "_EventType.value";
    private int nextHandle = 0;
    private final SparseArray<EventObserver> observers = new SparseArray();

    public static void registerWith(PluginRegistry.Registrar registrar) {
        MethodChannel channel = new MethodChannel(registrar.messenger(), "plugins.flutter.io/firebase_database");
        channel.setMethodCallHandler((MethodChannel.MethodCallHandler)new FirebaseDatabasePlugin(channel));
    }

    private FirebaseDatabasePlugin(MethodChannel channel) {
        this.channel = channel;
    }

    private DatabaseReference getReference(FirebaseDatabase database, Map<String, Object> arguments) {
        String path = (String)arguments.get("path");
        DatabaseReference reference = database.getReference();
        if (path != null) {
            reference = reference.child(path);
        }
        return reference;
    }

    private Query getQuery(FirebaseDatabase database, Map<String, Object> arguments) {
        DatabaseReference query = this.getReference(database, arguments);
        Map parameters = (Map)arguments.get("parameters");
        if (parameters == null) {
            return query;
        }
        Object orderBy = parameters.get("orderBy");
        if ("child".equals(orderBy)) {
            query = query.orderByChild((String)parameters.get("orderByChildKey"));
        } else if ("key".equals(orderBy)) {
            query = query.orderByKey();
        } else if ("value".equals(orderBy)) {
            query = query.orderByValue();
        } else if ("priority".equals(orderBy)) {
            query = query.orderByPriority();
        }
        if (parameters.containsKey("startAt")) {
            Object startAt = parameters.get("startAt");
            if (parameters.containsKey("startAtKey")) {
                String startAtKey = (String)parameters.get("startAtKey");
                query = startAt instanceof Boolean ? query.startAt(((Boolean)startAt).booleanValue(), startAtKey) : (startAt instanceof Number ? query.startAt(((Number)startAt).doubleValue(), startAtKey) : query.startAt((String)startAt, startAtKey));
            } else {
                query = startAt instanceof Boolean ? query.startAt(((Boolean)startAt).booleanValue()) : (startAt instanceof Number ? query.startAt(((Number)startAt).doubleValue()) : query.startAt((String)startAt));
            }
        }
        if (parameters.containsKey("endAt")) {
            Object endAt = parameters.get("endAt");
            if (parameters.containsKey("endAtKey")) {
                String endAtKey = (String)parameters.get("endAtKey");
                query = endAt instanceof Boolean ? query.endAt(((Boolean)endAt).booleanValue(), endAtKey) : (endAt instanceof Number ? query.endAt(((Number)endAt).doubleValue(), endAtKey) : query.endAt((String)endAt, endAtKey));
            } else {
                query = endAt instanceof Boolean ? query.endAt(((Boolean)endAt).booleanValue()) : (endAt instanceof Number ? query.endAt(((Number)endAt).doubleValue()) : query.endAt((String)endAt));
            }
        }
        if (parameters.containsKey("equalTo")) {
            Object equalTo = parameters.get("equalTo");
            if (parameters.containsKey("equalToKey")) {
                String equalToKey = (String)parameters.get("equalToKey");
                query = equalTo instanceof Boolean ? query.equalTo(((Boolean)equalTo).booleanValue(), equalToKey) : (equalTo instanceof Number ? query.equalTo(((Number)equalTo).doubleValue(), equalToKey) : query.equalTo((String)equalTo, equalToKey));
            } else {
                query = equalTo instanceof Boolean ? query.equalTo(((Boolean)equalTo).booleanValue()) : (equalTo instanceof Number ? query.equalTo(((Number)equalTo).doubleValue()) : query.equalTo((String)equalTo));
            }
        }
        if (parameters.containsKey("limitToFirst")) {
            query = query.limitToFirst(((Integer)parameters.get("limitToFirst")).intValue());
        }
        if (parameters.containsKey("limitToLast")) {
            query = query.limitToLast(((Integer)parameters.get("limitToLast")).intValue());
        }
        return query;
    }

    public void onMethodCall(MethodCall call, final MethodChannel.Result result) {
        final Map arguments = (Map)call.arguments();
        String appName = (String)arguments.get("app");
        String databaseURL = (String)arguments.get("databaseURL");
        FirebaseDatabase database = appName != null && databaseURL != null ? FirebaseDatabase.getInstance((FirebaseApp)FirebaseApp.getInstance((String)appName), (String)databaseURL) : (appName != null ? FirebaseDatabase.getInstance((FirebaseApp)FirebaseApp.getInstance((String)appName)) : (databaseURL != null ? FirebaseDatabase.getInstance((String)databaseURL) : FirebaseDatabase.getInstance()));
        switch (call.method) {
            case "FirebaseDatabase#goOnline": {
                database.goOnline();
                result.success(null);
                break;
            }
            case "FirebaseDatabase#goOffline": {
                database.goOffline();
                result.success(null);
                break;
            }
            case "FirebaseDatabase#purgeOutstandingWrites": {
                database.purgeOutstandingWrites();
                result.success(null);
                break;
            }
            case "FirebaseDatabase#setPersistenceEnabled": {
                Boolean isEnabled = (Boolean)arguments.get("enabled");
                try {
                    database.setPersistenceEnabled(isEnabled.booleanValue());
                    result.success((Object)true);
                }
                catch (DatabaseException e) {
                    result.success((Object)false);
                }
                break;
            }
            case "FirebaseDatabase#setPersistenceCacheSizeBytes": {
                long cacheSize = ((Integer)arguments.get("cacheSize")).intValue();
                try {
                    database.setPersistenceCacheSizeBytes(cacheSize);
                    result.success((Object)true);
                }
                catch (DatabaseException e) {
                    result.success((Object)false);
                }
                break;
            }
            case "DatabaseReference#set": {
                Object value = arguments.get("value");
                Object priority = arguments.get("priority");
                DatabaseReference reference = this.getReference(database, arguments);
                if (priority != null) {
                    reference.setValue(value, priority, (DatabaseReference.CompletionListener)new DefaultCompletionListener(result));
                    break;
                }
                reference.setValue(value, (DatabaseReference.CompletionListener)new DefaultCompletionListener(result));
                break;
            }
            case "DatabaseReference#update": {
                Map value = (Map)arguments.get("value");
                DatabaseReference reference = this.getReference(database, arguments);
                reference.updateChildren(value, (DatabaseReference.CompletionListener)new DefaultCompletionListener(result));
                break;
            }
            case "DatabaseReference#setPriority": {
                Object priority = arguments.get("priority");
                DatabaseReference reference = this.getReference(database, arguments);
                reference.setPriority(priority, (DatabaseReference.CompletionListener)new DefaultCompletionListener(result));
                break;
            }
            case "DatabaseReference#runTransaction": {
                final DatabaseReference reference = this.getReference(database, arguments);
                reference.runTransaction(new Transaction.Handler(){

                    public Transaction.Result doTransaction(MutableData mutableData) {
                        final TaskCompletionSource updateMutableDataTCS = new TaskCompletionSource();
                        Task updateMutableDataTCSTask = updateMutableDataTCS.getTask();
                        HashMap doTransactionMap = new HashMap();
                        doTransactionMap.put("transactionKey", arguments.get("transactionKey"));
                        HashMap<String, Object> snapshotMap = new HashMap<String, Object>();
                        snapshotMap.put("key", mutableData.getKey());
                        snapshotMap.put("value", mutableData.getValue());
                        doTransactionMap.put("snapshot", snapshotMap);
                        FirebaseDatabasePlugin.this.channel.invokeMethod("DoTransaction", doTransactionMap, new MethodChannel.Result(){

                            public void success(Object result) {
                                updateMutableDataTCS.setResult((Object)((Map)result));
                            }

                            public void error(String errorCode, String errorMessage, Object errorDetails) {
                                String exceptionMessage = "Error code: " + errorCode + "\nError message: " + errorMessage + "\nError details: " + errorDetails;
                                updateMutableDataTCS.setException(new Exception(exceptionMessage));
                            }

                            public void notImplemented() {
                                updateMutableDataTCS.setException(new Exception("DoTransaction not implemented on Dart side."));
                            }
                        });
                        try {
                            Map updatedSnapshotMap = (Map)Tasks.await((Task)updateMutableDataTCSTask, (long)((Integer)arguments.get("transactionTimeout")).intValue(), (TimeUnit)TimeUnit.MILLISECONDS);
                            mutableData.setValue(updatedSnapshotMap.get("value"));
                        }
                        catch (InterruptedException | ExecutionException | TimeoutException e) {
                            Log.e((String)FirebaseDatabasePlugin.TAG, (String)"Unable to commit Snapshot update. Transaction failed.", (Throwable)e);
                            if (e instanceof TimeoutException) {
                                Log.e((String)FirebaseDatabasePlugin.TAG, (String)("Transaction at " + reference.toString() + " timed out."));
                            }
                            return Transaction.abort();
                        }
                        return Transaction.success((MutableData)mutableData);
                    }

                    public void onComplete(DatabaseError databaseError, boolean committed, DataSnapshot dataSnapshot) {
                        HashMap completionMap = new HashMap();
                        completionMap.put("transactionKey", arguments.get("transactionKey"));
                        if (databaseError != null) {
                            completionMap.put("error", FirebaseDatabasePlugin.asMap(databaseError));
                        }
                        completionMap.put("committed", committed);
                        if (dataSnapshot != null) {
                            HashMap<String, Object> snapshotMap = new HashMap<String, Object>();
                            snapshotMap.put("key", dataSnapshot.getKey());
                            snapshotMap.put("value", dataSnapshot.getValue());
                            completionMap.put("snapshot", snapshotMap);
                        }
                        result.success(completionMap);
                    }
                });
                break;
            }
            case "OnDisconnect#set": {
                Object value = arguments.get("value");
                Object priority = arguments.get("priority");
                DatabaseReference reference = this.getReference(database, arguments);
                if (priority != null) {
                    if (priority instanceof String) {
                        reference.onDisconnect().setValue(value, (String)priority, (DatabaseReference.CompletionListener)new DefaultCompletionListener(result));
                        break;
                    }
                    if (priority instanceof Double) {
                        reference.onDisconnect().setValue(value, ((Double)priority).doubleValue(), (DatabaseReference.CompletionListener)new DefaultCompletionListener(result));
                        break;
                    }
                    if (!(priority instanceof Map)) break;
                    reference.onDisconnect().setValue(value, (Map)priority, (DatabaseReference.CompletionListener)new DefaultCompletionListener(result));
                    break;
                }
                reference.onDisconnect().setValue(value, (DatabaseReference.CompletionListener)new DefaultCompletionListener(result));
                break;
            }
            case "OnDisconnect#update": {
                Map value = (Map)arguments.get("value");
                DatabaseReference reference = this.getReference(database, arguments);
                reference.onDisconnect().updateChildren(value, (DatabaseReference.CompletionListener)new DefaultCompletionListener(result));
                break;
            }
            case "OnDisconnect#cancel": {
                DatabaseReference reference = this.getReference(database, arguments);
                reference.onDisconnect().cancel((DatabaseReference.CompletionListener)new DefaultCompletionListener(result));
                break;
            }
            case "Query#keepSynced": {
                boolean value = (Boolean)arguments.get("value");
                this.getQuery(database, arguments).keepSynced(value);
                result.success(null);
                break;
            }
            case "Query#observe": {
                String eventType = (String)arguments.get("eventType");
                int handle = this.nextHandle++;
                EventObserver observer = new EventObserver(eventType, handle);
                this.observers.put(handle, (Object)observer);
                if (eventType.equals(EVENT_TYPE_VALUE)) {
                    this.getQuery(database, arguments).addValueEventListener((ValueEventListener)observer);
                } else {
                    this.getQuery(database, arguments).addChildEventListener((ChildEventListener)observer);
                }
                result.success((Object)handle);
                break;
            }
            case "Query#removeObserver": {
                Query query = this.getQuery(database, arguments);
                int handle = (Integer)arguments.get("handle");
                EventObserver observer = (EventObserver)this.observers.get(handle);
                if (observer != null) {
                    if (observer.requestedEventType.equals(EVENT_TYPE_VALUE)) {
                        query.removeEventListener((ValueEventListener)observer);
                    } else {
                        query.removeEventListener((ChildEventListener)observer);
                    }
                    this.observers.delete(handle);
                    result.success(null);
                    break;
                }
                result.error("unknown_handle", "removeObserver called on an unknown handle", null);
                break;
            }
            default: {
                result.notImplemented();
            }
        }
    }

    private static Map<String, Object> asMap(DatabaseError error) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", error.getCode());
        map.put("message", error.getMessage());
        map.put("details", error.getDetails());
        return map;
    }

    private class EventObserver
    implements ChildEventListener,
    ValueEventListener {
        private String requestedEventType;
        private int handle;

        EventObserver(String requestedEventType, int handle) {
            this.requestedEventType = requestedEventType;
            this.handle = handle;
        }

        private void sendEvent(String eventType, DataSnapshot snapshot, String previousChildName) {
            if (eventType.equals(this.requestedEventType)) {
                HashMap<String, Object> arguments = new HashMap<String, Object>();
                HashMap<String, Object> snapshotMap = new HashMap<String, Object>();
                snapshotMap.put("key", snapshot.getKey());
                snapshotMap.put("value", snapshot.getValue());
                arguments.put("handle", this.handle);
                arguments.put("snapshot", snapshotMap);
                arguments.put("previousSiblingKey", previousChildName);
                FirebaseDatabasePlugin.this.channel.invokeMethod("Event", arguments);
            }
        }

        public void onCancelled(DatabaseError error) {
            HashMap<String, Object> arguments = new HashMap<String, Object>();
            arguments.put("handle", this.handle);
            arguments.put("error", FirebaseDatabasePlugin.asMap(error));
            FirebaseDatabasePlugin.this.channel.invokeMethod("Error", arguments);
        }

        public void onChildAdded(DataSnapshot snapshot, String previousChildName) {
            this.sendEvent(FirebaseDatabasePlugin.EVENT_TYPE_CHILD_ADDED, snapshot, previousChildName);
        }

        public void onChildRemoved(DataSnapshot snapshot) {
            this.sendEvent(FirebaseDatabasePlugin.EVENT_TYPE_CHILD_REMOVED, snapshot, null);
        }

        public void onChildChanged(DataSnapshot snapshot, String previousChildName) {
            this.sendEvent(FirebaseDatabasePlugin.EVENT_TYPE_CHILD_CHANGED, snapshot, previousChildName);
        }

        public void onChildMoved(DataSnapshot snapshot, String previousChildName) {
            this.sendEvent(FirebaseDatabasePlugin.EVENT_TYPE_CHILD_MOVED, snapshot, previousChildName);
        }

        public void onDataChange(DataSnapshot snapshot) {
            this.sendEvent(FirebaseDatabasePlugin.EVENT_TYPE_VALUE, snapshot, null);
        }
    }

    private class DefaultCompletionListener
    implements DatabaseReference.CompletionListener {
        private final MethodChannel.Result result;

        DefaultCompletionListener(MethodChannel.Result result) {
            this.result = result;
        }

        public void onComplete(DatabaseError error, DatabaseReference ref) {
            if (error != null) {
                this.result.error(String.valueOf(error.getCode()), error.getMessage(), (Object)error.getDetails());
            } else {
                this.result.success(null);
            }
        }
    }
}

