/*
 * Decompiled with CFR 0.152.
 */
package com.tekartik.sqflite;

import android.database.sqlite.SQLiteDatabase;
import android.util.Log;

class Database {
    final boolean singleInstance;
    final String path;
    final int id;
    final int logLevel;
    SQLiteDatabase sqliteDatabase;

    Database(String path, int id, boolean singleInstance, int logLevel) {
        this.path = path;
        this.singleInstance = singleInstance;
        this.id = id;
        this.logLevel = logLevel;
    }

    public void open() {
        this.sqliteDatabase = SQLiteDatabase.openDatabase((String)this.path, null, (int)0x10000000);
    }

    public void openReadOnly() {
        this.sqliteDatabase = SQLiteDatabase.openDatabase((String)this.path, null, (int)1);
    }

    public void close() {
        this.sqliteDatabase.close();
    }

    public SQLiteDatabase getWritableDatabase() {
        return this.sqliteDatabase;
    }

    public SQLiteDatabase getReadableDatabase() {
        return this.sqliteDatabase;
    }

    public boolean enableWriteAheadLogging() {
        try {
            return this.sqliteDatabase.enableWriteAheadLogging();
        }
        catch (Exception e) {
            Log.e((String)"Sqflite", (String)("enable WAL error: " + e));
            return false;
        }
    }

    String getThreadLogTag() {
        Thread thread = Thread.currentThread();
        return "" + this.id + "," + thread.getName() + "(" + thread.getId() + ")";
    }
}

