/*
 * Decompiled with CFR 0.152.
 */
package com.tekartik.sqflite;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteCantOpenDatabaseException;
import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.tekartik.sqflite.Database;
import com.tekartik.sqflite.LogLevel;
import com.tekartik.sqflite.SqlCommand;
import com.tekartik.sqflite.dev.Debug;
import com.tekartik.sqflite.operation.BatchOperation;
import com.tekartik.sqflite.operation.ExecuteOperation;
import com.tekartik.sqflite.operation.MethodCallOperation;
import com.tekartik.sqflite.operation.Operation;
import com.tekartik.sqflite.operation.SqlErrorInfo;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import java.io.File;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SqflitePlugin
implements MethodChannel.MethodCallHandler {
    static final Map<String, Integer> _singleInstancesByPath = new HashMap<String, Integer>();
    private static boolean QUERY_AS_MAP_LIST = false;
    private static int THREAD_PRIORITY = 10;
    static int logLevel = 0;
    private final Object databaseMapLocker = new Object();
    private final Object openCloseLocker = new Object();
    String databasesPath;
    private Context context;
    private int databaseId = 0;
    private HandlerThread handlerThread;
    private Handler handler;
    @SuppressLint(value={"UseSparseArrays"})
    private final Map<Integer, Database> databaseMap = new HashMap<Integer, Database>();

    SqflitePlugin(Context context) {
        this.context = context;
    }

    public static void registerWith(PluginRegistry.Registrar registrar) {
        MethodChannel channel = new MethodChannel(registrar.messenger(), "com.tekartik.sqflite");
        channel.setMethodCallHandler((MethodChannel.MethodCallHandler)new SqflitePlugin(registrar.context()));
    }

    private static Object cursorValue(Cursor cursor, int index) {
        switch (cursor.getType(index)) {
            case 0: {
                return null;
            }
            case 1: {
                return cursor.getLong(index);
            }
            case 2: {
                return cursor.getDouble(index);
            }
            case 3: {
                return cursor.getString(index);
            }
            case 4: {
                return cursor.getBlob(index);
            }
        }
        return null;
    }

    private static List<Object> cursorRowToList(Cursor cursor, int length) {
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            Object value = SqflitePlugin.cursorValue(cursor, i);
            if (Debug.EXTRA_LOGV) {
                String type = null;
                if (value != null) {
                    type = value.getClass().isArray() ? "array(" + value.getClass().getComponentType().getName() + ")" : value.getClass().getName();
                }
                Log.d((String)"Sqflite", (String)("column " + i + " " + cursor.getType(i) + ": " + value + (type == null ? "" : " (" + type + ")")));
            }
            list.add(value);
        }
        return list;
    }

    private static Map<String, Object> cursorRowToMap(Cursor cursor) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] columns = cursor.getColumnNames();
        int length = columns.length;
        block7: for (int i = 0; i < length; ++i) {
            if (Debug.EXTRA_LOGV) {
                Log.d((String)"Sqflite", (String)("column " + i + " " + cursor.getType(i)));
            }
            switch (cursor.getType(i)) {
                case 0: {
                    map.put(columns[i], null);
                    continue block7;
                }
                case 1: {
                    map.put(columns[i], cursor.getLong(i));
                    continue block7;
                }
                case 2: {
                    map.put(columns[i], cursor.getDouble(i));
                    continue block7;
                }
                case 3: {
                    map.put(columns[i], cursor.getString(i));
                    continue block7;
                }
                case 4: {
                    map.put(columns[i], cursor.getBlob(i));
                }
            }
        }
        return map;
    }

    private static Map<String, Object> fixMap(Map<Object, Object> map) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Map<String, Object> value = entry.getValue();
            if (value instanceof Map) {
                Map mapValue = value;
                value = SqflitePlugin.fixMap(mapValue);
            } else {
                value = SqflitePlugin.toString(value);
            }
            newMap.put(SqflitePlugin.toString(entry.getKey()), value);
        }
        return newMap;
    }

    private static String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (byte _byte : (byte[])value) {
                list.add(Integer.valueOf(_byte));
            }
            return ((Object)list).toString();
        }
        if (value instanceof Map) {
            Map mapValue = (Map)value;
            return SqflitePlugin.fixMap(mapValue).toString();
        }
        return value.toString();
    }

    static boolean isInMemoryPath(String path) {
        return path == null || path.equals(":memory:");
    }

    private Context getContext() {
        return this.context;
    }

    private Database getDatabase(int databaseId) {
        return this.databaseMap.get(databaseId);
    }

    private Database getDatabaseOrError(MethodCall call, MethodChannel.Result result) {
        int databaseId = (Integer)call.argument("id");
        Database database = this.getDatabase(databaseId);
        if (database != null) {
            return database;
        }
        result.error("sqlite_error", "database_closed " + databaseId, null);
        return null;
    }

    private SqlCommand getSqlCommand(MethodCall call) {
        String sql = (String)call.argument("sql");
        List arguments = (List)call.argument("arguments");
        return new SqlCommand(sql, arguments);
    }

    private Database executeOrError(Database database, MethodCall call, MethodChannel.Result result) {
        SqlCommand command = this.getSqlCommand(call);
        return this.executeOrError(database, command, result);
    }

    private boolean executeOrError(Database database, Operation operation) {
        SqlCommand command = operation.getSqlCommand();
        if (LogLevel.hasSqlLevel(database.logLevel)) {
            Log.d((String)"Sqflite", (String)("[" + database.getThreadLogTag() + "] " + command));
        }
        try {
            database.getWritableDatabase().execSQL(command.getSql(), command.getSqlArguments());
            return true;
        }
        catch (Exception exception) {
            this.handleException(exception, operation, database);
            return false;
        }
    }

    private Database executeOrError(Database database, SqlCommand command, MethodChannel.Result result) {
        if (LogLevel.hasSqlLevel(database.logLevel)) {
            Log.d((String)"Sqflite", (String)("[" + database.getThreadLogTag() + "] " + command));
        }
        try {
            database.getWritableDatabase().execSQL(command.getSql(), command.getSqlArguments());
        }
        catch (Exception exception) {
            ExecuteOperation operation = new ExecuteOperation(result, command);
            this.handleException(exception, operation, database);
            return null;
        }
        return database;
    }

    private void onQueryCall(final MethodCall call, MethodChannel.Result result) {
        final Database database = this.getDatabaseOrError(call, result);
        if (database == null) {
            return;
        }
        final BgResult bgResult = new BgResult(result);
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                MethodCallOperation operation = new MethodCallOperation(call, bgResult);
                SqflitePlugin.this.query(database, operation);
            }
        });
    }

    private void onBatchCall(final MethodCall call, MethodChannel.Result result) {
        final Database database = this.getDatabaseOrError(call, result);
        if (database == null) {
            return;
        }
        final BgResult bgResult = new BgResult(result);
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                MethodCallOperation mainOperation = new MethodCallOperation(call, bgResult);
                boolean noResult = mainOperation.getNoResult();
                boolean continueOnError = mainOperation.getContinueOnError();
                List operations = (List)call.argument("operations");
                ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
                block12: for (Map map : operations) {
                    String method;
                    BatchOperation operation = new BatchOperation(map, noResult);
                    switch (method = operation.getMethod()) {
                        case "execute": {
                            if (SqflitePlugin.this.execute(database, operation)) {
                                operation.handleSuccess(results);
                                continue block12;
                            }
                            if (continueOnError) {
                                operation.handleErrorContinue(results);
                                continue block12;
                            }
                            operation.handleError(bgResult);
                            return;
                        }
                        case "insert": {
                            if (SqflitePlugin.this.insert(database, operation)) {
                                operation.handleSuccess(results);
                                continue block12;
                            }
                            if (continueOnError) {
                                operation.handleErrorContinue(results);
                                continue block12;
                            }
                            operation.handleError(bgResult);
                            return;
                        }
                        case "query": {
                            if (SqflitePlugin.this.query(database, operation)) {
                                operation.handleSuccess(results);
                                continue block12;
                            }
                            if (continueOnError) {
                                operation.handleErrorContinue(results);
                                continue block12;
                            }
                            operation.handleError(bgResult);
                            return;
                        }
                        case "update": {
                            if (SqflitePlugin.this.update(database, operation)) {
                                operation.handleSuccess(results);
                                continue block12;
                            }
                            if (continueOnError) {
                                operation.handleErrorContinue(results);
                                continue block12;
                            }
                            operation.handleError(bgResult);
                            return;
                        }
                    }
                    bgResult.error("bad_param", "Batch method '" + method + "' not supported", null);
                    return;
                }
                if (noResult) {
                    bgResult.success(null);
                } else {
                    bgResult.success(results);
                }
            }
        });
    }

    private boolean execute(Database database, Operation operation) {
        if (!this.executeOrError(database, operation)) {
            return false;
        }
        operation.success(null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insert(Database database, Operation operation) {
        if (!this.executeOrError(database, operation)) {
            return false;
        }
        if (operation.getNoResult()) {
            operation.success(null);
            return true;
        }
        String sql = "SELECT changes(), last_insert_rowid()";
        try (Cursor cursor = null;){
            SQLiteDatabase db = database.getWritableDatabase();
            cursor = db.rawQuery(sql, null);
            if (cursor != null && cursor.getCount() > 0 && cursor.moveToFirst()) {
                int changed = cursor.getInt(0);
                if (changed == 0) {
                    if (LogLevel.hasSqlLevel(database.logLevel)) {
                        Log.d((String)"Sqflite", (String)("no changes (id was " + cursor.getLong(1) + ")"));
                    }
                    operation.success(null);
                    boolean bl = true;
                    return bl;
                }
                long id = cursor.getLong(1);
                if (LogLevel.hasSqlLevel(database.logLevel)) {
                    Log.d((String)"Sqflite", (String)("inserted " + id));
                }
                operation.success(id);
                boolean bl = true;
                return bl;
            }
            Log.e((String)"Sqflite", (String)"fail to read changes for Insert");
            operation.success(null);
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean query(Database database, Operation operation) {
        SqlCommand command = operation.getSqlCommand();
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        HashMap<String, List<Object>> newResults = null;
        ArrayList<List<Object>> rows = null;
        int newColumnCount = 0;
        if (LogLevel.hasSqlLevel(database.logLevel)) {
            Log.d((String)"Sqflite", (String)("[" + Thread.currentThread() + "] " + command));
        }
        boolean queryAsMapList = QUERY_AS_MAP_LIST;
        try (Cursor cursor = null;){
            command = command.sanitizeForQuery();
            cursor = database.getReadableDatabase().rawQuery(command.getSql(), command.getQuerySqlArguments());
            while (cursor.moveToNext()) {
                if (queryAsMapList) {
                    Map<String, Object> map = SqflitePlugin.cursorRowToMap(cursor);
                    if (LogLevel.hasSqlLevel(database.logLevel)) {
                        Log.d((String)"Sqflite", (String)SqflitePlugin.toString(map));
                    }
                    results.add(map);
                    continue;
                }
                if (newResults == null) {
                    rows = new ArrayList<List<Object>>();
                    newResults = new HashMap();
                    newColumnCount = cursor.getColumnCount();
                    newResults.put("columns", Arrays.asList(cursor.getColumnNames()));
                    newResults.put("rows", rows);
                }
                rows.add(SqflitePlugin.cursorRowToList(cursor, newColumnCount));
            }
            if (queryAsMapList) {
                operation.success(results);
            } else {
                if (newResults == null) {
                    newResults = new HashMap<String, List<Object>>();
                }
                operation.success(newResults);
            }
            boolean map = true;
            return map;
        }
    }

    private void onInsertCall(final MethodCall call, MethodChannel.Result result) {
        final Database database = this.getDatabaseOrError(call, result);
        if (database == null) {
            return;
        }
        final BgResult bgResult = new BgResult(result);
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                MethodCallOperation operation = new MethodCallOperation(call, bgResult);
                SqflitePlugin.this.insert(database, operation);
            }
        });
    }

    private void onExecuteCall(final MethodCall call, MethodChannel.Result result) {
        final Database database = this.getDatabaseOrError(call, result);
        if (database == null) {
            return;
        }
        final BgResult bgResult = new BgResult(result);
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (SqflitePlugin.this.executeOrError(database, call, bgResult) == null) {
                    return;
                }
                bgResult.success(null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update(Database database, Operation operation) {
        if (!this.executeOrError(database, operation)) {
            return false;
        }
        if (operation.getNoResult()) {
            operation.success(null);
            return true;
        }
        try (Cursor cursor = null;){
            SQLiteDatabase db = database.getWritableDatabase();
            cursor = db.rawQuery("SELECT changes()", null);
            if (cursor != null && cursor.getCount() > 0 && cursor.moveToFirst()) {
                int changed = cursor.getInt(0);
                if (LogLevel.hasSqlLevel(database.logLevel)) {
                    Log.d((String)"Sqflite", (String)("changed " + changed));
                }
                operation.success(changed);
                boolean bl = true;
                return bl;
            }
            Log.e((String)"Sqflite", (String)"fail to read changes for Update/Delete");
            operation.success(null);
            boolean bl = true;
            return bl;
        }
    }

    private void onUpdateCall(final MethodCall call, MethodChannel.Result result) {
        final Database database = this.getDatabaseOrError(call, result);
        if (database == null) {
            return;
        }
        final BgResult bgResult = new BgResult(result);
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                MethodCallOperation operation = new MethodCallOperation(call, bgResult);
                SqflitePlugin.this.update(database, operation);
            }
        });
    }

    private void handleException(Exception exception, Operation operation, Database database) {
        if (exception instanceof SQLiteCantOpenDatabaseException) {
            operation.error("sqlite_error", "open_failed " + database.path, null);
            return;
        }
        if (exception instanceof SQLException) {
            operation.error("sqlite_error", exception.getMessage(), SqlErrorInfo.getMap(operation));
            return;
        }
        operation.error("sqlite_error", exception.getMessage(), SqlErrorInfo.getMap(operation));
    }

    static Map makeOpenResult(int databaseId, boolean recovered) {
        HashMap<String, Constable> result = new HashMap<String, Constable>();
        result.put("id", Integer.valueOf(databaseId));
        if (recovered) {
            result.put("recovered", Boolean.valueOf(true));
        }
        return result;
    }

    private void onDebugCall(MethodCall call, MethodChannel.Result result) {
        String cmd = (String)call.argument("cmd");
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        if ("get".equals(cmd)) {
            if (logLevel > 0) {
                map.put("logLevel", Integer.valueOf(logLevel));
            }
            if (!this.databaseMap.isEmpty()) {
                HashMap databasesInfo = new HashMap();
                for (Map.Entry<Integer, Database> entry : this.databaseMap.entrySet()) {
                    Database database = entry.getValue();
                    HashMap<String, Object> info = new HashMap<String, Object>();
                    info.put("path", database.path);
                    info.put("singleInstance", database.singleInstance);
                    if (database.logLevel > 0) {
                        info.put("logLevel", database.logLevel);
                    }
                    databasesInfo.put(entry.getKey().toString(), info);
                }
                map.put("databases", databasesInfo);
            }
        }
        result.success(map);
    }

    private void onDebugModeCall(MethodCall call, MethodChannel.Result result) {
        Object on = call.arguments();
        Debug.LOGV = Boolean.TRUE.equals(on);
        boolean bl = Debug.EXTRA_LOGV = Debug._EXTRA_LOGV && Debug.LOGV;
        if (Debug.LOGV) {
            if (Debug.EXTRA_LOGV) {
                logLevel = 2;
            } else if (Debug.LOGV) {
                logLevel = 1;
            }
        } else {
            logLevel = 0;
        }
        result.success(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onOpenDatabaseCall(final MethodCall call, MethodChannel.Result result) {
        int newDatabaseId;
        Database database;
        Object databaseId;
        boolean singleInstance;
        final String path = (String)call.argument("path");
        final Boolean readOnly = (Boolean)call.argument("readOnly");
        final boolean inMemory = SqflitePlugin.isInMemoryPath(path);
        boolean bl = singleInstance = !Boolean.FALSE.equals(call.argument("singleInstance")) && !inMemory;
        if (singleInstance) {
            Object object = this.databaseMapLocker;
            synchronized (object) {
                if (LogLevel.hasVerboseLevel(logLevel)) {
                    Log.d((String)"Sqflite", (String)("Look for " + path + " in " + _singleInstancesByPath.keySet()));
                }
                if ((databaseId = _singleInstancesByPath.get(path)) != null && (database = this.databaseMap.get(databaseId)) != null) {
                    if (!database.sqliteDatabase.isOpen()) {
                        if (LogLevel.hasVerboseLevel(logLevel)) {
                            Log.d((String)"Sqflite", (String)("[" + Thread.currentThread() + "] single instance database of " + path + " not opened"));
                        }
                    } else {
                        if (LogLevel.hasVerboseLevel(logLevel)) {
                            Log.d((String)"Sqflite", (String)("[" + Thread.currentThread() + "] re-opened single instance " + databaseId + " " + path));
                        }
                        result.success((Object)SqflitePlugin.makeOpenResult((Integer)databaseId, true));
                        return;
                    }
                }
            }
        }
        databaseId = this.databaseMapLocker;
        synchronized (databaseId) {
            newDatabaseId = ++this.databaseId;
        }
        final int databaseId2 = newDatabaseId;
        database = new Database(path, databaseId2, singleInstance, logLevel);
        final BgResult bgResult = new BgResult(result);
        Object object = this.databaseMapLocker;
        synchronized (object) {
            if (this.handler == null) {
                this.handlerThread = new HandlerThread("Sqflite", THREAD_PRIORITY);
                this.handlerThread.start();
                this.handler = new Handler(this.handlerThread.getLooper());
                if (LogLevel.hasSqlLevel(database.logLevel)) {
                    Log.d((String)"Sqflite", (String)("starting thread" + this.handlerThread + " priority " + THREAD_PRIORITY));
                }
            }
            if (LogLevel.hasSqlLevel(database.logLevel)) {
                Log.d((String)"Sqflite", (String)("[" + Thread.currentThread() + "] opened " + databaseId2 + " " + path));
            }
            this.handler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = SqflitePlugin.this.openCloseLocker;
                    synchronized (object) {
                        File file;
                        File directory;
                        if (!(inMemory || (directory = new File((file = new File(path)).getParent())).exists() || directory.mkdirs() || directory.exists())) {
                            bgResult.error("sqlite_error", "open_failed " + path, null);
                            return;
                        }
                        try {
                            if (Boolean.TRUE.equals(readOnly)) {
                                database.openReadOnly();
                            } else {
                                database.open();
                            }
                        }
                        catch (Exception e) {
                            MethodCallOperation operation = new MethodCallOperation(call, bgResult);
                            SqflitePlugin.this.handleException(e, operation, database);
                            return;
                        }
                        Object object2 = SqflitePlugin.this.databaseMapLocker;
                        synchronized (object2) {
                            if (singleInstance) {
                                _singleInstancesByPath.put(path, databaseId2);
                            }
                            SqflitePlugin.this.databaseMap.put(databaseId2, database);
                        }
                        if (LogLevel.hasSqlLevel(database.logLevel)) {
                            Log.d((String)"Sqflite", (String)("[" + Thread.currentThread() + "] opened " + databaseId2 + " " + path));
                        }
                    }
                    bgResult.success(SqflitePlugin.makeOpenResult(databaseId2, false));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCloseDatabaseCall(MethodCall call, MethodChannel.Result result) {
        final int databaseId = (Integer)call.argument("id");
        final Database database = this.getDatabaseOrError(call, result);
        if (database == null) {
            return;
        }
        if (LogLevel.hasSqlLevel(database.logLevel)) {
            Log.d((String)"Sqflite", (String)("[" + Thread.currentThread() + "] closing " + databaseId + " " + database.path));
        }
        String path = database.path;
        Object object = this.databaseMapLocker;
        synchronized (object) {
            this.databaseMap.remove(databaseId);
            if (database.singleInstance) {
                _singleInstancesByPath.remove(path);
            }
        }
        final BgResult bgResult = new BgResult(result);
        this.handler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = SqflitePlugin.this.openCloseLocker;
                synchronized (object) {
                    try {
                        database.close();
                    }
                    catch (Exception e) {
                        Log.e((String)"Sqflite", (String)("error " + e + " while closing database " + databaseId));
                    }
                    Object object2 = SqflitePlugin.this.databaseMapLocker;
                    synchronized (object2) {
                        if (SqflitePlugin.this.databaseMap.isEmpty() && SqflitePlugin.this.handler != null) {
                            if (LogLevel.hasSqlLevel(database.logLevel)) {
                                Log.d((String)"Sqflite", (String)("stopping thread" + SqflitePlugin.this.handlerThread));
                            }
                            SqflitePlugin.this.handlerThread.quit();
                            SqflitePlugin.this.handlerThread = null;
                            SqflitePlugin.this.handler = null;
                        }
                    }
                }
                bgResult.success(null);
            }
        });
    }

    public void onMethodCall(MethodCall call, MethodChannel.Result result) {
        switch (call.method) {
            case "getPlatformVersion": {
                result.success((Object)("Android " + Build.VERSION.RELEASE));
                break;
            }
            case "closeDatabase": {
                this.onCloseDatabaseCall(call, result);
                break;
            }
            case "query": {
                this.onQueryCall(call, result);
                break;
            }
            case "insert": {
                this.onInsertCall(call, result);
                break;
            }
            case "update": {
                this.onUpdateCall(call, result);
                break;
            }
            case "execute": {
                this.onExecuteCall(call, result);
                break;
            }
            case "openDatabase": {
                this.onOpenDatabaseCall(call, result);
                break;
            }
            case "batch": {
                this.onBatchCall(call, result);
                break;
            }
            case "options": {
                this.onOptionsCall(call, result);
                break;
            }
            case "getDatabasesPath": {
                this.onGetDatabasesPath(call, result);
                break;
            }
            case "debug": {
                this.onDebugCall(call, result);
                break;
            }
            case "debugMode": {
                this.onDebugModeCall(call, result);
                break;
            }
            default: {
                result.notImplemented();
            }
        }
    }

    void onOptionsCall(MethodCall call, MethodChannel.Result result) {
        Integer logLevel;
        Object threadPriority;
        Object paramAsList = call.argument("queryAsMapList");
        if (paramAsList != null) {
            QUERY_AS_MAP_LIST = Boolean.TRUE.equals(paramAsList);
        }
        if ((threadPriority = call.argument("androidThreadPriority")) != null) {
            THREAD_PRIORITY = (Integer)threadPriority;
        }
        if ((logLevel = LogLevel.getLogLevel(call)) != null) {
            SqflitePlugin.logLevel = logLevel;
        }
        result.success(null);
    }

    void onGetDatabasesPath(MethodCall call, MethodChannel.Result result) {
        if (this.databasesPath == null) {
            String dummyDatabaseName = "tekartik_sqflite.db";
            File file = this.context.getDatabasePath(dummyDatabaseName);
            this.databasesPath = file.getParent();
        }
        result.success((Object)this.databasesPath);
    }

    private class BgResult
    implements MethodChannel.Result {
        final Handler handler = new Handler();
        private final MethodChannel.Result result;

        private BgResult(MethodChannel.Result result) {
            this.result = result;
        }

        public void success(final Object results) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    BgResult.this.result.success(results);
                }
            });
        }

        public void error(final String errorCode, final String errorMessage, final Object data) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    BgResult.this.result.error(errorCode, errorMessage, data);
                }
            });
        }

        public void notImplemented() {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    BgResult.this.result.notImplemented();
                }
            });
        }
    }
}

