/*
 * Decompiled with CFR 0.152.
 */
package com.tekartik.sqflite;

import android.util.Log;
import com.tekartik.sqflite.dev.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SqlCommand {
    private final String sql;
    private final List<Object> rawArguments;

    public String getSql() {
        return this.sql;
    }

    private static Object toValue(Object value) {
        if (value == null) {
            return null;
        }
        if (Debug.EXTRA_LOGV) {
            Log.d((String)"Sqflite", (String)("arg " + value.getClass().getCanonicalName() + " " + SqlCommand.toString(value)));
        }
        if (value instanceof List) {
            List list = (List)value;
            byte[] blob = new byte[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                blob[i] = (byte)((Integer)list.get(i)).intValue();
            }
            value = blob;
        }
        if (Debug.EXTRA_LOGV) {
            Log.d((String)"Sqflite", (String)("arg " + value.getClass().getCanonicalName() + " " + SqlCommand.toString(value)));
        }
        return value;
    }

    public SqlCommand(String sql, List<Object> rawArguments) {
        this.sql = sql;
        if (rawArguments == null) {
            rawArguments = new ArrayList<Object>();
        }
        this.rawArguments = rawArguments;
    }

    public SqlCommand sanitizeForQuery() {
        if (this.rawArguments.size() == 0) {
            return this;
        }
        StringBuilder sanitizeSqlSb = new StringBuilder();
        ArrayList<Object> sanitizeArguments = new ArrayList<Object>();
        int count = 0;
        int argumentIndex = 0;
        int sqlLength = this.sql.length();
        for (int i = 0; i < sqlLength; ++i) {
            char ch = this.sql.charAt(i);
            if (ch == '?') {
                Object argument;
                ++count;
                if (argumentIndex >= this.rawArguments.size()) {
                    return this;
                }
                if ((argument = this.rawArguments.get(argumentIndex++)) instanceof Integer || argument instanceof Long) {
                    sanitizeSqlSb.append(argument.toString());
                    continue;
                }
                sanitizeArguments.add(argument);
            }
            sanitizeSqlSb.append(ch);
        }
        if (count != this.rawArguments.size()) {
            return this;
        }
        return new SqlCommand(sanitizeSqlSb.toString(), sanitizeArguments);
    }

    private String[] getQuerySqlArguments(List<Object> rawArguments) {
        return this.getStringQuerySqlArguments(rawArguments).toArray(new String[0]);
    }

    private Object[] getSqlArguments(List<Object> rawArguments) {
        ArrayList<Object> fixedArguments = new ArrayList<Object>();
        if (rawArguments != null) {
            for (Object rawArgument : rawArguments) {
                fixedArguments.add(SqlCommand.toValue(rawArgument));
            }
        }
        return fixedArguments.toArray(new Object[0]);
    }

    private List<String> getStringQuerySqlArguments(List<Object> rawArguments) {
        ArrayList<String> stringArguments = new ArrayList<String>();
        if (rawArguments != null) {
            for (Object rawArgument : rawArguments) {
                stringArguments.add(SqlCommand.toString(rawArgument));
            }
        }
        return stringArguments;
    }

    private static String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (byte _byte : (byte[])value) {
                list.add(Integer.valueOf(_byte));
            }
            return ((Object)list).toString();
        }
        if (value instanceof Map) {
            Map mapValue = (Map)value;
            return SqlCommand.fixMap(mapValue).toString();
        }
        return value.toString();
    }

    private static Map<String, Object> fixMap(Map<Object, Object> map) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Map<String, Object> value = entry.getValue();
            if (value instanceof Map) {
                Map mapValue = value;
                value = SqlCommand.fixMap(mapValue);
            } else {
                value = SqlCommand.toString(value);
            }
            newMap.put(SqlCommand.toString(entry.getKey()), value);
        }
        return newMap;
    }

    public String toString() {
        return this.sql + (this.rawArguments == null || this.rawArguments.isEmpty() ? "" : " " + this.getStringQuerySqlArguments(this.rawArguments));
    }

    public Object[] getSqlArguments() {
        return this.getSqlArguments(this.rawArguments);
    }

    public String[] getQuerySqlArguments() {
        return this.getQuerySqlArguments(this.rawArguments);
    }

    public List<Object> getRawSqlArguments() {
        return this.rawArguments;
    }

    public int hashCode() {
        return this.sql != null ? this.sql.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SqlCommand) {
            SqlCommand o = (SqlCommand)obj;
            if (this.sql != null ? !this.sql.equals(o.sql) : o.sql != null) {
                return false;
            }
            if (this.rawArguments.size() != o.rawArguments.size()) {
                return false;
            }
            for (int i = 0; i < this.rawArguments.size(); ++i) {
                if (!(this.rawArguments.get(i) instanceof byte[] && o.rawArguments.get(i) instanceof byte[] ? !Arrays.equals((byte[])this.rawArguments.get(i), (byte[])o.rawArguments.get(i)) : !this.rawArguments.get(i).equals(o.rawArguments.get(i)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

