/*
 * Decompiled with CFR 0.152.
 */
package com.dexterous.flutterlocalnotifications;

import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.AudioAttributes;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.text.Html;
import android.text.Spanned;
import com.dexterous.flutterlocalnotifications.BitmapSource;
import com.dexterous.flutterlocalnotifications.NotificationStyle;
import com.dexterous.flutterlocalnotifications.RuntimeTypeAdapterFactory;
import com.dexterous.flutterlocalnotifications.ScheduledNotificationReceiver;
import com.dexterous.flutterlocalnotifications.models.NotificationDetails;
import com.dexterous.flutterlocalnotifications.models.styles.BigPictureStyleInformation;
import com.dexterous.flutterlocalnotifications.models.styles.BigTextStyleInformation;
import com.dexterous.flutterlocalnotifications.models.styles.DefaultStyleInformation;
import com.dexterous.flutterlocalnotifications.models.styles.InboxStyleInformation;
import com.dexterous.flutterlocalnotifications.models.styles.StyleInformation;
import com.dexterous.flutterlocalnotifications.utils.BooleanUtils;
import com.dexterous.flutterlocalnotifications.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FlutterLocalNotificationsPlugin
implements MethodChannel.MethodCallHandler,
PluginRegistry.NewIntentListener {
    private static final String DRAWABLE = "drawable";
    private static final String DEFAULT_ICON = "defaultIcon";
    private static final String SELECT_NOTIFICATION = "SELECT_NOTIFICATION";
    private static final String SCHEDULED_NOTIFICATIONS = "scheduled_notifications";
    private static final String INITIALIZE_METHOD = "initialize";
    private static final String INITIALIZE_HEADLESS_SERVICE_METHOD = "initializeHeadlessService";
    private static final String SHOW_METHOD = "show";
    private static final String CANCEL_METHOD = "cancel";
    private static final String CANCEL_ALL_METHOD = "cancelAll";
    private static final String SCHEDULE_METHOD = "schedule";
    private static final String PERIODICALLY_SHOW_METHOD = "periodicallyShow";
    private static final String SHOW_DAILY_AT_TIME_METHOD = "showDailyAtTime";
    private static final String SHOW_WEEKLY_AT_DAY_AND_TIME_METHOD = "showWeeklyAtDayAndTime";
    private static final String GET_NOTIFICATION_APP_LAUNCH_DETAILS_METHOD = "getNotificationAppLaunchDetails";
    private static final String METHOD_CHANNEL = "dexterous.com/flutter/local_notifications";
    private static final String PAYLOAD = "payload";
    private static final String INVALID_ICON_ERROR_CODE = "INVALID_ICON";
    private static final String INVALID_LARGE_ICON_ERROR_CODE = "INVALID_LARGE_ICON";
    private static final String INVALID_BIG_PICTURE_ERROR_CODE = "INVALID_BIG_PICTURE";
    private static final String INVALID_SOUND_ERROR_CODE = "INVALID_SOUND";
    private static final String NOTIFICATION_LAUNCHED_APP = "notificationLaunchedApp";
    private static final String INVALID_DRAWABLE_RESOURCE_ERROR_MESSAGE = "The resource %s could not be found. Please make sure it has been added as a drawable resource to your Android head project.";
    private static final String INVALID_RAW_RESOURCE_ERROR_MESSAGE = "The resource %s could not be found. Please make sure it has been added as a raw resource to your Android head project.";
    public static final String SHARED_PREFERENCES_KEY = "notification_plugin_cache";
    public static String NOTIFICATION_ID = "notification_id";
    public static String NOTIFICATION = "notification";
    public static String NOTIFICATION_DETAILS = "notificationDetails";
    public static String REPEAT = "repeat";
    private static MethodChannel channel;
    private static int defaultIconResourceId;
    private final PluginRegistry.Registrar registrar;

    private FlutterLocalNotificationsPlugin(PluginRegistry.Registrar registrar) {
        this.registrar = registrar;
        this.registrar.addNewIntentListener((PluginRegistry.NewIntentListener)this);
    }

    public static void rescheduleNotifications(Context context) {
        ArrayList<NotificationDetails> scheduledNotifications = FlutterLocalNotificationsPlugin.loadScheduledNotifications(context);
        for (NotificationDetails scheduledNotification : scheduledNotifications) {
            if (scheduledNotification.repeatInterval == null) {
                FlutterLocalNotificationsPlugin.scheduleNotification(context, scheduledNotification, false);
                continue;
            }
            FlutterLocalNotificationsPlugin.repeatNotification(context, scheduledNotification, false);
        }
    }

    public static Notification createNotification(Context context, NotificationDetails notificationDetails) {
        FlutterLocalNotificationsPlugin.setupNotificationChannel(context, notificationDetails);
        Intent intent = new Intent(context, FlutterLocalNotificationsPlugin.getMainActivityClass(context));
        intent.setAction(SELECT_NOTIFICATION);
        intent.putExtra(PAYLOAD, notificationDetails.payload);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)notificationDetails.id, (Intent)intent, (int)0x8000000);
        DefaultStyleInformation defaultStyleInformation = (DefaultStyleInformation)notificationDetails.styleInformation;
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, notificationDetails.channelId).setSmallIcon(notificationDetails.iconResourceId.intValue()).setContentTitle((CharSequence)(defaultStyleInformation.htmlFormatTitle != false ? FlutterLocalNotificationsPlugin.fromHtml(notificationDetails.title) : notificationDetails.title)).setContentText((CharSequence)(defaultStyleInformation.htmlFormatBody != false ? FlutterLocalNotificationsPlugin.fromHtml(notificationDetails.body) : notificationDetails.body)).setAutoCancel(BooleanUtils.getValue(notificationDetails.autoCancel)).setContentIntent(pendingIntent).setPriority(notificationDetails.priority.intValue()).setOngoing(BooleanUtils.getValue(notificationDetails.ongoing)).setOnlyAlertOnce(BooleanUtils.getValue(notificationDetails.onlyAlertOnce));
        if (!StringUtils.isNullOrEmpty(notificationDetails.largeIcon).booleanValue()) {
            builder.setLargeIcon(FlutterLocalNotificationsPlugin.getBitmapFromSource(context, notificationDetails.largeIcon, notificationDetails.largeIconBitmapSource));
        }
        if (notificationDetails.color != null) {
            builder.setColor(notificationDetails.color.intValue());
        }
        FlutterLocalNotificationsPlugin.applyGrouping(notificationDetails, builder);
        FlutterLocalNotificationsPlugin.setSound(context, notificationDetails, builder);
        FlutterLocalNotificationsPlugin.setVibrationPattern(notificationDetails, builder);
        FlutterLocalNotificationsPlugin.setStyle(context, notificationDetails, builder);
        FlutterLocalNotificationsPlugin.setProgress(notificationDetails, builder);
        return builder.build();
    }

    @NonNull
    public static Gson buildGson() {
        RuntimeTypeAdapterFactory<InboxStyleInformation> styleInformationAdapter = RuntimeTypeAdapterFactory.of(StyleInformation.class).registerSubtype(DefaultStyleInformation.class).registerSubtype(BigTextStyleInformation.class).registerSubtype(BigPictureStyleInformation.class).registerSubtype(InboxStyleInformation.class);
        GsonBuilder builder = new GsonBuilder().registerTypeAdapterFactory(styleInformationAdapter);
        return builder.create();
    }

    private static ArrayList<NotificationDetails> loadScheduledNotifications(Context context) {
        ArrayList scheduledNotifications = new ArrayList();
        SharedPreferences sharedPreferences = context.getSharedPreferences(SCHEDULED_NOTIFICATIONS, 0);
        String json = sharedPreferences.getString(SCHEDULED_NOTIFICATIONS, null);
        if (json != null) {
            Gson gson = FlutterLocalNotificationsPlugin.buildGson();
            Type type = new TypeToken<ArrayList<NotificationDetails>>(){}.getType();
            scheduledNotifications = (ArrayList)gson.fromJson(json, type);
        }
        return scheduledNotifications;
    }

    private static void saveScheduledNotifications(Context context, ArrayList<NotificationDetails> scheduledNotifications) {
        Gson gson = FlutterLocalNotificationsPlugin.buildGson();
        String json = gson.toJson(scheduledNotifications);
        SharedPreferences sharedPreferences = context.getSharedPreferences(SCHEDULED_NOTIFICATIONS, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(SCHEDULED_NOTIFICATIONS, json);
        editor.commit();
    }

    public static void registerWith(PluginRegistry.Registrar registrar) {
        channel = new MethodChannel(registrar.messenger(), METHOD_CHANNEL);
        FlutterLocalNotificationsPlugin plugin = new FlutterLocalNotificationsPlugin(registrar);
        channel.setMethodCallHandler((MethodChannel.MethodCallHandler)plugin);
    }

    public static void removeNotificationFromCache(Integer notificationId, Context context) {
        ArrayList<NotificationDetails> scheduledNotifications = FlutterLocalNotificationsPlugin.loadScheduledNotifications(context);
        Iterator<NotificationDetails> it = scheduledNotifications.iterator();
        while (it.hasNext()) {
            NotificationDetails notificationDetails = it.next();
            if (!notificationDetails.id.equals(notificationId)) continue;
            it.remove();
            break;
        }
        FlutterLocalNotificationsPlugin.saveScheduledNotifications(context, scheduledNotifications);
    }

    private static Spanned fromHtml(String html) {
        if (Build.VERSION.SDK_INT >= 24) {
            return Html.fromHtml((String)html, (int)0);
        }
        return Html.fromHtml((String)html);
    }

    private static void scheduleNotification(Context context, NotificationDetails notificationDetails, Boolean updateScheduledNotificationsCache) {
        Gson gson = FlutterLocalNotificationsPlugin.buildGson();
        String notificationDetailsJson = gson.toJson((Object)notificationDetails);
        Intent notificationIntent = new Intent(context, ScheduledNotificationReceiver.class);
        notificationIntent.putExtra(NOTIFICATION_DETAILS, notificationDetailsJson);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)notificationDetails.id, (Intent)notificationIntent, (int)0x10000000);
        AlarmManager alarmManager = FlutterLocalNotificationsPlugin.getAlarmManager(context);
        if (Build.VERSION.SDK_INT >= 19) {
            alarmManager.setExact(0, notificationDetails.millisecondsSinceEpoch.longValue(), pendingIntent);
        } else {
            alarmManager.set(0, notificationDetails.millisecondsSinceEpoch.longValue(), pendingIntent);
        }
        if (updateScheduledNotificationsCache.booleanValue()) {
            ArrayList<NotificationDetails> scheduledNotifications = FlutterLocalNotificationsPlugin.loadScheduledNotifications(context);
            scheduledNotifications.add(notificationDetails);
            FlutterLocalNotificationsPlugin.saveScheduledNotifications(context, scheduledNotifications);
        }
    }

    private static void repeatNotification(Context context, NotificationDetails notificationDetails, Boolean updateScheduledNotificationsCache) {
        Gson gson = FlutterLocalNotificationsPlugin.buildGson();
        String notificationDetailsJson = gson.toJson((Object)notificationDetails);
        Intent notificationIntent = new Intent(context, ScheduledNotificationReceiver.class);
        notificationIntent.putExtra(NOTIFICATION_DETAILS, notificationDetailsJson);
        notificationIntent.putExtra(REPEAT, true);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)notificationDetails.id, (Intent)notificationIntent, (int)0x10000000);
        AlarmManager alarmManager = FlutterLocalNotificationsPlugin.getAlarmManager(context);
        long repeatInterval = 0L;
        switch (notificationDetails.repeatInterval) {
            case EveryMinute: {
                repeatInterval = 60000L;
                break;
            }
            case Hourly: {
                repeatInterval = 3600000L;
                break;
            }
            case Daily: {
                repeatInterval = 86400000L;
                break;
            }
            case Weekly: {
                repeatInterval = 604800000L;
                break;
            }
        }
        long startTimeMilliseconds = notificationDetails.calledAt;
        if (notificationDetails.repeatTime != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(System.currentTimeMillis());
            calendar.set(11, notificationDetails.repeatTime.hour);
            calendar.set(12, notificationDetails.repeatTime.minute);
            calendar.set(13, notificationDetails.repeatTime.second);
            if (notificationDetails.day != null) {
                calendar.set(7, notificationDetails.day);
            }
            startTimeMilliseconds = calendar.getTimeInMillis();
        }
        long currentTime = System.currentTimeMillis();
        while (startTimeMilliseconds < currentTime) {
            startTimeMilliseconds += repeatInterval;
        }
        alarmManager.setInexactRepeating(0, startTimeMilliseconds, repeatInterval, pendingIntent);
        if (updateScheduledNotificationsCache.booleanValue()) {
            ArrayList<NotificationDetails> scheduledNotifications = FlutterLocalNotificationsPlugin.loadScheduledNotifications(context);
            scheduledNotifications.add(notificationDetails);
            FlutterLocalNotificationsPlugin.saveScheduledNotifications(context, scheduledNotifications);
        }
    }

    private static boolean setIconResourceId(Context context, NotificationDetails notificationDetails, MethodChannel.Result result) {
        if (notificationDetails.iconResourceId == null) {
            int resourceId;
            if (notificationDetails.icon != null) {
                resourceId = context.getResources().getIdentifier(notificationDetails.icon, DRAWABLE, context.getPackageName());
                if (resourceId == 0) {
                    result.error(INVALID_ICON_ERROR_CODE, String.format(INVALID_DRAWABLE_RESOURCE_ERROR_MESSAGE, notificationDetails.icon), null);
                }
            } else {
                resourceId = defaultIconResourceId;
            }
            notificationDetails.iconResourceId = resourceId;
        }
        return notificationDetails.iconResourceId != 0;
    }

    private static Bitmap getBitmapFromSource(Context context, String bitmapPath, BitmapSource bitmapSource) {
        Bitmap bitmap = null;
        if (bitmapSource == BitmapSource.Drawable) {
            int resourceId = context.getResources().getIdentifier(bitmapPath, DRAWABLE, context.getPackageName());
            bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resourceId);
        } else if (bitmapSource == BitmapSource.FilePath) {
            bitmap = BitmapFactory.decodeFile((String)bitmapPath);
        }
        return bitmap;
    }

    private static void applyGrouping(NotificationDetails notificationDetails, NotificationCompat.Builder builder) {
        Boolean isGrouped = false;
        if (!StringUtils.isNullOrEmpty(notificationDetails.groupKey).booleanValue()) {
            builder.setGroup(notificationDetails.groupKey);
            isGrouped = true;
        }
        if (isGrouped.booleanValue()) {
            if (BooleanUtils.getValue(notificationDetails.setAsGroupSummary)) {
                builder.setGroupSummary(true);
            }
            builder.setGroupAlertBehavior(notificationDetails.groupAlertBehavior.intValue());
        }
    }

    private static void setVibrationPattern(NotificationDetails notificationDetails, NotificationCompat.Builder builder) {
        if (BooleanUtils.getValue(notificationDetails.enableVibration)) {
            if (notificationDetails.vibrationPattern != null && notificationDetails.vibrationPattern.length > 0) {
                builder.setVibrate(notificationDetails.vibrationPattern);
            }
        } else {
            builder.setVibrate(new long[]{0L});
        }
    }

    private static void setSound(Context context, NotificationDetails notificationDetails, NotificationCompat.Builder builder) {
        if (BooleanUtils.getValue(notificationDetails.playSound)) {
            Uri uri = FlutterLocalNotificationsPlugin.retrieveSoundResourceUri(context, notificationDetails);
            builder.setSound(uri);
        } else {
            builder.setSound(null);
        }
    }

    private static Class getMainActivityClass(Context context) {
        String packageName = context.getPackageName();
        Intent launchIntent = context.getPackageManager().getLaunchIntentForPackage(packageName);
        String className = launchIntent.getComponent().getClassName();
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void setStyle(Context context, NotificationDetails notificationDetails, NotificationCompat.Builder builder) {
        switch (notificationDetails.style) {
            case Default: {
                break;
            }
            case BigPicture: {
                FlutterLocalNotificationsPlugin.setBigPictureStyle(context, notificationDetails, builder);
                break;
            }
            case BigText: {
                FlutterLocalNotificationsPlugin.setBigTextStyle(notificationDetails, builder);
                break;
            }
            case Inbox: {
                FlutterLocalNotificationsPlugin.setInboxStyle(notificationDetails, builder);
                break;
            }
        }
    }

    private static void setProgress(NotificationDetails notificationDetails, NotificationCompat.Builder builder) {
        if (BooleanUtils.getValue(notificationDetails.showProgress)) {
            builder.setProgress(notificationDetails.maxProgress.intValue(), notificationDetails.progress.intValue(), notificationDetails.indeterminate.booleanValue());
        }
    }

    private static void setBigPictureStyle(Context context, NotificationDetails notificationDetails, NotificationCompat.Builder builder) {
        BigPictureStyleInformation bigPictureStyleInformation = (BigPictureStyleInformation)notificationDetails.styleInformation;
        NotificationCompat.BigPictureStyle bigPictureStyle = new NotificationCompat.BigPictureStyle();
        if (bigPictureStyleInformation.contentTitle != null) {
            String contentTitle = bigPictureStyleInformation.htmlFormatContentTitle != false ? FlutterLocalNotificationsPlugin.fromHtml(bigPictureStyleInformation.contentTitle) : bigPictureStyleInformation.contentTitle;
            bigPictureStyle.setBigContentTitle((CharSequence)contentTitle);
        }
        if (bigPictureStyleInformation.summaryText != null) {
            String summaryText = bigPictureStyleInformation.htmlFormatSummaryText != false ? FlutterLocalNotificationsPlugin.fromHtml(bigPictureStyleInformation.summaryText) : bigPictureStyleInformation.summaryText;
            bigPictureStyle.setSummaryText((CharSequence)summaryText);
        }
        if (bigPictureStyleInformation.hideExpandedLargeIcon.booleanValue()) {
            bigPictureStyle.bigLargeIcon(null);
        } else if (bigPictureStyleInformation.largeIcon != null) {
            bigPictureStyle.bigLargeIcon(FlutterLocalNotificationsPlugin.getBitmapFromSource(context, bigPictureStyleInformation.largeIcon, bigPictureStyleInformation.largeIconBitmapSource));
        }
        bigPictureStyle.bigPicture(FlutterLocalNotificationsPlugin.getBitmapFromSource(context, bigPictureStyleInformation.bigPicture, bigPictureStyleInformation.bigPictureBitmapSource));
        builder.setStyle((NotificationCompat.Style)bigPictureStyle);
    }

    private static void setInboxStyle(NotificationDetails notificationDetails, NotificationCompat.Builder builder) {
        InboxStyleInformation inboxStyleInformation = (InboxStyleInformation)notificationDetails.styleInformation;
        NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
        if (inboxStyleInformation.contentTitle != null) {
            String contentTitle = inboxStyleInformation.htmlFormatContentTitle != false ? FlutterLocalNotificationsPlugin.fromHtml(inboxStyleInformation.contentTitle) : inboxStyleInformation.contentTitle;
            inboxStyle.setBigContentTitle((CharSequence)contentTitle);
        }
        if (inboxStyleInformation.summaryText != null) {
            String summaryText = inboxStyleInformation.htmlFormatSummaryText != false ? FlutterLocalNotificationsPlugin.fromHtml(inboxStyleInformation.summaryText) : inboxStyleInformation.summaryText;
            inboxStyle.setSummaryText((CharSequence)summaryText);
        }
        if (inboxStyleInformation.lines != null) {
            for (String line : inboxStyleInformation.lines) {
                inboxStyle.addLine((CharSequence)(inboxStyleInformation.htmlFormatLines != false ? FlutterLocalNotificationsPlugin.fromHtml(line) : line));
            }
        }
        builder.setStyle((NotificationCompat.Style)inboxStyle);
    }

    private static void setBigTextStyle(NotificationDetails notificationDetails, NotificationCompat.Builder builder) {
        BigTextStyleInformation bigTextStyleInformation = (BigTextStyleInformation)notificationDetails.styleInformation;
        NotificationCompat.BigTextStyle bigTextStyle = new NotificationCompat.BigTextStyle();
        if (bigTextStyleInformation.bigText != null) {
            String bigText = bigTextStyleInformation.htmlFormatBigText != false ? FlutterLocalNotificationsPlugin.fromHtml(bigTextStyleInformation.bigText) : bigTextStyleInformation.bigText;
            bigTextStyle.bigText((CharSequence)bigText);
        }
        if (bigTextStyleInformation.contentTitle != null) {
            String contentTitle = bigTextStyleInformation.htmlFormatContentTitle != false ? FlutterLocalNotificationsPlugin.fromHtml(bigTextStyleInformation.contentTitle) : bigTextStyleInformation.contentTitle;
            bigTextStyle.setBigContentTitle((CharSequence)contentTitle);
        }
        if (bigTextStyleInformation.summaryText != null) {
            String summaryText = bigTextStyleInformation.htmlFormatSummaryText != false ? FlutterLocalNotificationsPlugin.fromHtml(bigTextStyleInformation.summaryText) : bigTextStyleInformation.summaryText;
            bigTextStyle.setSummaryText((CharSequence)summaryText);
        }
        builder.setStyle((NotificationCompat.Style)bigTextStyle);
    }

    private static void setupNotificationChannel(Context context, NotificationDetails notificationDetails) {
        NotificationManager notificationManager;
        NotificationChannel notificationChannel;
        if (Build.VERSION.SDK_INT >= 26 && (notificationChannel = (notificationManager = (NotificationManager)context.getSystemService("notification")).getNotificationChannel(notificationDetails.channelId)) == null) {
            notificationChannel = new NotificationChannel(notificationDetails.channelId, (CharSequence)notificationDetails.channelName, notificationDetails.importance.intValue());
            notificationChannel.setDescription(notificationDetails.channelDescription);
            if (notificationDetails.playSound.booleanValue()) {
                AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(5).build();
                Uri uri = FlutterLocalNotificationsPlugin.retrieveSoundResourceUri(context, notificationDetails);
                notificationChannel.setSound(uri, audioAttributes);
            } else {
                notificationChannel.setSound(null, null);
            }
            notificationChannel.enableVibration(BooleanUtils.getValue(notificationDetails.enableVibration));
            if (notificationDetails.vibrationPattern != null && notificationDetails.vibrationPattern.length > 0) {
                notificationChannel.setVibrationPattern(notificationDetails.vibrationPattern);
            }
            notificationChannel.setShowBadge(BooleanUtils.getValue(notificationDetails.channelShowBadge));
            notificationManager.createNotificationChannel(notificationChannel);
        }
    }

    private static Uri retrieveSoundResourceUri(Context context, NotificationDetails notificationDetails) {
        if (!StringUtils.isNullOrEmpty(notificationDetails.sound).booleanValue()) {
            int soundResourceId = context.getResources().getIdentifier(notificationDetails.sound, "raw", context.getPackageName());
            return Uri.parse((String)("android.resource://" + context.getPackageName() + "/" + soundResourceId));
        }
        Uri uri = RingtoneManager.getDefaultUri((int)2);
        return uri;
    }

    private static AlarmManager getAlarmManager(Context context) {
        return (AlarmManager)context.getSystemService("alarm");
    }

    private static boolean isValidDrawableResource(Context context, String name, MethodChannel.Result result, String errorCode) {
        int resourceId = context.getResources().getIdentifier(name, DRAWABLE, context.getPackageName());
        if (resourceId == 0) {
            result.error(errorCode, String.format(INVALID_DRAWABLE_RESOURCE_ERROR_MESSAGE, name), null);
            return false;
        }
        return true;
    }

    public void onMethodCall(MethodCall call, MethodChannel.Result result) {
        switch (call.method) {
            case "initialize": {
                this.initialize(call, result);
                break;
            }
            case "getNotificationAppLaunchDetails": {
                this.getNotificationAppLaunchDetails(result);
                break;
            }
            case "show": {
                this.show(call, result);
                break;
            }
            case "schedule": {
                this.schedule(call, result);
                break;
            }
            case "periodicallyShow": 
            case "showDailyAtTime": 
            case "showWeeklyAtDayAndTime": {
                this.repeat(call, result);
                break;
            }
            case "cancel": {
                this.cancel(call, result);
                break;
            }
            case "cancelAll": {
                this.cancelAllNotifications(result);
                break;
            }
            default: {
                result.notImplemented();
            }
        }
    }

    private void cancel(MethodCall call, MethodChannel.Result result) {
        Integer id = (Integer)call.arguments();
        this.cancelNotification(id);
        result.success(null);
    }

    private void repeat(MethodCall call, MethodChannel.Result result) {
        Map arguments = (Map)call.arguments();
        NotificationDetails notificationDetails = this.extractNotificationDetails(result, arguments);
        if (notificationDetails != null) {
            FlutterLocalNotificationsPlugin.repeatNotification(this.registrar.context(), notificationDetails, true);
            result.success(null);
        }
    }

    private void schedule(MethodCall call, MethodChannel.Result result) {
        Map arguments = (Map)call.arguments();
        NotificationDetails notificationDetails = this.extractNotificationDetails(result, arguments);
        if (notificationDetails != null) {
            FlutterLocalNotificationsPlugin.scheduleNotification(this.registrar.context(), notificationDetails, true);
            result.success(null);
        }
    }

    private void show(MethodCall call, MethodChannel.Result result) {
        Map arguments = (Map)call.arguments();
        NotificationDetails notificationDetails = this.extractNotificationDetails(result, arguments);
        if (notificationDetails != null) {
            FlutterLocalNotificationsPlugin.showNotification(this.registrar.context(), notificationDetails);
            result.success(null);
        }
    }

    private void getNotificationAppLaunchDetails(MethodChannel.Result result) {
        HashMap<String, Object> notificationAppLaunchDetails = new HashMap<String, Object>();
        String payload = null;
        Boolean notificationLaunchedApp = this.registrar.activity() != null && SELECT_NOTIFICATION.equals(this.registrar.activity().getIntent().getAction());
        notificationAppLaunchDetails.put(NOTIFICATION_LAUNCHED_APP, notificationLaunchedApp);
        if (notificationLaunchedApp.booleanValue()) {
            payload = this.registrar.activity().getIntent().getStringExtra(PAYLOAD);
        }
        notificationAppLaunchDetails.put(PAYLOAD, payload);
        result.success(notificationAppLaunchDetails);
    }

    private void initialize(MethodCall call, MethodChannel.Result result) {
        Map arguments = (Map)call.arguments();
        String defaultIcon = (String)arguments.get(DEFAULT_ICON);
        defaultIconResourceId = this.registrar.context().getResources().getIdentifier(defaultIcon, DRAWABLE, this.registrar.context().getPackageName());
        if (defaultIconResourceId == 0) {
            result.error(INVALID_ICON_ERROR_CODE, String.format(INVALID_DRAWABLE_RESOURCE_ERROR_MESSAGE, defaultIcon), null);
            return;
        }
        if (this.registrar.activity() != null) {
            this.sendNotificationPayloadMessage(this.registrar.activity().getIntent());
        }
        result.success((Object)true);
    }

    private NotificationDetails extractNotificationDetails(MethodChannel.Result result, Map<String, Object> arguments) {
        int soundResourceId;
        NotificationDetails notificationDetails = NotificationDetails.from(arguments);
        if (!FlutterLocalNotificationsPlugin.setIconResourceId(this.registrar.context(), notificationDetails, result)) {
            return null;
        }
        if (!StringUtils.isNullOrEmpty(notificationDetails.largeIcon).booleanValue() && notificationDetails.largeIconBitmapSource == BitmapSource.Drawable && !FlutterLocalNotificationsPlugin.isValidDrawableResource(this.registrar.context(), notificationDetails.largeIcon, result, INVALID_LARGE_ICON_ERROR_CODE)) {
            return null;
        }
        if (notificationDetails.style == NotificationStyle.BigPicture) {
            BigPictureStyleInformation bigPictureStyleInformation = (BigPictureStyleInformation)notificationDetails.styleInformation;
            if (!StringUtils.isNullOrEmpty(bigPictureStyleInformation.largeIcon).booleanValue() && bigPictureStyleInformation.largeIconBitmapSource == BitmapSource.Drawable && !FlutterLocalNotificationsPlugin.isValidDrawableResource(this.registrar.context(), bigPictureStyleInformation.largeIcon, result, INVALID_LARGE_ICON_ERROR_CODE)) {
                return null;
            }
            if (bigPictureStyleInformation.bigPictureBitmapSource == BitmapSource.Drawable && !FlutterLocalNotificationsPlugin.isValidDrawableResource(this.registrar.context(), bigPictureStyleInformation.bigPicture, result, INVALID_BIG_PICTURE_ERROR_CODE)) {
                return null;
            }
        }
        if (!StringUtils.isNullOrEmpty(notificationDetails.sound).booleanValue() && (soundResourceId = this.registrar.context().getResources().getIdentifier(notificationDetails.sound, "raw", this.registrar.context().getPackageName())) == 0) {
            result.error(INVALID_SOUND_ERROR_CODE, INVALID_RAW_RESOURCE_ERROR_MESSAGE, null);
        }
        return notificationDetails;
    }

    private void cancelNotification(Integer id) {
        Context context = this.registrar.context();
        Intent intent = new Intent(context, ScheduledNotificationReceiver.class);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)id, (Intent)intent, (int)0x10000000);
        AlarmManager alarmManager = FlutterLocalNotificationsPlugin.getAlarmManager(context);
        alarmManager.cancel(pendingIntent);
        NotificationManagerCompat notificationManager = FlutterLocalNotificationsPlugin.getNotificationManager(context);
        notificationManager.cancel(id.intValue());
        FlutterLocalNotificationsPlugin.removeNotificationFromCache(id, context);
    }

    private void cancelAllNotifications(MethodChannel.Result result) {
        Context context = this.registrar.context();
        NotificationManagerCompat notificationManager = FlutterLocalNotificationsPlugin.getNotificationManager(context);
        notificationManager.cancelAll();
        ArrayList<NotificationDetails> scheduledNotifications = FlutterLocalNotificationsPlugin.loadScheduledNotifications(context);
        if (scheduledNotifications == null || scheduledNotifications.isEmpty()) {
            result.success(null);
            return;
        }
        Intent intent = new Intent(context, ScheduledNotificationReceiver.class);
        for (NotificationDetails scheduledNotification : scheduledNotifications) {
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)scheduledNotification.id, (Intent)intent, (int)0x10000000);
            AlarmManager alarmManager = FlutterLocalNotificationsPlugin.getAlarmManager(context);
            alarmManager.cancel(pendingIntent);
        }
        FlutterLocalNotificationsPlugin.saveScheduledNotifications(context, new ArrayList<NotificationDetails>());
        result.success(null);
    }

    public static void showNotification(Context context, NotificationDetails notificationDetails) {
        Notification notification = FlutterLocalNotificationsPlugin.createNotification(context, notificationDetails);
        NotificationManagerCompat notificationManagerCompat = FlutterLocalNotificationsPlugin.getNotificationManager(context);
        notificationManagerCompat.notify(notificationDetails.id.intValue(), notification);
    }

    private static NotificationManagerCompat getNotificationManager(Context context) {
        return NotificationManagerCompat.from((Context)context);
    }

    public boolean onNewIntent(Intent intent) {
        return this.sendNotificationPayloadMessage(intent);
    }

    private Boolean sendNotificationPayloadMessage(Intent intent) {
        if (SELECT_NOTIFICATION.equals(intent.getAction())) {
            String payload = intent.getStringExtra(PAYLOAD);
            channel.invokeMethod("selectNotification", (Object)payload);
            return true;
        }
        return false;
    }
}

