/*
 * Decompiled with CFR 0.152.
 */
package com.dexterous.flutterlocalnotifications;

import android.app.Notification;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.NotificationManagerCompat;
import com.dexterous.flutterlocalnotifications.FlutterLocalNotificationsPlugin;
import com.dexterous.flutterlocalnotifications.models.NotificationDetails;
import com.dexterous.flutterlocalnotifications.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;

public class ScheduledNotificationReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        NotificationManagerCompat notificationManager = NotificationManagerCompat.from((Context)context);
        String notificationDetailsJson = intent.getStringExtra(FlutterLocalNotificationsPlugin.NOTIFICATION_DETAILS);
        boolean repeat = intent.getBooleanExtra(FlutterLocalNotificationsPlugin.REPEAT, false);
        if (StringUtils.isNullOrEmpty(notificationDetailsJson).booleanValue()) {
            Notification notification = (Notification)intent.getParcelableExtra(FlutterLocalNotificationsPlugin.NOTIFICATION);
            notification.when = System.currentTimeMillis();
            int notificationId = intent.getIntExtra(FlutterLocalNotificationsPlugin.NOTIFICATION_ID, 0);
            notificationManager.notify(notificationId, notification);
            if (repeat) {
                return;
            }
            FlutterLocalNotificationsPlugin.removeNotificationFromCache(notificationId, context);
        } else {
            Gson gson = FlutterLocalNotificationsPlugin.buildGson();
            Type type = new TypeToken<NotificationDetails>(){}.getType();
            NotificationDetails notificationDetails = (NotificationDetails)gson.fromJson(notificationDetailsJson, type);
            FlutterLocalNotificationsPlugin.showNotification(context, notificationDetails);
            if (repeat) {
                return;
            }
            FlutterLocalNotificationsPlugin.removeNotificationFromCache(notificationDetails.id, context);
        }
    }
}

