/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlesignin;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.flutter.plugins.googlesignin.Executors;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class BackgroundTaskRunner {
    private final ThreadPoolExecutor executor;

    public BackgroundTaskRunner(int threads) {
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
        this.executor = new ThreadPoolExecutor(threads, threads, 1L, TimeUnit.SECONDS, workQueue);
    }

    public <T> void runInBackground(Callable<T> task, final Callback<T> callback) {
        final ListenableFuture<T> future = this.runInBackground(task);
        future.addListener(new Runnable(){

            @Override
            public void run() {
                callback.run(future);
            }
        }, Executors.uiThreadExecutor());
    }

    public <T> ListenableFuture<T> runInBackground(final Callable<T> task) {
        final SettableFuture future = SettableFuture.create();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!future.isCancelled()) {
                    try {
                        future.set(task.call());
                    }
                    catch (Throwable t) {
                        future.setException(t);
                    }
                }
            }
        });
        return future;
    }

    public static interface Callback<T> {
        public void run(Future<T> var1);
    }
}

