/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugins.googlesignin;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.google.android.gms.auth.GoogleAuthUtil;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInClient;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.RuntimeExecutionException;
import com.google.android.gms.tasks.Task;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import io.flutter.plugins.googlesignin.BackgroundTaskRunner;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class GoogleSignInPlugin
implements MethodChannel.MethodCallHandler {
    private static final String CHANNEL_NAME = "plugins.flutter.io/google_sign_in";
    private static final String METHOD_INIT = "init";
    private static final String METHOD_SIGN_IN_SILENTLY = "signInSilently";
    private static final String METHOD_SIGN_IN = "signIn";
    private static final String METHOD_GET_TOKENS = "getTokens";
    private static final String METHOD_SIGN_OUT = "signOut";
    private static final String METHOD_DISCONNECT = "disconnect";
    private static final String METHOD_IS_SIGNED_IN = "isSignedIn";
    private static final String METHOD_CLEAR_AUTH_CACHE = "clearAuthCache";
    private final IDelegate delegate;

    public static void registerWith(PluginRegistry.Registrar registrar) {
        MethodChannel channel = new MethodChannel(registrar.messenger(), CHANNEL_NAME);
        GoogleSignInPlugin instance = new GoogleSignInPlugin(registrar);
        channel.setMethodCallHandler((MethodChannel.MethodCallHandler)instance);
    }

    private GoogleSignInPlugin(PluginRegistry.Registrar registrar) {
        this.delegate = new Delegate(registrar);
    }

    public void onMethodCall(MethodCall call, MethodChannel.Result result) {
        switch (call.method) {
            case "init": {
                String signInOption = (String)call.argument("signInOption");
                List requestedScopes = (List)call.argument("scopes");
                String hostedDomain = (String)call.argument("hostedDomain");
                this.delegate.init(result, signInOption, requestedScopes, hostedDomain);
                break;
            }
            case "signInSilently": {
                this.delegate.signInSilently(result);
                break;
            }
            case "signIn": {
                this.delegate.signIn(result);
                break;
            }
            case "getTokens": {
                String email = (String)call.argument("email");
                boolean shouldRecoverAuth = (Boolean)call.argument("shouldRecoverAuth");
                this.delegate.getTokens(result, email, shouldRecoverAuth);
                break;
            }
            case "signOut": {
                this.delegate.signOut(result);
                break;
            }
            case "clearAuthCache": {
                String token = (String)call.argument("token");
                this.delegate.clearAuthCache(result, token);
                break;
            }
            case "disconnect": {
                this.delegate.disconnect(result);
                break;
            }
            case "isSignedIn": {
                this.delegate.isSignedIn(result);
                break;
            }
            default: {
                result.notImplemented();
            }
        }
    }

    public static final class Delegate
    implements IDelegate,
    PluginRegistry.ActivityResultListener {
        private static final int REQUEST_CODE_SIGNIN = 53293;
        private static final int REQUEST_CODE_RECOVER_AUTH = 53294;
        private static final String ERROR_REASON_EXCEPTION = "exception";
        private static final String ERROR_REASON_STATUS = "status";
        private static final String ERROR_REASON_SIGN_IN_CANCELED = "sign_in_canceled";
        private static final String ERROR_REASON_SIGN_IN_REQUIRED = "sign_in_required";
        private static final String ERROR_REASON_SIGN_IN_FAILED = "sign_in_failed";
        private static final String ERROR_FAILURE_TO_RECOVER_AUTH = "failed_to_recover_auth";
        private static final String ERROR_USER_RECOVERABLE_AUTH = "user_recoverable_auth";
        private static final String DEFAULT_SIGN_IN = "SignInOption.standard";
        private static final String DEFAULT_GAMES_SIGN_IN = "SignInOption.games";
        private final PluginRegistry.Registrar registrar;
        private final BackgroundTaskRunner backgroundTaskRunner = new BackgroundTaskRunner(1);
        private GoogleSignInClient signInClient;
        private List<String> requestedScopes;
        private PendingOperation pendingOperation;

        public Delegate(PluginRegistry.Registrar registrar) {
            this.registrar = registrar;
            registrar.addActivityResultListener((PluginRegistry.ActivityResultListener)this);
        }

        private void checkAndSetPendingOperation(String method, MethodChannel.Result result) {
            this.checkAndSetPendingOperation(method, result, null);
        }

        private void checkAndSetPendingOperation(String method, MethodChannel.Result result, Object data) {
            if (this.pendingOperation != null) {
                throw new IllegalStateException("Concurrent operations detected: " + this.pendingOperation.method + ", " + method);
            }
            this.pendingOperation = new PendingOperation(method, result, data);
        }

        @Override
        public void init(MethodChannel.Result result, String signInOption, List<String> requestedScopes, String hostedDomain) {
            try {
                GoogleSignInOptions.Builder optionsBuilder;
                switch (signInOption) {
                    case "SignInOption.games": {
                        optionsBuilder = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_GAMES_SIGN_IN);
                        break;
                    }
                    case "SignInOption.standard": {
                        optionsBuilder = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN).requestEmail();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown signInOption");
                    }
                }
                int clientIdIdentifier = this.registrar.context().getResources().getIdentifier("default_web_client_id", "string", this.registrar.context().getPackageName());
                if (clientIdIdentifier != 0) {
                    optionsBuilder.requestIdToken(this.registrar.context().getString(clientIdIdentifier));
                }
                for (String scope : requestedScopes) {
                    optionsBuilder.requestScopes(new Scope(scope), new Scope[0]);
                }
                if (!Strings.isNullOrEmpty((String)hostedDomain)) {
                    optionsBuilder.setHostedDomain(hostedDomain);
                }
                this.requestedScopes = requestedScopes;
                this.signInClient = GoogleSignIn.getClient((Context)this.registrar.context(), (GoogleSignInOptions)optionsBuilder.build());
                result.success(null);
            }
            catch (Exception e) {
                result.error(ERROR_REASON_EXCEPTION, e.getMessage(), null);
            }
        }

        @Override
        public void signInSilently(MethodChannel.Result result) {
            this.checkAndSetPendingOperation(GoogleSignInPlugin.METHOD_SIGN_IN_SILENTLY, result);
            Task task = this.signInClient.silentSignIn();
            if (task.isSuccessful()) {
                this.onSignInAccount((GoogleSignInAccount)task.getResult());
            } else {
                task.addOnCompleteListener((OnCompleteListener)new OnCompleteListener<GoogleSignInAccount>(){

                    public void onComplete(Task<GoogleSignInAccount> task) {
                        Delegate.this.onSignInResult((Task<GoogleSignInAccount>)task);
                    }
                });
            }
        }

        @Override
        public void signIn(MethodChannel.Result result) {
            if (this.registrar.activity() == null) {
                throw new IllegalStateException("signIn needs a foreground activity");
            }
            this.checkAndSetPendingOperation(GoogleSignInPlugin.METHOD_SIGN_IN, result);
            Intent signInIntent = this.signInClient.getSignInIntent();
            this.registrar.activity().startActivityForResult(signInIntent, 53293);
        }

        @Override
        public void signOut(MethodChannel.Result result) {
            this.checkAndSetPendingOperation(GoogleSignInPlugin.METHOD_SIGN_OUT, result);
            this.signInClient.signOut().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

                public void onComplete(Task<Void> task) {
                    if (task.isSuccessful()) {
                        Delegate.this.finishWithSuccess(null);
                    } else {
                        Delegate.this.finishWithError(Delegate.ERROR_REASON_STATUS, "Failed to signout.");
                    }
                }
            });
        }

        @Override
        public void disconnect(MethodChannel.Result result) {
            this.checkAndSetPendingOperation(GoogleSignInPlugin.METHOD_DISCONNECT, result);
            this.signInClient.revokeAccess().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

                public void onComplete(Task<Void> task) {
                    if (task.isSuccessful()) {
                        Delegate.this.finishWithSuccess(null);
                    } else {
                        Delegate.this.finishWithError(Delegate.ERROR_REASON_STATUS, "Failed to disconnect.");
                    }
                }
            });
        }

        @Override
        public void isSignedIn(MethodChannel.Result result) {
            boolean value = GoogleSignIn.getLastSignedInAccount((Context)this.registrar.context()) != null;
            result.success((Object)value);
        }

        private void onSignInResult(Task<GoogleSignInAccount> completedTask) {
            try {
                GoogleSignInAccount account = (GoogleSignInAccount)completedTask.getResult(ApiException.class);
                this.onSignInAccount(account);
            }
            catch (ApiException e) {
                String errorCode = this.errorCodeForStatus(e.getStatusCode());
                this.finishWithError(errorCode, e.toString());
            }
            catch (RuntimeExecutionException e) {
                this.finishWithError(ERROR_REASON_EXCEPTION, e.toString());
            }
        }

        private void onSignInAccount(GoogleSignInAccount account) {
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("email", account.getEmail());
            response.put("id", account.getId());
            response.put("idToken", account.getIdToken());
            response.put("displayName", account.getDisplayName());
            if (account.getPhotoUrl() != null) {
                response.put("photoUrl", account.getPhotoUrl().toString());
            }
            this.finishWithSuccess(response);
        }

        private String errorCodeForStatus(int statusCode) {
            if (statusCode == 12501) {
                return ERROR_REASON_SIGN_IN_CANCELED;
            }
            if (statusCode == 4) {
                return ERROR_REASON_SIGN_IN_REQUIRED;
            }
            return ERROR_REASON_SIGN_IN_FAILED;
        }

        private void finishWithSuccess(Object data) {
            this.pendingOperation.result.success(data);
            this.pendingOperation = null;
        }

        private void finishWithError(String errorCode, String errorMessage) {
            this.pendingOperation.result.error(errorCode, errorMessage, null);
            this.pendingOperation = null;
        }

        @Override
        public void clearAuthCache(final MethodChannel.Result result, final String token) {
            Callable<Void> clearTokenTask = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    GoogleAuthUtil.clearToken((Context)Delegate.this.registrar.context(), (String)token);
                    return null;
                }
            };
            this.backgroundTaskRunner.runInBackground(clearTokenTask, new BackgroundTaskRunner.Callback<Void>(){

                @Override
                public void run(Future<Void> clearTokenFuture) {
                    try {
                        result.success((Object)clearTokenFuture.get());
                    }
                    catch (ExecutionException e) {
                        result.error(Delegate.ERROR_REASON_EXCEPTION, e.getCause().getMessage(), null);
                    }
                    catch (InterruptedException e) {
                        result.error(Delegate.ERROR_REASON_EXCEPTION, e.getMessage(), null);
                        Thread.currentThread().interrupt();
                    }
                }
            });
        }

        @Override
        public void getTokens(final MethodChannel.Result result, final String email, final boolean shouldRecoverAuth) {
            if (email == null) {
                result.error(ERROR_REASON_EXCEPTION, "Email is null", null);
                return;
            }
            Callable<String> getTokenTask = new Callable<String>(){

                @Override
                public String call() throws Exception {
                    Account account = new Account(email, "com.google");
                    String scopesStr = "oauth2:" + Joiner.on((char)' ').join((Iterable)Delegate.this.requestedScopes);
                    return GoogleAuthUtil.getToken((Context)Delegate.this.registrar.context(), (Account)account, (String)scopesStr);
                }
            };
            this.backgroundTaskRunner.runInBackground(getTokenTask, new BackgroundTaskRunner.Callback<String>(){

                @Override
                public void run(Future<String> tokenFuture) {
                    try {
                        String token = tokenFuture.get();
                        HashMap<String, String> tokenResult = new HashMap<String, String>();
                        tokenResult.put("accessToken", token);
                        result.success(tokenResult);
                    }
                    catch (ExecutionException e) {
                        if (e.getCause() instanceof UserRecoverableAuthException) {
                            if (shouldRecoverAuth && Delegate.this.pendingOperation == null) {
                                Activity activity = Delegate.this.registrar.activity();
                                if (activity == null) {
                                    result.error(Delegate.ERROR_USER_RECOVERABLE_AUTH, "Cannot recover auth because app is not in foreground. " + e.getLocalizedMessage(), null);
                                } else {
                                    Delegate.this.checkAndSetPendingOperation(GoogleSignInPlugin.METHOD_GET_TOKENS, result, email);
                                    Intent recoveryIntent = ((UserRecoverableAuthException)e.getCause()).getIntent();
                                    activity.startActivityForResult(recoveryIntent, 53294);
                                }
                            } else {
                                result.error(Delegate.ERROR_USER_RECOVERABLE_AUTH, e.getLocalizedMessage(), null);
                            }
                        } else {
                            result.error(Delegate.ERROR_REASON_EXCEPTION, e.getCause().getMessage(), null);
                        }
                    }
                    catch (InterruptedException e) {
                        result.error(Delegate.ERROR_REASON_EXCEPTION, e.getMessage(), null);
                        Thread.currentThread().interrupt();
                    }
                }
            });
        }

        public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
            if (this.pendingOperation == null) {
                return false;
            }
            switch (requestCode) {
                case 53294: {
                    if (resultCode == -1) {
                        MethodChannel.Result result = this.pendingOperation.result;
                        String email = (String)this.pendingOperation.data;
                        this.pendingOperation = null;
                        this.getTokens(result, email, false);
                    } else {
                        this.finishWithError(ERROR_FAILURE_TO_RECOVER_AUTH, "Failed attempt to recover authentication");
                    }
                    return true;
                }
                case 53293: {
                    if (data != null) {
                        this.onSignInResult((Task<GoogleSignInAccount>)GoogleSignIn.getSignedInAccountFromIntent((Intent)data));
                    } else {
                        this.finishWithError(ERROR_REASON_SIGN_IN_FAILED, "Signin failed");
                    }
                    return true;
                }
            }
            return false;
        }

        private static class PendingOperation {
            final String method;
            final MethodChannel.Result result;
            final Object data;

            PendingOperation(String method, MethodChannel.Result result, Object data) {
                this.method = method;
                this.result = result;
                this.data = data;
            }
        }
    }

    public static interface IDelegate {
        public void init(MethodChannel.Result var1, String var2, List<String> var3, String var4);

        public void signInSilently(MethodChannel.Result var1);

        public void signIn(MethodChannel.Result var1);

        public void getTokens(MethodChannel.Result var1, String var2, boolean var3);

        public void clearAuthCache(MethodChannel.Result var1, String var2);

        public void signOut(MethodChannel.Result var1);

        public void disconnect(MethodChannel.Result var1);

        public void isSignedIn(MethodChannel.Result var1);
    }
}

