/*
 * Decompiled with CFR 0.152.
 */
package com.pauldemarco.flutterblue;

import com.google.protobuf.ByteString;
import com.pauldemarco.flutterblue.Protos;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;

class AdvertisementParser {
    AdvertisementParser() {
    }

    static Protos.AdvertisementData parse(byte[] rawData) {
        int length;
        ByteBuffer data = ByteBuffer.wrap(rawData).asReadOnlyBuffer().order(ByteOrder.LITTLE_ENDIAN);
        Protos.AdvertisementData.Builder ret = Protos.AdvertisementData.newBuilder();
        boolean seenLongLocalName = false;
        block8: while ((length = data.get() & 0xFF) != 0) {
            if (length > data.remaining()) {
                throw new ArrayIndexOutOfBoundsException("Not enough data.");
            }
            int type = data.get() & 0xFF;
            --length;
            switch (type) {
                case 8: 
                case 9: {
                    if (seenLongLocalName) {
                        data.position(data.position() + length);
                        continue block8;
                    }
                    byte[] name = new byte[length];
                    data.get(name);
                    try {
                        ret.setLocalName(new String(name, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                    if (type != 9) continue block8;
                    seenLongLocalName = true;
                    continue block8;
                }
                case 10: {
                    ret.setTxPowerLevel(Protos.Int32Value.newBuilder().setValue(data.get()));
                    continue block8;
                }
                case 22: 
                case 32: 
                case 33: {
                    UUID uuid;
                    int remainingDataLength = 0;
                    if (type == 22 || type == 32) {
                        long uuidValue;
                        if (type == 22) {
                            uuidValue = data.getShort() & 0xFFFF;
                            remainingDataLength = length - 2;
                        } else {
                            uuidValue = data.getInt() & 0xFFFFFFFF;
                            remainingDataLength = length - 4;
                        }
                        uuid = UUID.fromString(String.format("%08x-0000-1000-8000-00805f9b34fb", uuidValue));
                    } else {
                        long msb = data.getLong();
                        long lsb = data.getLong();
                        uuid = new UUID(msb, lsb);
                        remainingDataLength = length - 16;
                    }
                    byte[] remainingData = new byte[remainingDataLength];
                    data.get(remainingData);
                    ret.putServiceData(uuid.toString(), ByteString.copyFrom((byte[])remainingData));
                    continue block8;
                }
                case 255: {
                    if (length < 2) {
                        throw new ArrayIndexOutOfBoundsException("Not enough data for Manufacturer specific data.");
                    }
                    short manufacturerId = data.getShort();
                    if (length - 2 <= 0) continue block8;
                    byte[] msd = new byte[length - 2];
                    data.get(msd);
                    ret.putManufacturerData(manufacturerId, ByteString.copyFrom((byte[])msd));
                    continue block8;
                }
            }
            data.position(data.position() + length);
        }
        return (Protos.AdvertisementData)ret.build();
    }
}

