/*
 * Decompiled with CFR 0.152.
 */
package com.pauldemarco.flutterblue;

import android.annotation.TargetApi;
import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.ParcelUuid;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.pauldemarco.flutterblue.ProtoMaker;
import com.pauldemarco.flutterblue.Protos;
import io.flutter.plugin.common.EventChannel;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.PluginRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class FlutterBluePlugin
implements MethodChannel.MethodCallHandler,
PluginRegistry.RequestPermissionsResultListener {
    private static final String TAG = "FlutterBluePlugin";
    private static final String NAMESPACE = "plugins.pauldemarco.com/flutter_blue";
    private static final int REQUEST_COARSE_LOCATION_PERMISSIONS = 1452;
    private static final UUID CCCD_ID = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    private final PluginRegistry.Registrar registrar;
    private final MethodChannel channel;
    private final EventChannel stateChannel;
    private final EventChannel scanResultChannel;
    private final EventChannel servicesDiscoveredChannel;
    private final EventChannel characteristicReadChannel;
    private final EventChannel descriptorReadChannel;
    private final BluetoothManager mBluetoothManager;
    private BluetoothAdapter mBluetoothAdapter;
    private final Map<String, BluetoothGatt> mGattServers = new HashMap<String, BluetoothGatt>();
    private LogLevel logLevel = LogLevel.EMERGENCY;
    private MethodCall pendingCall;
    private MethodChannel.Result pendingResult;
    private final EventChannel.StreamHandler stateHandler = new EventChannel.StreamHandler(){
        private EventChannel.EventSink sink;
        private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                    int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
                    switch (state) {
                        case 10: {
                            sink.success((Object)((Protos.BluetoothState)Protos.BluetoothState.newBuilder().setState(Protos.BluetoothState.State.OFF).build()).toByteArray());
                            break;
                        }
                        case 13: {
                            sink.success((Object)((Protos.BluetoothState)Protos.BluetoothState.newBuilder().setState(Protos.BluetoothState.State.TURNING_OFF).build()).toByteArray());
                            break;
                        }
                        case 12: {
                            sink.success((Object)((Protos.BluetoothState)Protos.BluetoothState.newBuilder().setState(Protos.BluetoothState.State.ON).build()).toByteArray());
                            break;
                        }
                        case 11: {
                            sink.success((Object)((Protos.BluetoothState)Protos.BluetoothState.newBuilder().setState(Protos.BluetoothState.State.TURNING_ON).build()).toByteArray());
                        }
                    }
                }
            }
        };

        public void onListen(Object o, EventChannel.EventSink eventSink) {
            this.sink = eventSink;
            IntentFilter filter = new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED");
            FlutterBluePlugin.this.registrar.activity().registerReceiver(this.mReceiver, filter);
        }

        public void onCancel(Object o) {
            this.sink = null;
            FlutterBluePlugin.this.registrar.activity().unregisterReceiver(this.mReceiver);
        }
    };
    private ScanCallback scanCallback21;
    private BluetoothAdapter.LeScanCallback scanCallback18;
    private EventChannel.EventSink scanResultsSink;
    private final EventChannel.StreamHandler scanResultsHandler = new EventChannel.StreamHandler(){

        public void onListen(Object o, EventChannel.EventSink eventSink) {
            FlutterBluePlugin.this.scanResultsSink = eventSink;
        }

        public void onCancel(Object o) {
            FlutterBluePlugin.this.scanResultsSink = null;
        }
    };
    private EventChannel.EventSink servicesDiscoveredSink;
    private final EventChannel.StreamHandler servicesDiscoveredHandler = new EventChannel.StreamHandler(){

        public void onListen(Object o, EventChannel.EventSink eventSink) {
            FlutterBluePlugin.this.servicesDiscoveredSink = eventSink;
        }

        public void onCancel(Object o) {
            FlutterBluePlugin.this.servicesDiscoveredSink = null;
        }
    };
    private EventChannel.EventSink characteristicReadSink;
    private final EventChannel.StreamHandler characteristicReadHandler = new EventChannel.StreamHandler(){

        public void onListen(Object o, EventChannel.EventSink eventSink) {
            FlutterBluePlugin.this.characteristicReadSink = eventSink;
        }

        public void onCancel(Object o) {
            FlutterBluePlugin.this.characteristicReadSink = null;
        }
    };
    private EventChannel.EventSink descriptorReadSink;
    private final EventChannel.StreamHandler descriptorReadHandler = new EventChannel.StreamHandler(){

        public void onListen(Object o, EventChannel.EventSink eventSink) {
            FlutterBluePlugin.this.descriptorReadSink = eventSink;
        }

        public void onCancel(Object o) {
            FlutterBluePlugin.this.descriptorReadSink = null;
        }
    };
    private final BluetoothGattCallback mGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            FlutterBluePlugin.this.log(LogLevel.DEBUG, "[onConnectionStateChange] status: " + status + " newState: " + newState);
            FlutterBluePlugin.this.channel.invokeMethod("DeviceState", (Object)ProtoMaker.from(gatt.getDevice(), newState).toByteArray());
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            FlutterBluePlugin.this.log(LogLevel.DEBUG, "[onServicesDiscovered] count: " + gatt.getServices().size() + " status: " + status);
            if (FlutterBluePlugin.this.servicesDiscoveredSink != null) {
                Protos.DiscoverServicesResult.Builder p = Protos.DiscoverServicesResult.newBuilder();
                p.setRemoteId(gatt.getDevice().getAddress());
                for (BluetoothGattService s : gatt.getServices()) {
                    p.addServices(ProtoMaker.from(gatt.getDevice(), s, gatt));
                }
                FlutterBluePlugin.this.servicesDiscoveredSink.success((Object)((Protos.DiscoverServicesResult)p.build()).toByteArray());
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            FlutterBluePlugin.this.log(LogLevel.DEBUG, "[onCharacteristicRead] uuid: " + characteristic.getUuid().toString() + " status: " + status);
            if (FlutterBluePlugin.this.characteristicReadSink != null) {
                Protos.ReadCharacteristicResponse.Builder p = Protos.ReadCharacteristicResponse.newBuilder();
                p.setRemoteId(gatt.getDevice().getAddress());
                p.setCharacteristic(ProtoMaker.from(characteristic, gatt));
                FlutterBluePlugin.this.characteristicReadSink.success((Object)((Protos.ReadCharacteristicResponse)p.build()).toByteArray());
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            FlutterBluePlugin.this.log(LogLevel.DEBUG, "[onCharacteristicWrite] uuid: " + characteristic.getUuid().toString() + " status: " + status);
            Protos.WriteCharacteristicRequest.Builder request = Protos.WriteCharacteristicRequest.newBuilder();
            request.setRemoteId(gatt.getDevice().getAddress());
            request.setCharacteristicUuid(characteristic.getUuid().toString());
            request.setServiceUuid(characteristic.getService().getUuid().toString());
            Protos.WriteCharacteristicResponse.Builder p = Protos.WriteCharacteristicResponse.newBuilder();
            p.setRequest(request);
            p.setSuccess(status == 0);
            FlutterBluePlugin.this.channel.invokeMethod("WriteCharacteristicResponse", (Object)((Protos.WriteCharacteristicResponse)p.build()).toByteArray());
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            FlutterBluePlugin.this.log(LogLevel.DEBUG, "[onCharacteristicChanged] uuid: " + characteristic.getUuid().toString());
            Protos.OnNotificationResponse.Builder p = Protos.OnNotificationResponse.newBuilder();
            p.setRemoteId(gatt.getDevice().getAddress());
            p.setCharacteristic(ProtoMaker.from(characteristic, gatt));
            FlutterBluePlugin.this.channel.invokeMethod("OnValueChanged", (Object)((Protos.OnNotificationResponse)p.build()).toByteArray());
        }

        public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            FlutterBluePlugin.this.log(LogLevel.DEBUG, "[onDescriptorRead] uuid: " + descriptor.getUuid().toString() + " status: " + status);
            if (FlutterBluePlugin.this.descriptorReadSink != null) {
                Protos.ReadDescriptorRequest.Builder q = Protos.ReadDescriptorRequest.newBuilder();
                q.setRemoteId(gatt.getDevice().getAddress());
                q.setCharacteristicUuid(descriptor.getCharacteristic().getUuid().toString());
                q.setDescriptorUuid(descriptor.getUuid().toString());
                if (descriptor.getCharacteristic().getService().getType() == 0) {
                    q.setServiceUuid(descriptor.getCharacteristic().getService().getUuid().toString());
                } else {
                    block0: for (BluetoothGattService s : gatt.getServices()) {
                        for (BluetoothGattService ss : s.getIncludedServices()) {
                            if (!ss.getUuid().equals(descriptor.getCharacteristic().getService().getUuid())) continue;
                            q.setServiceUuid(s.getUuid().toString());
                            q.setSecondaryServiceUuid(ss.getUuid().toString());
                            continue block0;
                        }
                    }
                }
                Protos.ReadDescriptorResponse.Builder p = Protos.ReadDescriptorResponse.newBuilder();
                p.setRequest(q);
                p.setValue(ByteString.copyFrom((byte[])descriptor.getValue()));
                FlutterBluePlugin.this.descriptorReadSink.success((Object)((Protos.ReadDescriptorResponse)p.build()).toByteArray());
            }
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            FlutterBluePlugin.this.log(LogLevel.DEBUG, "[onDescriptorWrite] uuid: " + descriptor.getUuid().toString() + " status: " + status);
            Protos.WriteDescriptorRequest.Builder request = Protos.WriteDescriptorRequest.newBuilder();
            request.setRemoteId(gatt.getDevice().getAddress());
            request.setDescriptorUuid(descriptor.getUuid().toString());
            request.setCharacteristicUuid(descriptor.getCharacteristic().getUuid().toString());
            request.setServiceUuid(descriptor.getCharacteristic().getService().getUuid().toString());
            Protos.WriteDescriptorResponse.Builder p = Protos.WriteDescriptorResponse.newBuilder();
            p.setRequest(request);
            p.setSuccess(status == 0);
            FlutterBluePlugin.this.channel.invokeMethod("WriteDescriptorResponse", (Object)((Protos.WriteDescriptorResponse)p.build()).toByteArray());
            if (descriptor.getUuid().compareTo(CCCD_ID) == 0) {
                Protos.SetNotificationResponse.Builder q = Protos.SetNotificationResponse.newBuilder();
                q.setRemoteId(gatt.getDevice().getAddress());
                q.setCharacteristic(ProtoMaker.from(descriptor.getCharacteristic(), gatt));
                FlutterBluePlugin.this.channel.invokeMethod("SetNotificationResponse", (Object)((Protos.SetNotificationResponse)q.build()).toByteArray());
            }
        }

        public void onReliableWriteCompleted(BluetoothGatt gatt, int status) {
            FlutterBluePlugin.this.log(LogLevel.DEBUG, "[onReliableWriteCompleted] status: " + status);
        }

        public void onReadRemoteRssi(BluetoothGatt gatt, int rssi, int status) {
            FlutterBluePlugin.this.log(LogLevel.DEBUG, "[onReadRemoteRssi] rssi: " + rssi + " status: " + status);
        }

        public void onMtuChanged(BluetoothGatt gatt, int mtu, int status) {
            FlutterBluePlugin.this.log(LogLevel.DEBUG, "[onMtuChanged] mtu: " + mtu + " status: " + status);
        }
    };

    public static void registerWith(PluginRegistry.Registrar registrar) {
        FlutterBluePlugin instance = new FlutterBluePlugin(registrar);
        registrar.addRequestPermissionsResultListener((PluginRegistry.RequestPermissionsResultListener)instance);
    }

    FlutterBluePlugin(PluginRegistry.Registrar r) {
        this.registrar = r;
        this.channel = new MethodChannel(this.registrar.messenger(), "plugins.pauldemarco.com/flutter_blue/methods");
        this.stateChannel = new EventChannel(this.registrar.messenger(), "plugins.pauldemarco.com/flutter_blue/state");
        this.scanResultChannel = new EventChannel(this.registrar.messenger(), "plugins.pauldemarco.com/flutter_blue/scanResult");
        this.servicesDiscoveredChannel = new EventChannel(this.registrar.messenger(), "plugins.pauldemarco.com/flutter_blue/servicesDiscovered");
        this.characteristicReadChannel = new EventChannel(this.registrar.messenger(), "plugins.pauldemarco.com/flutter_blue/characteristicRead");
        this.descriptorReadChannel = new EventChannel(this.registrar.messenger(), "plugins.pauldemarco.com/flutter_blue/descriptorRead");
        this.mBluetoothManager = (BluetoothManager)r.activity().getSystemService("bluetooth");
        this.mBluetoothAdapter = this.mBluetoothManager.getAdapter();
        this.channel.setMethodCallHandler((MethodChannel.MethodCallHandler)this);
        this.stateChannel.setStreamHandler(this.stateHandler);
        this.scanResultChannel.setStreamHandler(this.scanResultsHandler);
        this.servicesDiscoveredChannel.setStreamHandler(this.servicesDiscoveredHandler);
        this.characteristicReadChannel.setStreamHandler(this.characteristicReadHandler);
        this.descriptorReadChannel.setStreamHandler(this.descriptorReadHandler);
    }

    public void onMethodCall(MethodCall call, MethodChannel.Result result) {
        if (this.mBluetoothAdapter == null && !"isAvailable".equals(call.method)) {
            result.error("bluetooth_unavailable", "the device does not have bluetooth", null);
            return;
        }
        switch (call.method) {
            case "setLogLevel": {
                int logLevelIndex = (Integer)call.arguments;
                this.logLevel = LogLevel.values()[logLevelIndex];
                result.success(null);
                break;
            }
            case "state": {
                Protos.BluetoothState.Builder p = Protos.BluetoothState.newBuilder();
                try {
                    switch (this.mBluetoothAdapter.getState()) {
                        case 10: {
                            p.setState(Protos.BluetoothState.State.OFF);
                            break;
                        }
                        case 12: {
                            p.setState(Protos.BluetoothState.State.ON);
                            break;
                        }
                        case 13: {
                            p.setState(Protos.BluetoothState.State.TURNING_OFF);
                            break;
                        }
                        case 11: {
                            p.setState(Protos.BluetoothState.State.TURNING_ON);
                            break;
                        }
                        default: {
                            p.setState(Protos.BluetoothState.State.UNKNOWN);
                            break;
                        }
                    }
                }
                catch (SecurityException e) {
                    p.setState(Protos.BluetoothState.State.UNAUTHORIZED);
                }
                result.success((Object)((Protos.BluetoothState)p.build()).toByteArray());
                break;
            }
            case "isAvailable": {
                result.success((Object)(this.mBluetoothAdapter != null ? 1 : 0));
                break;
            }
            case "isOn": {
                result.success((Object)this.mBluetoothAdapter.isEnabled());
                break;
            }
            case "startScan": {
                if (ContextCompat.checkSelfPermission((Context)this.registrar.activity(), (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                    ActivityCompat.requestPermissions((Activity)this.registrar.activity(), (String[])new String[]{"android.permission.ACCESS_COARSE_LOCATION"}, (int)1452);
                    this.pendingCall = call;
                    this.pendingResult = result;
                    break;
                }
                this.startScan(call, result);
                break;
            }
            case "stopScan": {
                this.stopScan();
                result.success(null);
                break;
            }
            case "connect": {
                Protos.ConnectRequest options;
                byte[] data = (byte[])call.arguments();
                try {
                    options = (Protos.ConnectRequest)((Protos.ConnectRequest.Builder)Protos.ConnectRequest.newBuilder().mergeFrom(data)).build();
                }
                catch (InvalidProtocolBufferException e) {
                    result.error("RuntimeException", e.getMessage(), (Object)e);
                    break;
                }
                String deviceId = options.getRemoteId();
                BluetoothDevice device = this.mBluetoothAdapter.getRemoteDevice(deviceId);
                boolean isConnected = this.mBluetoothManager.getConnectedDevices(7).contains(device);
                if (this.mGattServers.containsKey(deviceId) && isConnected) {
                    result.error("already_connected", "connection with device already exists", null);
                    return;
                }
                if (this.mGattServers.containsKey(deviceId) && !isConnected && !this.mGattServers.get(deviceId).connect()) {
                    result.error("reconnect_error", "error when reconnecting to device", null);
                    return;
                }
                BluetoothGatt gattServer = device.connectGatt((Context)this.registrar.activity(), options.getAndroidAutoConnect(), this.mGattCallback);
                this.mGattServers.put(deviceId, gattServer);
                result.success(null);
                break;
            }
            case "disconnect": {
                String deviceId = (String)call.arguments;
                BluetoothGatt gattServer = this.mGattServers.remove(deviceId);
                if (gattServer != null) {
                    gattServer.close();
                }
                result.success(null);
                break;
            }
            case "deviceState": {
                String deviceId = (String)call.arguments;
                BluetoothDevice device = this.mBluetoothAdapter.getRemoteDevice(deviceId);
                int state = this.mBluetoothManager.getConnectionState(device, 7);
                try {
                    result.success((Object)ProtoMaker.from(device, state).toByteArray());
                }
                catch (Exception e) {
                    result.error("device_state_error", e.getMessage(), null);
                }
                break;
            }
            case "discoverServices": {
                String deviceId = (String)call.arguments;
                BluetoothGatt gattServer = this.mGattServers.get(deviceId);
                if (gattServer == null) {
                    result.error("discover_services_error", "no instance of BluetoothGatt, have you connected first?", null);
                    return;
                }
                if (gattServer.discoverServices()) {
                    result.success(null);
                    break;
                }
                result.error("discover_services_error", "unknown reason", null);
                break;
            }
            case "services": {
                String deviceId = (String)call.arguments;
                BluetoothGatt gattServer = this.mGattServers.get(deviceId);
                if (gattServer == null) {
                    result.error("get_services_error", "no instance of BluetoothGatt, have you connected first?", null);
                    return;
                }
                if (gattServer.getServices().isEmpty()) {
                    result.error("get_services_error", "services are empty, have you called discoverServices() yet?", null);
                    return;
                }
                Protos.DiscoverServicesResult.Builder p = Protos.DiscoverServicesResult.newBuilder();
                p.setRemoteId(deviceId);
                for (BluetoothGattService s : gattServer.getServices()) {
                    p.addServices(ProtoMaker.from(gattServer.getDevice(), s, gattServer));
                }
                result.success((Object)((Protos.DiscoverServicesResult)p.build()).toByteArray());
                break;
            }
            case "readCharacteristic": {
                BluetoothGattCharacteristic characteristic;
                BluetoothGatt gattServer;
                Protos.ReadCharacteristicRequest request;
                byte[] data = (byte[])call.arguments();
                try {
                    request = (Protos.ReadCharacteristicRequest)((Protos.ReadCharacteristicRequest.Builder)Protos.ReadCharacteristicRequest.newBuilder().mergeFrom(data)).build();
                }
                catch (InvalidProtocolBufferException e) {
                    result.error("RuntimeException", e.getMessage(), (Object)e);
                    break;
                }
                try {
                    gattServer = this.locateGatt(request.getRemoteId());
                    characteristic = this.locateCharacteristic(gattServer, request.getServiceUuid(), request.getSecondaryServiceUuid(), request.getCharacteristicUuid());
                }
                catch (Exception e) {
                    result.error("read_characteristic_error", e.getMessage(), null);
                    return;
                }
                if (gattServer.readCharacteristic(characteristic)) {
                    result.success(null);
                    break;
                }
                result.error("read_characteristic_error", "unknown reason, may occur if readCharacteristic was called before last read finished.", null);
                break;
            }
            case "readDescriptor": {
                BluetoothGattDescriptor descriptor;
                BluetoothGatt gattServer;
                Protos.ReadDescriptorRequest request;
                byte[] data = (byte[])call.arguments();
                try {
                    request = (Protos.ReadDescriptorRequest)((Protos.ReadDescriptorRequest.Builder)Protos.ReadDescriptorRequest.newBuilder().mergeFrom(data)).build();
                }
                catch (InvalidProtocolBufferException e) {
                    result.error("RuntimeException", e.getMessage(), (Object)e);
                    break;
                }
                try {
                    gattServer = this.locateGatt(request.getRemoteId());
                    BluetoothGattCharacteristic characteristic = this.locateCharacteristic(gattServer, request.getServiceUuid(), request.getSecondaryServiceUuid(), request.getCharacteristicUuid());
                    descriptor = this.locateDescriptor(characteristic, request.getDescriptorUuid());
                }
                catch (Exception e) {
                    result.error("read_descriptor_error", e.getMessage(), null);
                    return;
                }
                if (gattServer.readDescriptor(descriptor)) {
                    result.success(null);
                    break;
                }
                result.error("read_descriptor_error", "unknown reason, may occur if readDescriptor was called before last read finished.", null);
                break;
            }
            case "writeCharacteristic": {
                BluetoothGattCharacteristic characteristic;
                BluetoothGatt gattServer;
                Protos.WriteCharacteristicRequest request;
                byte[] data = (byte[])call.arguments();
                try {
                    request = (Protos.WriteCharacteristicRequest)((Protos.WriteCharacteristicRequest.Builder)Protos.WriteCharacteristicRequest.newBuilder().mergeFrom(data)).build();
                }
                catch (InvalidProtocolBufferException e) {
                    result.error("RuntimeException", e.getMessage(), (Object)e);
                    break;
                }
                try {
                    gattServer = this.locateGatt(request.getRemoteId());
                    characteristic = this.locateCharacteristic(gattServer, request.getServiceUuid(), request.getSecondaryServiceUuid(), request.getCharacteristicUuid());
                }
                catch (Exception e) {
                    result.error("write_characteristic_error", e.getMessage(), null);
                    return;
                }
                if (!characteristic.setValue(request.getValue().toByteArray())) {
                    result.error("write_characteristic_error", "could not set the local value of characteristic", null);
                }
                if (request.getWriteType() == Protos.WriteCharacteristicRequest.WriteType.WITHOUT_RESPONSE) {
                    characteristic.setWriteType(1);
                } else {
                    characteristic.setWriteType(2);
                }
                if (!gattServer.writeCharacteristic(characteristic)) {
                    result.error("write_characteristic_error", "writeCharacteristic failed", null);
                    return;
                }
                result.success(null);
                break;
            }
            case "writeDescriptor": {
                BluetoothGattDescriptor descriptor;
                BluetoothGatt gattServer;
                Protos.WriteDescriptorRequest request;
                byte[] data = (byte[])call.arguments();
                try {
                    request = (Protos.WriteDescriptorRequest)((Protos.WriteDescriptorRequest.Builder)Protos.WriteDescriptorRequest.newBuilder().mergeFrom(data)).build();
                }
                catch (InvalidProtocolBufferException e) {
                    result.error("RuntimeException", e.getMessage(), (Object)e);
                    break;
                }
                try {
                    gattServer = this.locateGatt(request.getRemoteId());
                    BluetoothGattCharacteristic characteristic = this.locateCharacteristic(gattServer, request.getServiceUuid(), request.getSecondaryServiceUuid(), request.getCharacteristicUuid());
                    descriptor = this.locateDescriptor(characteristic, request.getDescriptorUuid());
                }
                catch (Exception e) {
                    result.error("write_descriptor_error", e.getMessage(), null);
                    return;
                }
                if (!descriptor.setValue(request.getValue().toByteArray())) {
                    result.error("write_descriptor_error", "could not set the local value for descriptor", null);
                }
                if (!gattServer.writeDescriptor(descriptor)) {
                    result.error("write_descriptor_error", "writeCharacteristic failed", null);
                    return;
                }
                result.success(null);
                break;
            }
            case "setNotification": {
                BluetoothGattDescriptor cccDescriptor;
                BluetoothGattCharacteristic characteristic;
                BluetoothGatt gattServer;
                Protos.SetNotificationRequest request;
                byte[] data = (byte[])call.arguments();
                try {
                    request = (Protos.SetNotificationRequest)((Protos.SetNotificationRequest.Builder)Protos.SetNotificationRequest.newBuilder().mergeFrom(data)).build();
                }
                catch (InvalidProtocolBufferException e) {
                    result.error("RuntimeException", e.getMessage(), (Object)e);
                    break;
                }
                try {
                    gattServer = this.locateGatt(request.getRemoteId());
                    characteristic = this.locateCharacteristic(gattServer, request.getServiceUuid(), request.getSecondaryServiceUuid(), request.getCharacteristicUuid());
                    cccDescriptor = characteristic.getDescriptor(CCCD_ID);
                    if (cccDescriptor == null) {
                        throw new Exception("could not locate CCCD descriptor for characteristic: " + characteristic.getUuid().toString());
                    }
                }
                catch (Exception e) {
                    result.error("set_notification_error", e.getMessage(), null);
                    return;
                }
                byte[] value = null;
                if (request.getEnable()) {
                    boolean canIndicate;
                    boolean canNotify = (characteristic.getProperties() & 0x10) > 0;
                    boolean bl = canIndicate = (characteristic.getProperties() & 0x20) > 0;
                    if (!canIndicate && !canNotify) {
                        result.error("set_notification_error", "the characteristic cannot notify or indicate", null);
                        return;
                    }
                    if (canIndicate) {
                        value = BluetoothGattDescriptor.ENABLE_INDICATION_VALUE;
                    }
                    if (canNotify) {
                        value = BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE;
                    }
                } else {
                    value = BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE;
                }
                if (!gattServer.setCharacteristicNotification(characteristic, request.getEnable())) {
                    result.error("set_notification_error", "could not set characteristic notifications to :" + request.getEnable(), null);
                    return;
                }
                if (!cccDescriptor.setValue(value)) {
                    result.error("set_notification_error", "error when setting the descriptor value to: " + value, null);
                    return;
                }
                if (!gattServer.writeDescriptor(cccDescriptor)) {
                    result.error("set_notification_error", "error when writing the descriptor", null);
                    return;
                }
                result.success(null);
                break;
            }
            default: {
                result.notImplemented();
            }
        }
    }

    public boolean onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == 1452) {
            if (grantResults[0] == 0) {
                this.startScan(this.pendingCall, this.pendingResult);
            } else {
                this.pendingResult.error("no_permissions", "flutter_blue plugin requires location permissions for scanning", null);
                this.pendingResult = null;
                this.pendingCall = null;
            }
            return true;
        }
        return false;
    }

    private BluetoothGatt locateGatt(String remoteId) throws Exception {
        BluetoothGatt gattServer = this.mGattServers.get(remoteId);
        if (gattServer == null) {
            throw new Exception("no instance of BluetoothGatt, have you connected first?");
        }
        return gattServer;
    }

    private BluetoothGattCharacteristic locateCharacteristic(BluetoothGatt gattServer, String serviceId, String secondaryServiceId, String characteristicId) throws Exception {
        BluetoothGattService service;
        BluetoothGattCharacteristic characteristic;
        BluetoothGattService primaryService = gattServer.getService(UUID.fromString(serviceId));
        if (primaryService == null) {
            throw new Exception("service (" + serviceId + ") could not be located on the device");
        }
        BluetoothGattService secondaryService = null;
        if (secondaryServiceId.length() > 0) {
            for (BluetoothGattService s : primaryService.getIncludedServices()) {
                if (!s.getUuid().equals(UUID.fromString(secondaryServiceId))) continue;
                secondaryService = s;
            }
            if (secondaryService == null) {
                throw new Exception("secondary service (" + secondaryServiceId + ") could not be located on the device");
            }
        }
        if ((characteristic = (service = secondaryService != null ? secondaryService : primaryService).getCharacteristic(UUID.fromString(characteristicId))) == null) {
            throw new Exception("characteristic (" + characteristicId + ") could not be located in the service (" + service.getUuid().toString() + ")");
        }
        return characteristic;
    }

    private BluetoothGattDescriptor locateDescriptor(BluetoothGattCharacteristic characteristic, String descriptorId) throws Exception {
        BluetoothGattDescriptor descriptor = characteristic.getDescriptor(UUID.fromString(descriptorId));
        if (descriptor == null) {
            throw new Exception("descriptor (" + descriptorId + ") could not be located in the characteristic (" + characteristic.getUuid().toString() + ")");
        }
        return descriptor;
    }

    private void startScan(MethodCall call, MethodChannel.Result result) {
        byte[] data = (byte[])call.arguments();
        try {
            Protos.ScanSettings settings = (Protos.ScanSettings)((Protos.ScanSettings.Builder)Protos.ScanSettings.newBuilder().mergeFrom(data)).build();
            if (Build.VERSION.SDK_INT >= 21) {
                this.startScan21(settings);
            } else {
                this.startScan18(settings);
            }
            result.success(null);
        }
        catch (Exception e) {
            result.error("startScan", e.getMessage(), (Object)e);
        }
    }

    private void stopScan() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.stopScan21();
        } else {
            this.stopScan18();
        }
    }

    @TargetApi(value=21)
    private ScanCallback getScanCallback21() {
        if (this.scanCallback21 == null) {
            this.scanCallback21 = new ScanCallback(){

                public void onScanResult(int callbackType, ScanResult result) {
                    super.onScanResult(callbackType, result);
                    if (FlutterBluePlugin.this.scanResultsSink != null) {
                        Protos.ScanResult scanResult = ProtoMaker.from(result.getDevice(), result);
                        FlutterBluePlugin.this.scanResultsSink.success((Object)scanResult.toByteArray());
                    }
                }

                public void onBatchScanResults(List<ScanResult> results) {
                    super.onBatchScanResults(results);
                }

                public void onScanFailed(int errorCode) {
                    super.onScanFailed(errorCode);
                }
            };
        }
        return this.scanCallback21;
    }

    @TargetApi(value=21)
    private void startScan21(Protos.ScanSettings proto) throws IllegalStateException {
        BluetoothLeScanner scanner = this.mBluetoothAdapter.getBluetoothLeScanner();
        if (scanner == null) {
            throw new IllegalStateException("getBluetoothLeScanner() is null. Is the Adapter on?");
        }
        int scanMode = proto.getAndroidScanMode();
        int count = proto.getServiceUuidsCount();
        ArrayList<ScanFilter> filters = new ArrayList<ScanFilter>(count);
        for (int i = 0; i < count; ++i) {
            String uuid = proto.getServiceUuids(i);
            ScanFilter f = new ScanFilter.Builder().setServiceUuid(ParcelUuid.fromString((String)uuid)).build();
            filters.add(f);
        }
        ScanSettings settings = new ScanSettings.Builder().setScanMode(scanMode).build();
        scanner.startScan(filters, settings, this.getScanCallback21());
    }

    @TargetApi(value=21)
    private void stopScan21() {
        BluetoothLeScanner scanner = this.mBluetoothAdapter.getBluetoothLeScanner();
        if (scanner != null) {
            scanner.stopScan(this.getScanCallback21());
        }
    }

    private BluetoothAdapter.LeScanCallback getScanCallback18() {
        if (this.scanCallback18 == null) {
            this.scanCallback18 = new BluetoothAdapter.LeScanCallback(){

                public void onLeScan(BluetoothDevice bluetoothDevice, int rssi, byte[] scanRecord) {
                    if (FlutterBluePlugin.this.scanResultsSink != null) {
                        Protos.ScanResult scanResult = ProtoMaker.from(bluetoothDevice, scanRecord, rssi);
                        FlutterBluePlugin.this.scanResultsSink.success((Object)scanResult.toByteArray());
                    }
                }
            };
        }
        return this.scanCallback18;
    }

    private void startScan18(Protos.ScanSettings proto) throws IllegalStateException {
        List<String> serviceUuids = proto.getServiceUuidsList();
        UUID[] uuids = new UUID[serviceUuids.size()];
        for (int i = 0; i < serviceUuids.size(); ++i) {
            uuids[i] = UUID.fromString(serviceUuids.get(i));
        }
        boolean success = this.mBluetoothAdapter.startLeScan(uuids, this.getScanCallback18());
        if (!success) {
            throw new IllegalStateException("getBluetoothLeScanner() is null. Is the Adapter on?");
        }
    }

    private void stopScan18() {
        this.mBluetoothAdapter.stopLeScan(this.getScanCallback18());
    }

    private void log(LogLevel level, String message) {
        if (level.ordinal() <= this.logLevel.ordinal()) {
            Log.d((String)TAG, (String)message);
        }
    }

    static enum LogLevel {
        EMERGENCY,
        ALERT,
        CRITICAL,
        ERROR,
        WARNING,
        NOTICE,
        INFO,
        DEBUG;

    }
}

