/*
 * Decompiled with CFR 0.152.
 */
package com.pauldemarco.flutterblue;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.os.Build;
import android.os.ParcelUuid;
import android.util.SparseArray;
import com.google.protobuf.ByteString;
import com.pauldemarco.flutterblue.AdvertisementParser;
import com.pauldemarco.flutterblue.Protos;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ProtoMaker {
    private static final UUID CCCD_UUID = UUID.fromString("000002902-0000-1000-8000-00805f9b34fb");

    static Protos.ScanResult from(BluetoothDevice device, byte[] advertisementData, int rssi) {
        Protos.ScanResult.Builder p = Protos.ScanResult.newBuilder();
        p.setDevice(ProtoMaker.from(device));
        if (advertisementData != null && advertisementData.length > 0) {
            p.setAdvertisementData(AdvertisementParser.parse(advertisementData));
        }
        p.setRssi(rssi);
        return (Protos.ScanResult)p.build();
    }

    @TargetApi(value=21)
    static Protos.ScanResult from(BluetoothDevice device, ScanResult scanResult) {
        Protos.ScanResult.Builder p = Protos.ScanResult.newBuilder();
        p.setDevice(ProtoMaker.from(device));
        Protos.AdvertisementData.Builder a = Protos.AdvertisementData.newBuilder();
        ScanRecord scanRecord = scanResult.getScanRecord();
        if (Build.VERSION.SDK_INT >= 26) {
            a.setConnectable(scanResult.isConnectable());
        } else if (scanRecord != null) {
            int flags = scanRecord.getAdvertiseFlags();
            a.setConnectable((flags & 2) > 0);
        }
        if (scanRecord != null) {
            int txPower;
            String deviceName = scanRecord.getDeviceName();
            if (deviceName != null) {
                a.setLocalName(deviceName);
            }
            if ((txPower = scanRecord.getTxPowerLevel()) != Integer.MIN_VALUE) {
                a.setTxPowerLevel(Protos.Int32Value.newBuilder().setValue(txPower));
            }
            SparseArray msd = scanRecord.getManufacturerSpecificData();
            for (int i = 0; i < msd.size(); ++i) {
                int key = msd.keyAt(i);
                byte[] value = (byte[])msd.valueAt(i);
                a.putManufacturerData(key, ByteString.copyFrom((byte[])value));
            }
            Map serviceData = scanRecord.getServiceData();
            for (Map.Entry entry : serviceData.entrySet()) {
                ParcelUuid key = (ParcelUuid)entry.getKey();
                byte[] value = (byte[])entry.getValue();
                a.putServiceData(key.getUuid().toString(), ByteString.copyFrom((byte[])value));
            }
            List serviceUuids = scanRecord.getServiceUuids();
            if (serviceUuids != null) {
                for (ParcelUuid s : serviceUuids) {
                    a.addServiceUuids(s.getUuid().toString());
                }
            }
        }
        p.setRssi(scanResult.getRssi());
        p.setAdvertisementData((Protos.AdvertisementData)a.build());
        return (Protos.ScanResult)p.build();
    }

    static Protos.BluetoothDevice from(BluetoothDevice device) {
        Protos.BluetoothDevice.Builder p = Protos.BluetoothDevice.newBuilder();
        p.setRemoteId(device.getAddress());
        String name = device.getName();
        if (name != null) {
            p.setName(name);
        }
        switch (device.getType()) {
            case 2: {
                p.setType(Protos.BluetoothDevice.Type.LE);
                break;
            }
            case 1: {
                p.setType(Protos.BluetoothDevice.Type.CLASSIC);
                break;
            }
            case 3: {
                p.setType(Protos.BluetoothDevice.Type.DUAL);
                break;
            }
            default: {
                p.setType(Protos.BluetoothDevice.Type.UNKNOWN);
            }
        }
        return (Protos.BluetoothDevice)p.build();
    }

    static Protos.BluetoothService from(BluetoothDevice device, BluetoothGattService service, BluetoothGatt gatt) {
        Protos.BluetoothService.Builder p = Protos.BluetoothService.newBuilder();
        p.setRemoteId(device.getAddress());
        p.setUuid(service.getUuid().toString());
        p.setIsPrimary(service.getType() == 0);
        for (BluetoothGattCharacteristic c : service.getCharacteristics()) {
            p.addCharacteristics(ProtoMaker.from(c, gatt));
        }
        for (BluetoothGattService s : service.getIncludedServices()) {
            p.addIncludedServices(ProtoMaker.from(device, s, gatt));
        }
        return (Protos.BluetoothService)p.build();
    }

    static Protos.BluetoothCharacteristic from(BluetoothGattCharacteristic characteristic, BluetoothGatt gatt) {
        Protos.BluetoothCharacteristic.Builder p = Protos.BluetoothCharacteristic.newBuilder();
        p.setUuid(characteristic.getUuid().toString());
        p.setProperties(ProtoMaker.from(characteristic.getProperties()));
        if (characteristic.getValue() != null) {
            p.setValue(ByteString.copyFrom((byte[])characteristic.getValue()));
        }
        for (BluetoothGattDescriptor d : characteristic.getDescriptors()) {
            p.addDescriptors(ProtoMaker.from(d));
        }
        if (characteristic.getService().getType() == 0) {
            p.setServiceUuid(characteristic.getService().getUuid().toString());
        } else {
            block1: for (BluetoothGattService s : gatt.getServices()) {
                for (BluetoothGattService ss : s.getIncludedServices()) {
                    if (!ss.getUuid().equals(characteristic.getService().getUuid())) continue;
                    p.setServiceUuid(s.getUuid().toString());
                    p.setSecondaryServiceUuid(ss.getUuid().toString());
                    continue block1;
                }
            }
        }
        return (Protos.BluetoothCharacteristic)p.build();
    }

    static Protos.BluetoothDescriptor from(BluetoothGattDescriptor descriptor) {
        Protos.BluetoothDescriptor.Builder p = Protos.BluetoothDescriptor.newBuilder();
        p.setUuid(descriptor.getUuid().toString());
        p.setCharacteristicUuid(descriptor.getCharacteristic().getUuid().toString());
        p.setServiceUuid(descriptor.getCharacteristic().getService().getUuid().toString());
        if (descriptor.getValue() != null) {
            p.setValue(ByteString.copyFrom((byte[])descriptor.getValue()));
        }
        return (Protos.BluetoothDescriptor)p.build();
    }

    static Protos.CharacteristicProperties from(int properties) {
        return (Protos.CharacteristicProperties)Protos.CharacteristicProperties.newBuilder().setBroadcast((properties & 1) != 0).setRead((properties & 2) != 0).setWriteWithoutResponse((properties & 4) != 0).setWrite((properties & 8) != 0).setNotify((properties & 0x10) != 0).setIndicate((properties & 0x20) != 0).setAuthenticatedSignedWrites((properties & 0x40) != 0).setExtendedProperties((properties & 0x80) != 0).setNotifyEncryptionRequired((properties & 0x100) != 0).setIndicateEncryptionRequired((properties & 0x200) != 0).build();
    }

    static Protos.DeviceStateResponse from(BluetoothDevice device, int state) {
        Protos.DeviceStateResponse.Builder p = Protos.DeviceStateResponse.newBuilder();
        switch (state) {
            case 3: {
                p.setState(Protos.DeviceStateResponse.BluetoothDeviceState.DISCONNECTING);
                break;
            }
            case 2: {
                p.setState(Protos.DeviceStateResponse.BluetoothDeviceState.CONNECTED);
                break;
            }
            case 1: {
                p.setState(Protos.DeviceStateResponse.BluetoothDeviceState.CONNECTING);
                break;
            }
            case 0: {
                p.setState(Protos.DeviceStateResponse.BluetoothDeviceState.DISCONNECTED);
                break;
            }
        }
        p.setRemoteId(device.getAddress());
        return (Protos.DeviceStateResponse)p.build();
    }
}

