/*
 * Decompiled with CFR 0.152.
 */
package com.tekartik.sqflite.operation;

import com.tekartik.sqflite.operation.BaseOperation;
import com.tekartik.sqflite.operation.OperationResult;
import io.flutter.plugin.common.MethodChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchOperation
extends BaseOperation {
    final Map<String, Object> map;
    final BatchOperationResult operationResult = new BatchOperationResult();
    final boolean noResult;

    public BatchOperation(Map<String, Object> map, boolean noResult) {
        this.map = map;
        this.noResult = noResult;
    }

    @Override
    public String getMethod() {
        return (String)this.map.get("method");
    }

    @Override
    public <T> T getArgument(String key) {
        return (T)this.map.get(key);
    }

    @Override
    public OperationResult getOperationResult() {
        return this.operationResult;
    }

    public Map<String, Object> getOperationSuccessResult() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("result", this.operationResult.result);
        return results;
    }

    public Map<String, Object> getOperationError() {
        HashMap<String, Object> error = new HashMap<String, Object>();
        HashMap<String, Object> errorDetail = new HashMap<String, Object>();
        errorDetail.put("code", this.operationResult.errorCode);
        errorDetail.put("message", this.operationResult.errorMessage);
        errorDetail.put("data", this.operationResult.errorData);
        error.put("error", errorDetail);
        return error;
    }

    public void handleError(MethodChannel.Result result) {
        result.error(this.operationResult.errorCode, this.operationResult.errorMessage, this.operationResult.errorData);
    }

    @Override
    public boolean getNoResult() {
        return this.noResult;
    }

    public void handleSuccess(List<Map<String, Object>> results) {
        if (!this.getNoResult()) {
            results.add(this.getOperationSuccessResult());
        }
    }

    public void handleErrorContinue(List<Map<String, Object>> results) {
        if (!this.getNoResult()) {
            results.add(this.getOperationError());
        }
    }

    public class BatchOperationResult
    implements OperationResult {
        Object result;
        String errorCode;
        String errorMessage;
        Object errorData;

        @Override
        public void success(Object result) {
            this.result = result;
        }

        @Override
        public void error(String errorCode, String errorMessage, Object data) {
            this.errorCode = errorCode;
            this.errorMessage = errorMessage;
            this.errorData = data;
        }
    }
}

