#todo if time permits:
# implement image count
# display starting path 

import os
import json
import PySimpleGUI as sg
import cv2
import jetcam
from jetcam.csi_camera import CSICamera
from uuid import uuid1

#creates directories for dataset given gesture list and path
def create_directories(path, gestures):

    for i in range(len(gestures)):

        try:
            temp_dir = path + '/' + gestures[i]

            if(not os.path.isdir(temp_dir)):
                os.mkdir(temp_dir)

        except FileExistsError as err:
            print(err)

    return

#saves an image to directory with a random name 
def save_image(directory, image):
    os.chdir(directory)

    filename = str(uuid1()) + '.jpg'

    cv2.imwrite(filename, image)

    return

print("Gesture dataset collection. Each gesture will create a directory in /home/articulight/Desktop/gesture_dataset/[dataset name]. Enter name of this dataset:")
name_of_dataset = input()

path = '/home/articulight/Desktop/gesture_datasets/' + name_of_dataset # change this to save images elsewhere

if(not os.path.isdir(path)):
    os.makedirs(path) # make the root directory

print("Enter number of gestures you wish to train:")
num_of_gestures = input()
num_of_gestures = int(num_of_gestures)

gesture_names = []
print("Enter names of gestures:")

for i in range(num_of_gestures):
    gesture_names.append(input("Enter name of gesture " + str(i + 1) + ": "))

create_directories(path, gesture_names)

current_directory = path + '/' + gesture_names[0] # start on first gesture entered
print('Current directory: ' + current_directory)
sg.theme('DarkAmber') # theme of GUI. UCF-esque.

# layout variable dictates the layout of the gui. A list of lists, each inner list is the elements on a single row.
layout = [[sg.Button('Save Image'), sg.Button('Save 1000 Images'), sg.Button('Save 200 Images'), sg.Button('Next Gesture'), sg.Button('Previous Gesture'), sg.Button('Toggle Train/Test'), sg.Button('Exit')]]
window = sg.Window('Gesture Data Collection', layout) # create window for GUI with title and declared layout

#make camera object
camera = CSICamera(width=224, height=224, capture_fps=30)

#utility variables for main loop
counts = { i : 0 for i in gesture_names }
dir_index = 0
gesture_from_index = {i:j for i,j in zip(list(range(num_of_gestures)), gesture_names)}

training = True
count = 0
toggle_1000 = False
toggle_200 = False
# main loop
while True:

    #capture and display image
    image = camera.read()
    cv2.imshow('Image Collection', image)
    cv2.waitKey(1)

    if(toggle_1000):

        if (count <= 1000):
            image = cv2.rotate(image, cv2.ROTATE_180)
            cv2.waitKey(1)

        
        save_image(current_directory, image)
        count += 1

        
        print('saved %d images' % count)
        if(count == 1000):
            toggle_1000 = False
            count = 0
        continue
    
    if (toggle_200):
        
        if (count <= 200):
            image = cv2.rotate(image, cv2.ROTATE_180)
            cv2.waitKey(1)

        save_image(current_directory, image)
        count += 1

        

        print('saved %d images' % count)
        if(count == 200):
            toggle_200 = False
            count = 0
        continue

    #get GUI info
    event, values = window.read(timeout = 10) # timeout in ms (program freezes waiting for input otherwise)

    if event == 'Save 1000 Images':
        toggle_1000 = True
    
    if event == 'Save 200 Images':
        toggle_200 = True

    if event == 'Save Image':
        save_image(current_directory, image)
    
    if event == 'Next Gesture':
        if dir_index < len(gesture_names) - 1:
            dir_index = dir_index + 1
            
            current_directory = path + '/' + gesture_names[dir_index]
            
            print("Updated current directory to: " + current_directory)
            
            #update GUI with current gesture name
        else:
            print("Already on the last gesture! Directory index: " + str(dir_index))
    
    if event == 'Previous Gesture':
        if dir_index > 0:
            dir_index = dir_index - 1
            
            current_directory = path + '/' + gesture_names[dir_index]
            
            print("Updated current directory to: " + current_directory)
            
            #update gui
        else:
            print("Already on the first gesture! Directory index: " + str(dir_index))

    if event == "Toggle Train/Test":
        training = not training
        if training:
            print('Saving images to the training dataset')
        else:
            print('Saving images to the testing dataset')

    # close program if GUI is closed
    if event == sg.WIN_CLOSED or event == 'Exit':
        break

#rename images in sequential order (rn its sequential in alphabetical sense in the directories)
#would need to rename directories to 1, 2, 3, etc for it to truly be sequential
image_count = 0
for i in range(num_of_gestures):
    dir_check = os.path.join(path, gesture_names[i])
    dir_check += '/'
    
    for count, filename in enumerate(os.listdir(dir_check)):
        dst = "%d.jpg" % image_count
        src = dir_check + filename
        dst = dir_check + dst

        os.rename(src, dst)

        image_count += 1

#generate JSON
labels = []
starting_label = 1

for i in range(num_of_gestures):
    dir_check = os.path.join(path, gesture_names[i])

    for j in range(len(os.listdir(dir_check))):
        labels.append(starting_label)

    starting_label += 1

label_dict = {"labels":labels}

if training:
    filename = path + '.json'
else:
    filename = path + '_testing.json'

with open(filename, 'w') as f:
    json.dump(label_dict, f)

#to move directories to a training directory for SVM
import shutil
if training:
    dir_ = '/home/articulight/Desktop/gesture_datasets/' + name_of_dataset + '/training/'
else:
    dir_ = '/home/articulight/Desktop/gesture_datasets/' + name_of_dataset + '/testing/'

if not os.path.isdir(dir_):
    os.makedirs(dir_)

for i in range(num_of_gestures):
    dir_check = os.path.join(path, gesture_names[i] + '/' )

    for count, filename in enumerate(os.listdir(dir_check)):
        src = dir_check + filename
        shutil.move(src, dir_)

    os.rmdir(dir_check)

shutil.move(dir_, path)
if training:
    shutil.move(path + '.json', path)
else:
    shutil.move(path + '_testing.json', path)
