/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt;

import com.ibm.mqtt.MQeTrace;
import com.ibm.mqtt.Mqtt;
import com.ibm.mqtt.MqttByteArray;
import com.ibm.mqtt.MqttConnack;
import com.ibm.mqtt.MqttConnect;
import com.ibm.mqtt.MqttDisconnect;
import com.ibm.mqtt.MqttException;
import com.ibm.mqtt.MqttHashTable;
import com.ibm.mqtt.MqttNotConnectedException;
import com.ibm.mqtt.MqttPacket;
import com.ibm.mqtt.MqttPersistence;
import com.ibm.mqtt.MqttPersistenceException;
import com.ibm.mqtt.MqttPingreq;
import com.ibm.mqtt.MqttPuback;
import com.ibm.mqtt.MqttPubcomp;
import com.ibm.mqtt.MqttPublish;
import com.ibm.mqtt.MqttPubrec;
import com.ibm.mqtt.MqttPubrel;
import com.ibm.mqtt.MqttReconn;
import com.ibm.mqtt.MqttRetry;
import com.ibm.mqtt.MqttSuback;
import com.ibm.mqtt.MqttSubscribe;
import com.ibm.mqtt.MqttTimedEvent;
import com.ibm.mqtt.MqttTimedEventQueue;
import com.ibm.mqtt.MqttUnsuback;
import com.ibm.mqtt.MqttUnsubscribe;
import com.ibm.mqtt.MqttUtils;
import java.util.Hashtable;
import java.util.Vector;

public abstract class MqttBaseClient
extends Mqtt
implements Runnable {
    private MqttHashTable outstandingQueue = null;
    private int retryPeriod;
    private boolean cleanSession = false;
    private Hashtable qos2PubsArrived = new Hashtable();
    private MqttPersistence persistenceLayer = null;
    private Object readerControl = new Object();
    private MqttTimedEventQueue retryQueue = null;
    protected static final int conNotify = 1;
    protected static final int subNotify = 4;
    protected static final int unsubNotify = 5;
    private Hashtable grantedQoS = new Hashtable();
    private boolean terminated = false;
    private static int maxOutstanding = 10;
    private boolean outLockNotified = false;
    private Object outLock = new Object();

    protected MqttBaseClient() {
    }

    protected void initialise(String string, MqttPersistence mqttPersistence, Class clazz) {
        super.initialise(string, clazz);
        this.retryPeriod = 10000;
        this.outstandingQueue = new MqttHashTable();
        this.retryQueue = new MqttTimedEventQueue(10, this);
        this.retryQueue.start();
        this.persistenceLayer = mqttPersistence;
    }

    protected abstract void notifyAck(int var1, int var2);

    protected abstract void publishArrived(String var1, byte[] var2, int var3, boolean var4) throws Exception;

    public void anyErrors() throws MqttException {
        if (this.registeredException != null) {
            throw this.registeredException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect(String string, boolean bl, boolean bl2, short s, String string2, int n, String string3, boolean bl3) throws MqttException, MqttPersistenceException {
        Object object = this.outLock;
        synchronized (object) {
            this.outLockNotified = false;
        }
        object = new MqttConnect();
        ((MqttConnect)object).setClientId(string);
        ((MqttConnect)object).CleanStart = bl;
        ((MqttConnect)object).TopicNameCompression = bl2;
        ((MqttConnect)object).KeepAlive = s;
        if (string2 != null) {
            ((MqttConnect)object).Will = true;
            ((MqttConnect)object).WillTopic = string2;
            ((MqttConnect)object).WillQoS = n;
            ((MqttConnect)object).WillRetain = bl3;
            ((MqttConnect)object).WillMessage = string3;
        } else {
            ((MqttConnect)object).Will = false;
        }
        this.setKeepAlive(s);
        this.doConnect((MqttConnect)object, bl, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnect(MqttConnect mqttConnect, boolean bl, short s) throws MqttException, MqttPersistenceException {
        Object object;
        Object object2;
        this.retryQueue.resetTimedEventQueue();
        this.outstandingQueue.clear();
        this.qos2PubsArrived.clear();
        this.initialiseOutMsgIds(null);
        if (this.persistenceLayer != null && !this.isConnectionLost()) {
            this.persistenceLayer.open(mqttConnect.getClientId(), this.connection);
        }
        if (bl) {
            this.cleanSession = true;
            if (this.persistenceLayer != null) {
                this.persistenceLayer.reset();
            }
        }
        if (s > 0) {
            object2 = new MqttRetry(this, new MqttPingreq(), s * 1000);
            object = this.outstandingQueue;
            synchronized (object) {
                this.outstandingQueue.put(0L, object2);
            }
            this.retryQueue.enqueue((MqttTimedEvent)object2);
        }
        if (!bl && this.persistenceLayer != null && !this.isConnectionLost()) {
            Object object3;
            Object object4;
            int n;
            int n2;
            int n3;
            Object object5;
            int n4;
            object2 = this.persistenceLayer.getAllSentMessages();
            if (object2 != null) {
                object = new Vector();
                for (n4 = 0; n4 < ((Object)object2).length; ++n4) {
                    try {
                        Object object6;
                        object5 = object2[n4];
                        n3 = 0;
                        n2 = 1;
                        n = 1;
                        do {
                            object4 = object5[n2];
                            n3 += (object4 & 0x7F) * n;
                            n *= 128;
                            ++n2;
                        } while ((object4 & 0x80) != 0);
                        if (n3 + n2 != ((Object)object5).length) {
                            this.invalidSentMessageRestored(n4);
                            continue;
                        }
                        object3 = null;
                        switch (MqttPacket.getMsgType((byte)object5[0])) {
                            case 3: {
                                object6 = new MqttPublish((byte[])object5, n2);
                                ((Vector)object).addElement(new Integer(((MqttPacket)object6).getMsgId()));
                                object3 = new MqttRetry(this, (MqttPacket)object6, this.retryPeriod);
                                break;
                            }
                            case 6: {
                                MqttPubrel mqttPubrel = new MqttPubrel((byte[])object5, n2);
                                ((Vector)object).addElement(new Integer(mqttPubrel.getMsgId()));
                                object3 = new MqttRetry(this, mqttPubrel, this.retryPeriod);
                                break;
                            }
                            default: {
                                this.invalidSentMessageRestored(n4);
                            }
                        }
                        if (object3 == null) continue;
                        object6 = this.outstandingQueue;
                        synchronized (object6) {
                            this.outstandingQueue.put(((MqttRetry)object3).getMsgId(), object3);
                        }
                        this.retryQueue.enqueue((MqttTimedEvent)object3);
                        continue;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        this.invalidSentMessageRestored(n4);
                    }
                }
                this.initialiseOutMsgIds((Vector)object);
            }
            if ((object = (Object)this.persistenceLayer.getAllReceivedMessages()) != null) {
                for (n4 = 0; n4 < ((Object)object).length; ++n4) {
                    try {
                        object5 = object[n4];
                        n3 = 0;
                        n2 = 1;
                        n = 1;
                        do {
                            object4 = object5[n2];
                            n3 += (object4 & 0x7F) * n;
                            n *= 128;
                            ++n2;
                        } while ((object4 & 0x80) != 0);
                        if (n3 + n2 != ((Object)object5).length) {
                            this.invalidReceivedMessageRestored(n4);
                            continue;
                        }
                        if (MqttPacket.getMsgType((byte)object5[0]) == 3) {
                            object3 = new MqttPublish((byte[])object5, n2);
                            this.qos2PubsArrived.put(Integer.toString(((MqttPacket)object3).getMsgId()), object3);
                            continue;
                        }
                        this.invalidReceivedMessageRestored(n4);
                        continue;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        this.invalidReceivedMessageRestored(n4);
                    }
                }
            }
        }
        this.registeredException = null;
        this.setConnectionLost(false);
        try {
            object2 = this.readerControl;
            synchronized (object2) {
                this.tcpipConnect(mqttConnect);
                this.readerControl.notify();
            }
        }
        catch (MqttException mqttException) {
            throw mqttException;
        }
        catch (Exception exception) {
            object = new MqttException();
            ((MqttException)object).initCause(exception);
            throw object;
        }
    }

    private void invalidSentMessageRestored(int n) {
        MQeTrace.trace(this, (short)-30036, 1L, new Integer(n));
    }

    private void invalidReceivedMessageRestored(int n) {
        MQeTrace.trace(this, (short)-30037, 1L, new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionLost() throws Exception {
        Object object = this.outLock;
        synchronized (object) {
            this.outLockNotified = true;
            this.outLock.notifyAll();
        }
    }

    protected synchronized void setConnectionState(boolean bl) {
        super.setConnectionState(bl);
        this.retryQueue.canDeliverEvents(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminate() {
        Object object = this.readerControl;
        synchronized (object) {
            this.terminated = true;
            this.readerControl.notify();
        }
        if (this.retryQueue != null) {
            this.retryQueue.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void disconnect() throws MqttPersistenceException {
        block40: {
            try {
                this.setConnectionState(false);
                MqttDisconnect mqttDisconnect = new MqttDisconnect();
                this.writePacket(mqttDisconnect);
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.tcpipDisconnect(false);
                Object object = this.readerControl;
                synchronized (object) {
                    if (this.isSocketConnected()) {
                        try {
                            this.readerControl.wait(30000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                object = this.outLock;
                synchronized (object) {
                    this.outLockNotified = true;
                    this.outLock.notifyAll();
                }
                this.qos2PubsArrived.clear();
                this.retryQueue.resetTimedEventQueue();
                this.outstandingQueue.clear();
                if (this.cleanSession) {
                    this.cleanSession = false;
                    if (this.persistenceLayer != null) {
                        this.persistenceLayer.reset();
                    }
                }
                if (this.persistenceLayer != null) {
                    this.persistenceLayer.close();
                }
                throw throwable;
            }
            this.tcpipDisconnect(false);
            Object object = this.readerControl;
            synchronized (object) {
                if (this.isSocketConnected()) {
                    try {
                        this.readerControl.wait(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            object = this.outLock;
            synchronized (object) {
                this.outLockNotified = true;
                this.outLock.notifyAll();
            }
            this.qos2PubsArrived.clear();
            this.retryQueue.resetTimedEventQueue();
            this.outstandingQueue.clear();
            if (this.cleanSession) {
                this.cleanSession = false;
                if (this.persistenceLayer != null) {
                    this.persistenceLayer.reset();
                }
            }
            if (this.persistenceLayer != null) {
                this.persistenceLayer.close();
            }
            break block40;
            {
                catch (MqttException mqttException) {
                    Object var3_4 = null;
                    this.tcpipDisconnect(false);
                    Object object2 = this.readerControl;
                    synchronized (object2) {
                        if (this.isSocketConnected()) {
                            try {
                                this.readerControl.wait(30000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    object2 = this.outLock;
                    synchronized (object2) {
                        this.outLockNotified = true;
                        this.outLock.notifyAll();
                    }
                    this.qos2PubsArrived.clear();
                    this.retryQueue.resetTimedEventQueue();
                    this.outstandingQueue.clear();
                    if (this.cleanSession) {
                        this.cleanSession = false;
                        if (this.persistenceLayer != null) {
                            this.persistenceLayer.reset();
                        }
                    }
                    if (this.persistenceLayer != null) {
                        this.persistenceLayer.close();
                    }
                }
            }
        }
    }

    public int getRetry() {
        return this.retryPeriod / 1000;
    }

    protected byte[] getReturnedQoS(int n) {
        MqttByteArray mqttByteArray = (MqttByteArray)this.grantedQoS.remove(new Integer(n));
        return mqttByteArray == null ? null : mqttByteArray.getByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MqttPacket messageAck(int n) {
        block18: {
            MqttRetry mqttRetry = null;
            mqttRetry = (MqttRetry)this.outstandingQueue.get(n);
            if (mqttRetry == null) {
                return null;
            }
            if (mqttRetry.getQoS() == 2 && mqttRetry.getMsgType() == 3) {
                return this.messageAckQoS2(n);
            }
            try {
                Object object;
                if (this.persistenceLayer != null) {
                    object = this.persistenceLayer;
                    synchronized (object) {
                        this.persistenceLayer.delSentMessage(n);
                    }
                }
                object = this.outstandingQueue;
                synchronized (object) {
                    mqttRetry = (MqttRetry)this.outstandingQueue.remove(n);
                }
                this.releaseMsgId(n);
                if (mqttRetry == null) break block18;
                int n2 = mqttRetry.getMsgType();
                switch (n2) {
                    case 3: 
                    case 6: 
                    case 8: 
                    case 10: {
                        if (this.outstandingQueue.size() == maxOutstanding - 1) {
                            Object object2 = this.outLock;
                            synchronized (object2) {
                                this.outLockNotified = true;
                                this.outLock.notifyAll();
                            }
                        }
                        this.notifyAck(n2, n);
                    }
                }
            }
            catch (MqttPersistenceException mqttPersistenceException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MqttPacket messageAckQoS2(int n) {
        MqttRetry mqttRetry = null;
        MqttPubrel mqttPubrel = null;
        mqttPubrel = this.genPubRelPacket(n, false);
        try {
            Object object;
            if (this.persistenceLayer != null) {
                object = this.persistenceLayer;
                synchronized (object) {
                    this.persistenceLayer.updSentMessage(n, ((MqttPacket)mqttPubrel).toBytes());
                }
            }
            object = this.outstandingQueue;
            synchronized (object) {
                mqttRetry = (MqttRetry)this.outstandingQueue.remove(n);
                if (mqttRetry != null) {
                    mqttRetry.setMessage(mqttPubrel);
                    this.outstandingQueue.put(n, mqttRetry);
                }
            }
        }
        catch (MqttPersistenceException mqttPersistenceException) {
            // empty catch block
        }
        return mqttPubrel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean outstanding(int n) {
        boolean bl = false;
        MqttHashTable mqttHashTable = this.outstandingQueue;
        synchronized (mqttHashTable) {
            bl = this.outstandingQueue.containsKey(n);
        }
        return bl;
    }

    public void process(MqttConnack mqttConnack) {
        MQeTrace.trace(this, (short)-30017, 0x200000L, new Integer(mqttConnack.returnCode));
        super.process(mqttConnack);
        this.notifyAck(1, mqttConnack.returnCode);
    }

    public void process(MqttPuback mqttPuback) {
        MQeTrace.trace(this, (short)-30018, 0x200000L, new Integer(mqttPuback.getMsgId()));
        this.messageAck(mqttPuback.getMsgId());
    }

    public void process(MqttPubcomp mqttPubcomp) {
        MQeTrace.trace(this, (short)-30019, 0x200000L, new Integer(mqttPubcomp.getMsgId()));
        this.messageAck(mqttPubcomp.getMsgId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MqttPublish mqttPublish) {
        boolean bl = false;
        int n = 0;
        if (mqttPublish.getPayload() != null) {
            n = mqttPublish.getPayload().length;
        }
        MQeTrace.trace(this, (short)-30020, 0x200000L, Integer.toString(mqttPublish.getMsgId()), Integer.toString(mqttPublish.getQos()), new Boolean(mqttPublish.isRetain()).toString(), Integer.toString(n));
        if (mqttPublish.getQos() != 2) {
            try {
                this.publishArrived(mqttPublish.topicName, mqttPublish.getPayload(), mqttPublish.getQos(), mqttPublish.isRetain());
            }
            catch (Exception exception) {
                bl = true;
                System.out.println("publishArrived Exception caught (QoS " + mqttPublish.getQos() + "):");
                exception.printStackTrace();
            }
        }
        if (mqttPublish.getQos() > 0 && !bl) {
            MQeTrace.trace(this, (short)-30021, 0x200000L, mqttPublish.getQos() == 1 ? "PUBACK" : "PUBREC", new Integer(mqttPublish.getMsgId()));
            if (mqttPublish.getQos() == 1) {
                MqttPuback mqttPuback = new MqttPuback();
                mqttPuback.setMsgId(mqttPublish.getMsgId());
                try {
                    this.writePacket(mqttPuback);
                }
                catch (Exception exception) {}
            } else {
                try {
                    Object object;
                    if (this.persistenceLayer != null) {
                        try {
                            object = this.persistenceLayer;
                            synchronized (object) {
                                byte[] byArray = mqttPublish.toBytes();
                                if (mqttPublish.getPayload() != null) {
                                    byArray = MqttUtils.concatArray(byArray, mqttPublish.getPayload());
                                }
                                this.persistenceLayer.addReceivedMessage(mqttPublish.getMsgId(), byArray);
                            }
                        }
                        catch (MqttPersistenceException mqttPersistenceException) {
                            throw mqttPersistenceException;
                        }
                        catch (Exception exception) {
                            throw new MqttPersistenceException("process(MqttPublish) - packet.toBytes() failed - msgid " + mqttPublish.getMsgId());
                        }
                    }
                    this.qos2PubsArrived.put(Integer.toString(mqttPublish.getMsgId()), mqttPublish);
                    object = new MqttPubrec();
                    ((MqttPacket)object).setMsgId(mqttPublish.getMsgId());
                    try {
                        this.writePacket((MqttPacket)object);
                    }
                    catch (Exception exception) {}
                }
                catch (MqttPersistenceException mqttPersistenceException) {
                    // empty catch block
                }
            }
        }
    }

    public void process(MqttPubrec mqttPubrec) {
        MqttPacket mqttPacket;
        MQeTrace.trace(this, (short)-30022, 0x200000L, new Integer(mqttPubrec.getMsgId()));
        MqttRetry mqttRetry = (MqttRetry)this.outstandingQueue.get(mqttPubrec.getMsgId());
        if ((mqttRetry == null || mqttRetry.getMsgType() != 6) && (mqttPacket = this.messageAck(mqttPubrec.getMsgId())) != null) {
            try {
                this.writePacket(mqttPacket);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MqttPubrel mqttPubrel) {
        boolean bl = false;
        MQeTrace.trace(this, (short)-30023, 0x200000L, new Integer(mqttPubrel.getMsgId()));
        MqttPublish mqttPublish = (MqttPublish)this.qos2PubsArrived.get(Integer.toString(mqttPubrel.getMsgId()));
        if (mqttPublish != null) {
            try {
                this.publishArrived(mqttPublish.topicName, mqttPublish.getPayload(), mqttPublish.getQos(), mqttPublish.isRetain());
            }
            catch (Exception exception) {
                bl = true;
                System.out.println("publishArrived Exception caught (QoS 2):");
                exception.printStackTrace();
            }
        }
        if (!bl) {
            Object object;
            MqttPersistenceException mqttPersistenceException;
            block12: {
                this.qos2PubsArrived.remove(Integer.toString(mqttPubrel.getMsgId()));
                mqttPersistenceException = null;
                try {
                    if (this.persistenceLayer == null) break block12;
                    object = this.persistenceLayer;
                    synchronized (object) {
                        this.persistenceLayer.delReceivedMessage(mqttPubrel.getMsgId());
                    }
                }
                catch (MqttPersistenceException mqttPersistenceException2) {
                    mqttPersistenceException = mqttPersistenceException2;
                }
            }
            object = new MqttPubcomp();
            ((MqttPacket)object).setMsgId(mqttPubrel.getMsgId());
            try {
                this.writePacket((MqttPacket)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (mqttPersistenceException != null) {
                this.setRegisteredThrowable(mqttPersistenceException);
            }
        }
    }

    public void process(MqttSuback mqttSuback) {
        MQeTrace.trace(this, (short)-30024, 0x200000L, new Integer(mqttSuback.getMsgId()));
        this.grantedQoS.put(new Integer(mqttSuback.getMsgId()), new MqttByteArray(mqttSuback.TopicsQoS));
        this.messageAck(mqttSuback.getMsgId());
    }

    public void process(MqttUnsuback mqttUnsuback) {
        MQeTrace.trace(this, (short)-30025, 0x200000L, new Integer(mqttUnsuback.getMsgId()));
        this.messageAck(mqttUnsuback.getMsgId());
    }

    protected int publish(String string, byte[] byArray, int n, boolean bl) throws MqttException, MqttPersistenceException {
        int n2 = 0;
        if (n > 0) {
            n2 = this.nextMsgId();
        }
        MqttPublish mqttPublish = this.genPublishPacket(n2, n, string, byArray, bl, false);
        this.sendPacket(mqttPublish);
        MQeTrace.trace(this, (short)-30026, 0x200000L, new Integer(n2), new Integer(n), new Boolean(bl));
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        MQeTrace.trace(this, (short)-30027, 0x200000L);
        Object object = this.readerControl;
        synchronized (object) {
            while (!this.isSocketConnected() && !this.terminated) {
                try {
                    this.readerControl.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!this.terminated) {
            long l = this.retryPeriod;
            while (!this.terminated) {
                block25: {
                    Object object2;
                    try {
                        this.process();
                    }
                    catch (Exception exception) {
                        object2 = this.readerControl;
                        synchronized (object2) {
                            this.tcpipDisconnect(true);
                            this.readerControl.notify();
                        }
                        if (!this.isConnected()) break block25;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.setRegisteredThrowable(null);
                        System.out.println("WMQtt client:Lost connection...");
                        new MqttReconn(this).start();
                    }
                    catch (Throwable throwable) {
                        object2 = this.readerControl;
                        synchronized (object2) {
                            this.tcpipDisconnect(true);
                            this.readerControl.notify();
                        }
                        this.setRegisteredThrowable(throwable);
                    }
                }
                Object object3 = this.readerControl;
                synchronized (object3) {
                    while (!this.isSocketConnected() && !this.terminated) {
                        try {
                            this.readerControl.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        MQeTrace.trace(this, (short)-30028, 0x200000L);
    }

    public void setRetry(int n) {
        if (n < 10) {
            n = 10;
        }
        this.retryPeriod = Math.abs(n * 1000);
    }

    protected int subscribe(String[] stringArray, int[] nArray) throws MqttException {
        int n = this.nextMsgId();
        byte[] byArray = new byte[nArray.length];
        this.grantedQoS.remove(new Integer(n));
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)nArray[i];
        }
        MqttSubscribe mqttSubscribe = new MqttSubscribe();
        mqttSubscribe.setMsgId(n);
        mqttSubscribe.setQos(1);
        mqttSubscribe.topics = stringArray;
        mqttSubscribe.topicsQoS = byArray;
        mqttSubscribe.setDup(false);
        MQeTrace.trace(this, (short)-30029, 0x200000L, new Integer(n));
        this.sendPacket(mqttSubscribe);
        return n;
    }

    protected MqttPubrel genPubRelPacket(int n, boolean bl) {
        MqttPubrel mqttPubrel = new MqttPubrel();
        mqttPubrel.setMsgId(n);
        mqttPubrel.setDup(bl);
        return mqttPubrel;
    }

    protected int unsubscribe(String[] stringArray) throws MqttException {
        int n = this.nextMsgId();
        MqttUnsubscribe mqttUnsubscribe = new MqttUnsubscribe();
        mqttUnsubscribe.setMsgId(n);
        mqttUnsubscribe.setQos(1);
        mqttUnsubscribe.topics = stringArray;
        mqttUnsubscribe.setDup(false);
        MQeTrace.trace(this, (short)-30030, 0x200000L, new Integer(n));
        this.sendPacket(mqttUnsubscribe);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPacket(MqttPacket mqttPacket) throws MqttException, MqttNotConnectedException {
        long l = this.getRetry() * 1000;
        if (!this.isSocketConnected()) {
            throw new MqttNotConnectedException();
        }
        if (mqttPacket.getQos() > 0) {
            boolean bl;
            Object object;
            Object object2;
            int n = this.outstandingQueue.size();
            if (n >= maxOutstanding) {
                object2 = this.outLock;
                synchronized (object2) {
                    try {
                        if (!this.outLockNotified) {
                            this.outLock.wait();
                        }
                        if (this.isSocketConnected()) {
                            this.outLockNotified = false;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.isSocketConnected()) {
                    throw new MqttNotConnectedException();
                }
            }
            if (this.persistenceLayer != null) {
                try {
                    object2 = this.persistenceLayer;
                    synchronized (object2) {
                        object = mqttPacket.toBytes();
                        if (mqttPacket.getPayload() != null) {
                            object = MqttUtils.concatArray(object, mqttPacket.getPayload());
                        }
                        this.persistenceLayer.addSentMessage(mqttPacket.getMsgId(), (byte[])object);
                    }
                }
                catch (MqttPersistenceException mqttPersistenceException) {
                    throw mqttPersistenceException;
                }
                catch (Exception exception) {
                    throw new MqttPersistenceException("sendPacket - toBytes failed, msgid " + mqttPacket.getMsgId());
                }
            }
            boolean bl2 = this.getKeepAlivePeriod() > 0 ? this.outstandingQueue.size() > 1 : (bl = this.outstandingQueue.size() > 0);
            if (bl) {
                l = 0L;
            }
            object = new MqttRetry(this, mqttPacket, l);
            MqttHashTable mqttHashTable = this.outstandingQueue;
            synchronized (mqttHashTable) {
                this.outstandingQueue.put(mqttPacket.getMsgId(), object);
            }
            this.retryQueue.enqueue((MqttTimedEvent)object);
            if (l > 0L) {
                try {
                    this.writePacket(mqttPacket);
                }
                catch (MqttException mqttException) {}
            }
        } else {
            this.writePacket(mqttPacket);
        }
    }

    public static void setWindowSize(int n) {
        maxOutstanding = n;
    }
}

