/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt;

import com.ibm.mqtt.IMqttClient;
import com.ibm.mqtt.MQeTrace;
import com.ibm.mqtt.MQeTraceHandler;
import com.ibm.mqtt.MqttAdvancedCallback;
import com.ibm.mqtt.MqttBaseClient;
import com.ibm.mqtt.MqttBrokerUnavailableException;
import com.ibm.mqtt.MqttConnect;
import com.ibm.mqtt.MqttException;
import com.ibm.mqtt.MqttNotConnectedException;
import com.ibm.mqtt.MqttPersistence;
import com.ibm.mqtt.MqttPersistenceException;
import com.ibm.mqtt.MqttSimpleCallback;
import com.ibm.mqtt.MqttUtils;

public class MqttClient
extends MqttBaseClient
implements IMqttClient {
    private Class traceClass = null;
    private String connection;
    private MqttPersistence persistenceLayer = null;
    private Thread reader = null;
    private Object connAckLock = new Object();
    private int conRetCode;
    private boolean isAppConnected = false;
    private MqttAdvancedCallback advCallbackHandler = null;
    private MqttSimpleCallback simpleCallbackHandler = null;

    public static final IMqttClient createMqttClient(String string, MqttPersistence mqttPersistence) throws MqttException {
        return new MqttClient(string, mqttPersistence);
    }

    protected MqttClient() {
    }

    public MqttClient(String string) throws MqttException {
        this(string, null);
    }

    public MqttClient(String string, MqttPersistence mqttPersistence) throws MqttException {
        this.initialise(string, mqttPersistence);
    }

    protected void initialise(String string, MqttPersistence mqttPersistence) throws MqttException {
        Class clazz = null;
        this.connection = string;
        this.persistenceLayer = mqttPersistence;
        if (string.startsWith("local://")) {
            clazz = this.loadLocalBindings();
        } else if (string.startsWith("tcp://")) {
            clazz = this.loadTcpBindings();
            this.connection = string.replace('@', ':');
        } else {
            throw new MqttException("Unrecognised connection method:" + string);
        }
        super.initialise(this.connection, this.persistenceLayer, clazz);
        try {
            this.traceClass = Class.forName("com.ibm.mqtt.trace.MQeTraceToBinaryFile");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.traceClass = null;
        }
        this.start(clazz);
    }

    private Class loadTcpBindings() throws MqttException {
        boolean bl = false;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.ibm.mqtt.j2se.MqttJavaNetSocket");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!bl) {
            try {
                clazz = Class.forName("com.ibm.mqtt.midp.MqttMidpSocket");
            }
            catch (ClassNotFoundException classNotFoundException) {
                MqttException mqttException = new MqttException("Cannot locate a J2SE Socket or J2ME StreamConnection class");
                mqttException.initCause(classNotFoundException);
                throw mqttException;
            }
        }
        return clazz;
    }

    private Class loadLocalBindings() throws MqttException {
        boolean bl = false;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.ibm.mqtt.local.MqttLocalBindingV2");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!bl) {
            try {
                clazz = Class.forName("com.ibm.mqtt.local.MqttLocalBindingV1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                MqttException mqttException = new MqttException("LocalBinding unavailable: Microbroker classes not found");
                mqttException.initCause(classNotFoundException);
                throw mqttException;
            }
        }
        return clazz;
    }

    private void start(Class clazz) throws MqttException {
        try {
            this.reader = new Thread(this);
            this.reader.start();
            super.setRetry(120);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MqttException(exception);
        }
    }

    public void startTrace() throws MqttException {
        if (this.traceClass != null) {
            MQeTrace.setFilter(-1L);
            try {
                MQeTrace.setHandler((MQeTraceHandler)this.traceClass.newInstance());
            }
            catch (Exception exception) {
                throw new MqttException(exception);
            }
        } else {
            throw new MqttException("Trace classes (com.ibm.mqtt.trace.*) not found.\nCheck they are in wmqtt.jar.");
        }
    }

    public void stopTrace() {
        MQeTrace.setFilter(0L);
        MQeTrace.setHandler(null);
    }

    public MqttPersistence getPersistence() {
        return this.persistenceLayer;
    }

    public void registerAdvancedHandler(MqttAdvancedCallback mqttAdvancedCallback) {
        this.advCallbackHandler = mqttAdvancedCallback;
        this.simpleCallbackHandler = mqttAdvancedCallback;
    }

    public void registerSimpleHandler(MqttSimpleCallback mqttSimpleCallback) {
        this.simpleCallbackHandler = mqttSimpleCallback;
    }

    public void connect(String string, boolean bl, short s) throws MqttException, MqttPersistenceException, MqttBrokerUnavailableException, MqttNotConnectedException {
        this.connect(string, bl, s, null, 0, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String string, boolean bl, short s, String string2, int n, String string3, boolean bl2) throws MqttException, MqttPersistenceException, MqttBrokerUnavailableException, MqttNotConnectedException {
        MQeTrace.trace(this, (short)-30002, 0x100004L);
        if (!this.isAppConnected || !this.isSocketConnected()) {
            int n2 = 0;
            Object object = this.connAckLock;
            synchronized (object) {
                this.conRetCode = -1;
                super.connect(string, bl, false, s, string2, n, string3, bl2);
                try {
                    this.connAckLock.wait(this.getRetry() * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                n2 = this.conRetCode;
            }
            MQeTrace.trace(this, (short)-30003, 0x100008L);
            switch (n2) {
                case 0: {
                    this.isAppConnected = true;
                    break;
                }
                case 1: {
                    object = new MqttConnect();
                    throw new MqttException("WMQTT protocol name or version not supported:" + ((MqttConnect)object).ProtoName + " Version:" + ((MqttConnect)object).ProtoVersion);
                }
                case 2: {
                    throw new MqttException("WMQTT ClientId is invalid");
                }
                case 3: {
                    throw new MqttBrokerUnavailableException("WMQTT Broker is unavailable");
                }
                default: {
                    this.tcpipDisconnect(true);
                    throw new MqttNotConnectedException("WMQTT " + msgTypes[2] + " not received");
                }
            }
        }
    }

    protected void connectionLost() throws Exception {
        MQeTrace.trace(this, (short)-30004, 0x200000L);
        super.connectionLost();
        if (this.simpleCallbackHandler == null) {
            throw new MqttNotConnectedException("WMQtt Connection Lost");
        }
        this.simpleCallbackHandler.connectionLost();
    }

    public void disconnect() throws MqttPersistenceException {
        MQeTrace.trace(this, (short)-30005, 0x100004L);
        if (this.isAppConnected) {
            super.disconnect();
            this.isAppConnected = false;
        }
        MQeTrace.trace(this, (short)-30006, 0x100008L);
    }

    public String getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyAck(int n, int n2) {
        switch (n) {
            case 1: {
                Object object = this.connAckLock;
                synchronized (object) {
                    this.conRetCode = n2;
                    this.connAckLock.notifyAll();
                    break;
                }
            }
            case 8: {
                if (this.advCallbackHandler == null) break;
                this.advCallbackHandler.subscribed(n2, this.getReturnedQoS(n2));
                break;
            }
            case 10: {
                if (this.advCallbackHandler == null) break;
                this.advCallbackHandler.unsubscribed(n2);
                break;
            }
            case 3: 
            case 6: {
                if (this.advCallbackHandler == null) break;
                this.advCallbackHandler.published(n2);
                break;
            }
        }
    }

    public void ping() throws MqttException {
        if (Thread.currentThread().equals(this.reader)) {
            this.invalidApiInvocation();
        }
        this.pingOut();
    }

    public int publish(String string, byte[] byArray, int n, boolean bl) throws MqttNotConnectedException, MqttPersistenceException, MqttException, IllegalArgumentException {
        MQeTrace.trace(this, (short)-30007, 0x100004L);
        if (string == null) {
            throw new IllegalArgumentException("NULL topic");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("NULL message");
        }
        if (string.indexOf(35) > -1 || string.indexOf(43) > -1) {
            throw new IllegalArgumentException("Topic contains '#' or '+'");
        }
        if (Thread.currentThread().equals(this.reader)) {
            this.invalidApiInvocation();
        }
        this.anyErrors();
        int n2 = super.publish(string, byArray, n, bl);
        MQeTrace.trace(this, (short)-30008, 0x100008L);
        return n2;
    }

    protected void publishArrived(String string, byte[] byArray, int n, boolean bl) throws Exception {
        String string2 = MqttUtils.toHexString(byArray, 0, 30);
        String string3 = string;
        if (string.length() > 30) {
            string3 = string.substring(0, 31);
        }
        MQeTrace.trace(this, (short)-30009, 0x100004L, Integer.toString(string.length()), string3, Integer.toString(byArray.length), string2);
        if (this.simpleCallbackHandler != null) {
            this.simpleCallbackHandler.publishArrived(string, byArray, n, bl);
        }
        MQeTrace.trace(this, (short)-30010, 0x100008L);
    }

    public void terminate() {
        this.terminate(true);
    }

    public void terminate(boolean bl) {
        if (this.isAppConnected && bl) {
            try {
                this.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.terminate();
        try {
            this.reader.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int subscribe(String[] stringArray, int[] nArray) throws MqttNotConnectedException, MqttException, IllegalArgumentException {
        int n;
        MQeTrace.trace(this, (short)-30011, 0x100004L);
        if (stringArray == null) {
            throw new IllegalArgumentException("NULL topic array");
        }
        if (nArray == null) {
            throw new IllegalArgumentException("NULL requested QoS array");
        }
        if (stringArray.length != nArray.length) {
            throw new IllegalArgumentException("Array lengths unequal. Topics:" + stringArray.length + ", QoS:" + nArray.length);
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] != null) continue;
            throw new IllegalArgumentException("NULL topic in topic array at index " + n);
        }
        if (Thread.currentThread().equals(this.reader)) {
            this.invalidApiInvocation();
        }
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] > 2) {
                nArray[n] = 2;
                continue;
            }
            if (nArray[n] >= 0) continue;
            nArray[n] = 0;
        }
        this.anyErrors();
        n = super.subscribe(stringArray, nArray);
        MQeTrace.trace(this, (short)-30012, 0x100008L);
        return n;
    }

    public int unsubscribe(String[] stringArray) throws MqttNotConnectedException, MqttException, IllegalArgumentException {
        int n;
        MQeTrace.trace(this, (short)-30013, 0x100004L);
        if (stringArray == null) {
            throw new IllegalArgumentException("NULL topic array");
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] != null) continue;
            throw new IllegalArgumentException("NULL topic in topic array at index " + n);
        }
        if (Thread.currentThread().equals(this.reader)) {
            this.invalidApiInvocation();
        }
        this.anyErrors();
        n = super.unsubscribe(stringArray);
        MQeTrace.trace(this, (short)-30014, 0x100008L);
        return n;
    }

    private void invalidApiInvocation() throws MqttException {
        throw new MqttException("MqttClient API called in a callback method! Use a different thread.");
    }
}

