/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt;

import com.ibm.mqtt.MqttPacket;
import com.ibm.mqtt.MqttProcessor;
import com.ibm.mqtt.MqttUtils;

public class MqttPublish
extends MqttPacket {
    public String topicName;

    public MqttPublish() {
        this.setMsgType((short)3);
    }

    public MqttPublish(byte[] byArray, int n) {
        super(byArray);
        this.setMsgType((short)3);
        this.topicName = MqttUtils.UTFToString(byArray, n);
        if (this.getQos() > 0) {
            this.setMsgId(MqttUtils.toShort(byArray, n + this.topicName.length() + 2));
            this.setPayload(MqttUtils.SliceByteArray(byArray, n + this.topicName.length() + 4, byArray.length - (n + this.topicName.length() + 4)));
        } else {
            this.setPayload(MqttUtils.SliceByteArray(byArray, n + this.topicName.length() + 2, byArray.length - (n + this.topicName.length() + 2)));
        }
    }

    public void compressTopic() {
    }

    public void process(MqttProcessor mqttProcessor) {
        if (mqttProcessor.supportTopicNameCompression()) {
            this.uncompressTopic();
        }
        mqttProcessor.process(this);
    }

    public byte[] toBytes() {
        byte[] byArray = MqttUtils.StringToUTF(this.topicName);
        this.message = this.getQos() > 0 ? new byte[byArray.length + 3] : new byte[byArray.length + 1];
        int n = 0;
        this.message[n++] = super.toBytes()[0];
        System.arraycopy(byArray, 0, this.message, n, byArray.length);
        n += byArray.length;
        if (this.getQos() > 0) {
            int n2 = this.getMsgId();
            this.message[n++] = (byte)(n2 / 256);
            this.message[n++] = (byte)(n2 % 256);
        }
        this.createMsgLength();
        return this.message;
    }

    private void uncompressTopic() {
    }
}

