/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt;

import com.ibm.mqtt.MqttBaseClient;
import com.ibm.mqtt.MqttException;
import com.ibm.mqtt.MqttRetry;
import com.ibm.mqtt.MqttTimedEvent;

public class MqttTimedEventQueue
extends Thread {
    private MqttTimedEvent[] m_array;
    private MqttBaseClient session = null;
    private boolean running = false;
    private boolean stopping = false;
    private boolean canDeliverEvents = false;
    private int m_head = 0;
    private int m_tail = 0;

    public MqttTimedEventQueue(int n, MqttBaseClient mqttBaseClient) {
        if (n < 1) {
            n = 4;
        }
        this.m_array = new MqttTimedEvent[n];
        this.session = mqttBaseClient;
    }

    public synchronized void canDeliverEvents(boolean bl) {
        this.canDeliverEvents = bl;
        this.notifyAll();
    }

    private int adjust(int n) {
        int n2 = this.m_array.length;
        return n < n2 ? n : n - n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MqttTimedEventQueue mqttTimedEventQueue = this;
        synchronized (mqttTimedEventQueue) {
            this.running = false;
            this.stopping = true;
            this.notifyAll();
        }
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void enqueue(MqttTimedEvent mqttTimedEvent) throws MqttException {
        long l = mqttTimedEvent.getTime();
        if (this.m_head == this.m_tail || l < this.m_array[this.m_head].getTime()) {
            if (--this.m_head < 0) {
                this.m_head = this.m_array.length - 1;
            }
            this.m_array[this.m_head] = mqttTimedEvent;
            if (this.m_head == this.m_tail) {
                this.expand_array();
            }
        } else {
            for (int i = (this.m_tail < this.m_head ? this.m_tail + this.m_array.length : this.m_tail) - 1; i >= this.m_head; --i) {
                if (l >= this.m_array[this.adjust(i)].getTime()) {
                    this.m_array[this.adjust((int)(i + 1))] = mqttTimedEvent;
                    this.m_tail = this.adjust(this.m_tail + 1);
                    if (this.m_head == this.m_tail) {
                        this.expand_array();
                    }
                    return;
                }
                this.m_array[this.adjust((int)(i + 1))] = this.m_array[this.adjust(i)];
            }
            String string = "MqttTimedEventQueue enqueue out of bounds";
            string = string + "\nAdding event:" + mqttTimedEvent.toString();
            string = string + "\nEvent queue:" + this.toString();
            System.out.println(string);
            throw new MqttException(string);
        }
        this.notifyAll();
    }

    private void expand_array() {
        int n = this.m_array.length;
        MqttTimedEvent[] mqttTimedEventArray = new MqttTimedEvent[n * 2];
        System.arraycopy(this.m_array, this.m_head, mqttTimedEventArray, this.m_head, n - this.m_head);
        System.arraycopy(this.m_array, 0, mqttTimedEventArray, n, this.m_tail);
        this.m_tail += n;
        this.m_array = mqttTimedEventArray;
    }

    public synchronized boolean isEmpty() {
        return this.m_head == this.m_tail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        MqttTimedEvent mqttTimedEvent = null;
        if (!this.stopping) {
            this.running = true;
        }
        while (this.running && !this.stopping) {
            try {
                block22: {
                    try {
                        MqttTimedEventQueue mqttTimedEventQueue = this;
                        synchronized (mqttTimedEventQueue) {
                            if (this.stopping) {
                                return;
                            }
                            while (this.running && (this.m_head == this.m_tail || !this.canDeliverEvents)) {
                                this.wait();
                            }
                            if (this.running) {
                                long l;
                                long l2 = System.currentTimeMillis();
                                if (l2 < (l = this.m_array[this.m_head].getTime()) && this.running) {
                                    this.wait(l - l2);
                                } else if (this.canDeliverEvents || !this.session.outstanding(((MqttRetry)this.m_array[this.m_head]).getMsgId())) {
                                    mqttTimedEvent = this.m_array[this.m_head];
                                    this.m_array[this.m_head++] = null;
                                    if (this.m_head == this.m_array.length) {
                                        this.m_head = 0;
                                    }
                                }
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (mqttTimedEvent == null) continue;
                    try {
                        boolean bl = mqttTimedEvent.notifyEvent();
                        if (!bl) break block22;
                        this.enqueue(mqttTimedEvent);
                    }
                    catch (Exception exception) {
                        boolean bl = false;
                        while (!bl) {
                            try {
                                this.enqueue(mqttTimedEvent);
                                bl = true;
                            }
                            catch (MqttException mqttException) {}
                        }
                    }
                }
                mqttTimedEvent = null;
            }
            catch (Throwable throwable) {
                if (this.session == null) continue;
                this.session.setRegisteredThrowable(throwable);
            }
        }
    }

    public synchronized void resetTimedEventQueue() {
        this.m_head = 0;
        this.m_tail = 0;
        for (int i = 0; i < this.m_array.length; ++i) {
            this.m_array[i] = null;
        }
    }

    public synchronized String toString() {
        int n = this.m_head;
        int n2 = 0;
        int n3 = this.m_head <= this.m_tail ? this.m_tail : this.m_array.length;
        String string = "[";
        while (n < n3) {
            string = string + " " + this.m_array[n++].toString();
        }
        if (n3 == this.m_array.length) {
            while (n2 < this.m_tail) {
                string = string + " " + this.m_array[n2++].toString();
            }
        }
        if (this.m_head != this.m_tail) {
            string = string + " ";
        }
        return string + "]";
    }
}

