/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt;

import com.ibm.mqtt.MqttPacket;
import com.ibm.mqtt.MqttProcessor;
import com.ibm.mqtt.MqttUtils;
import java.util.Vector;

public class MqttUnsubscribe
extends MqttPacket {
    public String[] topics;

    public MqttUnsubscribe() {
        this.setMsgType((short)10);
    }

    public MqttUnsubscribe(byte[] byArray, int n) {
        super(byArray);
        this.setMsgType((short)10);
        this.setMsgId(MqttUtils.toShort(byArray, n));
        Vector vector = MqttUtils.UTFToStrings(byArray, n + 2);
        int n2 = vector.size();
        this.topics = new String[n2];
        for (int i = 0; i < n2; ++i) {
            this.topics[i] = vector.elementAt(i).toString();
        }
    }

    public void compressTopic() {
    }

    public void process(MqttProcessor mqttProcessor) {
        mqttProcessor.process(this);
    }

    public byte[] toBytes() {
        this.message = new byte[3];
        this.message[0] = super.toBytes()[0];
        int n = this.getMsgId();
        this.message[1] = (byte)(n / 256);
        this.message[2] = (byte)(n % 256);
        for (int i = 0; i < this.topics.length; ++i) {
            byte[] byArray = MqttUtils.StringToUTF(this.topics[i]);
            this.message = MqttUtils.concatArray(this.message, byArray);
        }
        this.createMsgLength();
        return this.message;
    }

    private void uncompressTopic() {
    }
}

