/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt;

import java.io.UnsupportedEncodingException;
import java.util.Vector;

public final class MqttUtils {
    public static final String STRING_ENCODING = "UTF-8";

    public static final byte[] concatArray(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static final byte[] concatArray(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        byte[] byArray3 = new byte[n2 + n4];
        System.arraycopy(byArray, n, byArray3, 0, n2);
        System.arraycopy(byArray2, n3, byArray3, n2, n4);
        return byArray3;
    }

    public static final long getExpiry(long l) {
        return System.currentTimeMillis() / 1000L + l * 3L / 2L;
    }

    public static final Vector getTopicsWithQoS(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n <= byArray.length - 4) {
            int n2 = ((byArray[n] & 0xFF) << 8) + ((byArray[n + 1] & 0xFF) << 0);
            StringBuffer stringBuffer = new StringBuffer(byArray.length);
            n2 += (n += 2);
            while (n < n2 && n2 < byArray.length) {
                int n3 = byArray[n++] & 0xFF;
                stringBuffer.append((char)n3);
            }
            if (stringBuffer.toString().length() <= 0) continue;
            stringBuffer.append(byArray[n++]);
            vector.addElement(stringBuffer.toString());
        }
        return vector;
    }

    public static final byte[] SliceByteArray(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static final byte[] StringToUTF(String string) {
        if (string == null) {
            return null;
        }
        try {
            byte[] byArray = string.getBytes(STRING_ENCODING);
            byte[] byArray2 = new byte[byArray.length + 2];
            byArray2[0] = new Integer(byArray.length / 256).byteValue();
            byArray2[1] = new Integer(byArray.length % 256).byteValue();
            System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
            return byArray2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("MQTT Client: Unsupported string encoding - UTF-8");
            return null;
        }
    }

    public static final int toShort(byte[] byArray, int n) {
        return (((short)byArray[n + 0] & 0xFF) << 8) + ((short)byArray[n + 1] & 0xFF);
    }

    public static final String UTFToString(byte[] byArray) {
        return MqttUtils.UTFToString(byArray, 0);
    }

    public static final String UTFToString(byte[] byArray, int n) {
        if (byArray == null) {
            return null;
        }
        int n2 = ((byArray[0 + n] & 0xFF) << 8) + ((byArray[1 + n] & 0xFF) << 0);
        if (n2 + 2 > byArray.length) {
            return null;
        }
        String string = null;
        if (n2 > 0) {
            try {
                string = new String(byArray, n + 2, n2, STRING_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println("MQTT Client: Unsupported string encoding - UTF-8");
            }
        } else {
            string = "";
        }
        return string;
    }

    public static final Vector UTFToStrings(byte[] byArray, int n) {
        int n2;
        if (byArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = n; i <= byArray.length - 3; i += n2 + 2) {
            n2 = ((byArray[i] & 0xFF) << 8) + ((byArray[i + 1] & 0xFF) << 0);
            String string = MqttUtils.UTFToString(byArray, i);
            if (string == null) continue;
            vector.addElement(string);
        }
        return vector;
    }

    public static final String toHexString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (n < 0) {
            n = 0;
        }
        for (int i = n; i < n + n2 && i <= byArray.length - 1; ++i) {
            int n3 = byArray[i];
            if (n3 < 0) {
                n3 += 256;
            }
            if (n3 < 16) {
                stringBuffer.append("0" + Integer.toHexString(n3));
                continue;
            }
            stringBuffer.append(Integer.toHexString(n3));
        }
        return stringBuffer.toString();
    }
}

