/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqtt.trace;

import com.ibm.mqtt.MQeTraceHandler;
import com.ibm.mqtt.trace.MQeTraceToBinary;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class MQeTraceToBinaryFile
extends MQeTraceToBinary
implements MQeTraceHandler {
    public static short[] version = new short[]{2, 0, 0, 2};
    private static final String CURRENT_DIRECTORY = ".";
    private static final String DEFAULT_DIRECTORY = ".";
    public static final String DEFAULT_FILE_NAME_PREFIX = "mqe";
    public static final String DEFAULT_FILE_NAME_SUFFIX = ".trc";
    private static final int NEVER_WRAP = -1;
    private static final boolean DEBUG = false;
    private long maxFileSizeBeforeWrap = -1L;
    private int filesExistingAtOnce = 1;
    private String fileNameSuffix = ".trc";
    private String fileNamePrefix = "mqe";
    private String directoryName = ".";
    private int fileNameIndex = 0;
    public static final long MIN_TRACE_FILE_SIZE = 2096L;
    private static final int DEFAULT_FILES_EXISTING_AT_ONCE = 1;
    static final short FOOTER_BECAUSE_OF_CLOSE = -24001;
    static final short FOOTER_BECAUSE_OF_WRAP = -24000;
    private byte[] footer;
    private FileOutputStream currentFileOut;
    File currentFile;
    private long bytesWritten = 0L;
    static final short FOOTER_BECAUSE_OF_FINALISE = -24002;

    public MQeTraceToBinaryFile() {
        this(".", DEFAULT_FILE_NAME_PREFIX, DEFAULT_FILE_NAME_SUFFIX, 1, -1L);
    }

    public MQeTraceToBinaryFile(String string, String string2, String string3, int n, long l) {
        if (string == null) {
            string = ".";
        }
        this.directoryName = string;
        if (string2 == null) {
            string2 = DEFAULT_FILE_NAME_PREFIX;
        }
        this.fileNamePrefix = string2;
        if (string3 == null) {
            string3 = DEFAULT_FILE_NAME_SUFFIX;
        }
        this.fileNameSuffix = string3;
        if (n < 1) {
            n = 1;
        }
        this.filesExistingAtOnce = n;
        if (n == 1) {
            l = -1L;
        } else if (l < 2096L) {
            l = 2096L;
        }
        this.maxFileSizeBeforeWrap = l;
        this.fileNameIndex = 0;
        this.footer = super.getFooter((short)-24001);
    }

    String throwableStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    boolean openFile() {
        boolean bl = true;
        String string = this.directoryName + System.getProperty("file.separator") + this.fileNamePrefix + this.getPaddedIndex() + this.fileNameSuffix;
        this.currentFile = new File(string);
        if (this.currentFile.exists()) {
            this.currentFile.delete();
        }
        try {
            this.bytesWritten = 0L;
            this.currentFileOut = new FileOutputStream(this.currentFile);
            this.writeHeader();
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    String getPaddedIndex() {
        int n;
        String string = "";
        String string2 = Integer.toString(this.filesExistingAtOnce);
        int n2 = string2.length();
        String string3 = Integer.toString(this.fileNameIndex);
        for (int i = n = string3.length(); i < n2; ++i) {
            string = string + "0";
        }
        string = string + string3;
        return string;
    }

    boolean writeFooter(short s) {
        boolean bl = true;
        try {
            this.currentFileOut.write(this.getFooter(s));
            this.currentFileOut.flush();
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    boolean writeRecord(byte[] byArray) {
        boolean bl = true;
        if (this.maxFileSizeBeforeWrap != -1L && (long)byArray.length + this.bytesWritten + (long)this.footer.length > this.maxFileSizeBeforeWrap && (bl = this.writeFooter((short)-24000))) {
            this.advanceFileNameIndex();
            bl = this.openFile();
        }
        if (bl) {
            try {
                this.currentFileOut.write(byArray);
                this.bytesWritten += (long)byArray.length;
                this.currentFileOut.flush();
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        return bl;
    }

    boolean writeHeader() {
        boolean bl = true;
        byte[] byArray = this.getHeader();
        try {
            this.currentFileOut.write(byArray);
            this.currentFileOut.flush();
            this.bytesWritten += (long)byArray.length;
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    boolean on() {
        boolean bl = true;
        bl = this.openFile();
        return bl;
    }

    boolean off() {
        boolean bl = true;
        bl = this.writeFooter((short)-24001);
        this.advanceFileNameIndex();
        this.closeFile();
        return bl;
    }

    void finalise() {
        if (this.currentFileOut != null) {
            this.writeFooter((short)-24002);
            this.closeFile();
        }
    }

    private final void closeFile() {
        try {
            this.currentFileOut.close();
            this.currentFileOut = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void advanceFileNameIndex() {
        ++this.fileNameIndex;
        if (this.fileNameIndex >= this.filesExistingAtOnce) {
            this.fileNameIndex = 0;
        }
    }
}

