package com.team5.aLife.BaseStation;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;

public class AddDeviceActivity extends Activity{

	private Button submit;
	
	private EditText deviceName;
	
	Spinner deviceType;
	
	private DBHandler db = new DBHandler(this);
	
	private final String TAG = "AddDeviceActivity";
	
	 /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.adddevice_two);
        
        submit = (Button) findViewById(R.id.Submit);
        deviceType = (Spinner) findViewById(R.id.DeviceTypeSpin);
        ArrayAdapter<CharSequence> adapter = ArrayAdapter.createFromResource(
                this, R.array.device_type_names, android.R.layout.simple_spinner_item);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        deviceType.setAdapter(adapter);
        
        deviceName = (EditText) findViewById(R.id.DeviceName);
        
        submit.setOnClickListener(connectListener);
        
    }
    
    private View.OnClickListener connectListener = new View.OnClickListener() {

        @Override
        public void onClick(View v) {
        
        	
        if (deviceName.getText().toString().equals(""))
        {
        	AlertDialog.Builder builder = new AlertDialog.Builder(AddDeviceActivity.this);
        	builder.setMessage("Please put in a valid device name")
        	       .setCancelable(false)
        	       .setPositiveButton("OK", new DialogInterface.OnClickListener() {
        	           public void onClick(DialogInterface dialog, int id) {
        	        	   //RegisterDeviceActivity.this.finish();
        	           }
        	       });
        	AlertDialog alert = builder.create();
        	alert.show();
        }
        else
        {
        	
        int zigbeeAddress = SerialCommunicatonHandler.pollForNewDevice();
        
        zigbeeAddress = 1;
        
        Log.i(TAG+"onclick", "Returned zigbee Address is " + zigbeeAddress);
        
        if (zigbeeAddress == 0)
        {
        	AlertDialog.Builder builder = new AlertDialog.Builder(AddDeviceActivity.this);
        	builder.setMessage("There was a problem finding the device")
        	       .setCancelable(false)
        	       .setPositiveButton("OK", new DialogInterface.OnClickListener() {
        	           public void onClick(DialogInterface dialog, int id) {
        	        	   //RegisterDeviceActivity.this.finish();
        	           }
        	       });
        	AlertDialog alert = builder.create();
        	alert.show();
        	return;
        }
        	
        Device newDevice = new Device (0,
        							   Integer.parseInt(getResources().getStringArray(R.array.device_type_values)[deviceType.getSelectedItemPosition()]), 
					   				   deviceName.getText().toString(), 
					   				   "" + zigbeeAddress,
					   				   1,
					   				   1);	
        
        db.open();
        
        long insertResult = db.insertDevice(newDevice);
        Log.i("AddDeviceActivity: onClick", "Result of database insert is " + insertResult);
        
        deviceName.setText("");
        
        db.close();
            
        }
        
    }};
	
}
