package com.team5.aLife.BaseStation;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.database.Cursor;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;

public class AddUserActivity extends Activity {
	
	private final String TAG = "AddUserActivity:  ";
	
	private Button submit;
	
	private EditText userName, newPassword, confirmPassword;
	
	Spinner spinner;
	
	private DBHandler db = new DBHandler(this);			// database handler object
	
	/** Called when the activity is first created. */
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.adduser);
        
        spinner = (Spinner) findViewById(R.id.spinner1);
        ArrayAdapter<CharSequence> adapter = ArrayAdapter.createFromResource(
                this, R.array.access_level_array, android.R.layout.simple_spinner_item);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spinner.setAdapter(adapter);
        
        submit = (Button)findViewById(R.id.NewSubmitUser);
        userName = (EditText) findViewById(R.id.NewUserName);
        newPassword = (EditText) findViewById(R.id.NewPasswordUser);
        confirmPassword = (EditText) findViewById(R.id.NewReenterPassword);
                
        submit.setOnClickListener(submitListener);
        
    } // end onCreate
    
    private View.OnClickListener submitListener = new View.OnClickListener() {

        @Override
        public void onClick(View v) {
        	
        	if (isUserNameUnavailable())
        	{
        		AlertDialog.Builder builder = new AlertDialog.Builder(AddUserActivity.this);
            	builder.setMessage("User name already in use")
            	       .setCancelable(false)
            	       .setPositiveButton("OK", new DialogInterface.OnClickListener() {
            	           public void onClick(DialogInterface dialog, int id) {
            	        	   //RegisterDeviceActivity.this.finish();
            	           }
            	       });
            	AlertDialog alert = builder.create();
            	alert.show();
        	}
        	else
        	{
        
	        	if (newPassword.getText().toString().equals(confirmPassword.getText().toString()))
	        	{
	        		
	        		db.open();
	        		
	        		if (spinner.getSelectedItem().toString().equals("Administrator"))
	        		{
	        			db.insertUser(userName.getText().toString(), 
	      					  newPassword.getText().toString(), "Administrator", 0, 0, 0);
	        		}
	        		else
	        		{
	        			db.insertUser(userName.getText().toString(), 
	      					  newPassword.getText().toString(), "Generic User", 0, 0, 0);
	        		}
	        		
	        		
	        		db.close();
	        		
	                finish();
	        	}
	        	else
	        	{
	        		//  Alert the user password's are not placed in correctly
	            	
	        		AlertDialog.Builder builder = new AlertDialog.Builder(AddUserActivity.this);
	            	builder.setMessage("The passwords do not match")
	            	       .setCancelable(false)
	            	       .setPositiveButton("OK", new DialogInterface.OnClickListener() {
	            	           public void onClick(DialogInterface dialog, int id) {
	            	        	   //RegisterDeviceActivity.this.finish();
	            	           }
	            	       });
	            	AlertDialog alert = builder.create();
	            	alert.show();
	        	}
        	}
            
        }
    };
    
    private boolean isUserNameUnavailable()
    {
    	boolean result;
    	
    	db.open();
    	
    	Cursor c = db.getUser(userName.getText().toString());
    	
    	if (c.moveToFirst())
    		result = true;
    	else
    		result = false;
    	
    	c.close();
    	db.close();
    	
    	Log.i(TAG+"IsUserNameUnavailable", "Is the user name unavailable?  " + result);
    	return result;
    		
    }

}
