package com.team5.aLife.BaseStation;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;

public class EditDeviceActivity extends Activity{
	
	private Button update, delete;
	
	private EditText deviceName;
	
	Device newDevice;
	
	private DBHandler db = new DBHandler(this);
	
	@Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.editdevice_two);
        
        update = (Button)findViewById(R.id.Update);
        delete = (Button)findViewById(R.id.Delete);
        deviceName = (EditText) findViewById(R.id.DeviceName2);
        
        deviceName.setText(DeviceListActivity.selectedDevice.getDeviceName());
		
		//  Loads LTF on click and stores spinner selection in bundle to pass to new activity
		update.setOnClickListener(updateListener);
		
		//  Loads LTF on click and stores spinner selection in bundle to pass to new activity
		delete.setOnClickListener(deleteListener);
		
	}
	
	 private View.OnClickListener updateListener = new View.OnClickListener() {

	        @Override
	        public void onClick(View v) {	
	        	
	        
	        
	        AlertDialog.Builder builder = new AlertDialog.Builder(EditDeviceActivity.this);
	    	builder.setTitle("Update Device")
	    		   .setMessage("All changes are final, do you want to proceed?")
	    	       .setCancelable(false)
	    	       .setPositiveButton("Yes", new DialogInterface.OnClickListener() {
	    	           public void onClick(DialogInterface dialog, int id) 
	    	           {
	    	        	   DeviceListActivity.selectedDevice.setDeviceName(deviceName.getText().toString());
	    		        	
	    	   	           newDevice = DeviceListActivity.selectedDevice;
	    	        	   
	    	        	   db.open();
	    	   	        
		    	   	       db.updateDevice(newDevice);
		    	   	        
		    	   	       deviceName.setText("");
		    	   	        
		    	   	       db.close();
	    	        	   
	    	        	   finish();
	    	           }
	    	       })
	    	       .setNegativeButton("No", new DialogInterface.OnClickListener() {
	    	           public void onClick(DialogInterface dialog, int id) 
	    	           {
	    	                dialog.cancel();
	    	           }
	    	       });
	    	builder.show();
	            
	        }
	    };
	    
	    private View.OnClickListener deleteListener = new View.OnClickListener() {

	        @Override
	        public void onClick(View v) {
	        	
	        	AlertDialog.Builder builder = new AlertDialog.Builder(EditDeviceActivity.this);
		    	builder.setTitle("Delete Device")
		    		   .setMessage("All changes are final, do you want to proceed?")
		    	       .setCancelable(false)
		    	       .setPositiveButton("Yes", new DialogInterface.OnClickListener() {
		    	           public void onClick(DialogInterface dialog, int id) 
		    	           {
		    	        	   //  TODO "Need to make call to serial data to delete from network"
		    	        	   
		    	        	   boolean result = SerialCommunicatonHandler.removeDeviceFromNetwork(DeviceListActivity.selectedDevice.getZigbeeStatus());
		    	        	   
		    	        	   if (result)
		    	        	   {
			    	        	   db.open();
			    	   	        
			    	        	   db.deleteNotificationByDeviceID(DeviceListActivity.selectedDevice.getDeviceID());
				    	   	       db.deleteDevice(DeviceListActivity.selectedDevice.getDeviceID());
				    	   	        
				    	   	       db.close();
				    	   	       
				    	   	       startService(new Intent(EditDeviceActivity.this, BackgroundServices.class));
			    	        	   finish();
			    	        	   
			    	        	   AlertDialog.Builder builder = new AlertDialog.Builder(EditDeviceActivity.this);
			    	           	builder.setMessage("Transaction Successful")
			    	           	       .setCancelable(false)
			    	           	       .setPositiveButton("OK", new DialogInterface.OnClickListener() {
			    	           	           public void onClick(DialogInterface dialog, int id) {
			    	           	        	   //RegisterDeviceActivity.this.finish();
			    	           	           }
			    	           	       });
			    	           	AlertDialog alert = builder.create();
			    	           	alert.show();
		    	        	   }
		    	        	   else
		    	        	   {
		    	        		   AlertDialog.Builder builder = new AlertDialog.Builder(EditDeviceActivity.this);
		    	               	builder.setMessage("Transaction Failed")
		    	               	       .setCancelable(false)
		    	               	       .setPositiveButton("OK", new DialogInterface.OnClickListener() {
		    	               	           public void onClick(DialogInterface dialog, int id) {
		    	               	        	   //RegisterDeviceActivity.this.finish();
		    	               	           }
		    	               	       });
		    	               	AlertDialog alert = builder.create();
		    	               	alert.show();
		    	        	   }
		    	           }
		    	       })
		    	       .setNegativeButton("No", new DialogInterface.OnClickListener() {
		    	           public void onClick(DialogInterface dialog, int id) 
		    	           {
		    	                dialog.cancel();
		    	           }
		    	       });
		    	builder.show();
	            
	        }
	    };

}
