package com.team5.aLife.BaseStation;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.TextView;

import com.team5.aLife.BaseStation.DBHandler.DB_Notifications_Setup;

public class NotificationPowerActivity extends Activity {
	
	private String TAG = "NotificationPowerActivity:  ";
	
	private final String DELIMITER = "&";
	
	TextView deviceName;
	
	Spinner timeOne, timeTwo;
	
	Button submit;
	
	ALifeNotificationSetup notification;
	
	private ProgressDialog m_ProgressDialog = null; 	// progress dialog
	
	private DBHandler db = new DBHandler(this);			// database handler object
	
	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.notification_power_switch);
        
        deviceName = (TextView) findViewById(R.id.NotificationPowerDeviceName);
        
        timeOne = (Spinner) findViewById(R.id.NotificationPowerTimeOne);
        ArrayAdapter<CharSequence> adapter = ArrayAdapter.createFromResource(
                this, R.array.notificatoin_power_time_array, android.R.layout.simple_spinner_item);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        timeOne.setAdapter(adapter);
        
        timeTwo = (Spinner) findViewById(R.id.NotificationPowerTimeTwo);
        ArrayAdapter<CharSequence> adapter2 = ArrayAdapter.createFromResource(
                this, R.array.notificatoin_power_time_array2, android.R.layout.simple_spinner_item);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        timeTwo.setAdapter(adapter2);
        
        submit = (Button) findViewById(R.id.NotificationPowerSubmit);
        
        
    }
    
    public void onStart()
    {
    	super.onStart();
    	
    	submit.setOnClickListener(submitListener);
    	
    	deviceName.setText(DeviceListActivity.selectedDevice.getDeviceName());
    	
    	
    }
    
    private View.OnClickListener submitListener = new View.OnClickListener() {

        @Override
        public void onClick(View v) {
        	
        	m_ProgressDialog = ProgressDialog.show(NotificationPowerActivity.this,    
                    "Please wait...", "Retrieving data ...", true);
        	
        	int firstTime = timeOne.getSelectedItemPosition();
        	int secondTime = timeTwo.getSelectedItemPosition();
        	
        	String triggeringCondition;
    		
    		triggeringCondition = firstTime + DELIMITER + secondTime;
        	
    		Log.i(TAG+"onClick", "The valueof triggeringCondition is:  " + triggeringCondition);
    		
        	if (isNotificationAlreadySetup())
        	{
        		notification.setTriggeringCondition(triggeringCondition);
        		
        		db.open();
        		
        		db.updateNotification(notification);
        		
        		db.close();
        		
        	}
        	else
        	{ 
        		notification = new ALifeNotificationSetup(DeviceListActivity.selectedDevice.getDeviceID(),  
        												  LoginActivity.activeUser.getUserID(), 
        												  DeviceListActivity.selectedDevice.getDeviceType(), 
        												  triggeringCondition);
        		
        		Log.i(TAG+"onClick", "The notification properties: " +
    				  DeviceListActivity.selectedDevice.getDeviceID() + " " +
					  LoginActivity.activeUser.getUserID() + " " +
					  DeviceListActivity.selectedDevice.getDeviceType() + " " +
					  triggeringCondition);
        		
        		db.open();
        		
        		db.insertNotification(notification);
        		
        		db.close();
        		
        	}
        	
        	m_ProgressDialog.dismiss();
        	
        	startService(new Intent(NotificationPowerActivity.this, BackgroundServices.class));
        	finish();
            
        }
    };
    
    private boolean isNotificationAlreadySetup()
    {
    	boolean result = false;
    	
    	db.open();
    	
    	Cursor c = db.getNotification(DeviceListActivity.selectedDevice.getDeviceID(), LoginActivity.activeUser.getUserID());
    	
    	/* Get the indices of the Columns we will need */
        int IDCol = c.getColumnIndex(DB_Notifications_Setup._ID);
        int deviceIDCol = c.getColumnIndex(DB_Notifications_Setup.DEVICE_ID);
        int userIDCol = c.getColumnIndex(DB_Notifications_Setup.USER_ID);
        int notificationTypeCol = c.getColumnIndex(DB_Notifications_Setup.NOTIFICATION_TYPE);
        int triggerConditionCol = c.getColumnIndex(DB_Notifications_Setup.TRIGGERING_CONDITION);
        
        if (c != null)
	    	if (c.moveToFirst())
	    	{
	    		result = true;
	    		
	    		//  Retrieve the values of the Entry the Cursor is pointing to. 
	            int ID = c.getInt(IDCol);
	            int deviceID = c.getInt(deviceIDCol);
	            int userID = c.getInt(userIDCol);
	            int notificationType = c.getInt(notificationTypeCol);
	            String triggeringCondition = c.getString(triggerConditionCol);
	            
	            notification = new ALifeNotificationSetup(ID, deviceID, userID, notificationType, 
	            										  triggeringCondition);
	            
	            c.close();
	    		
	    	}
	    	else
	    	{
	    		result = false;
	    	}
    	
    	
    	db.close();
    	
    	Log.i(TAG+"isNotificationAlreadySetup", "Is the notification already set up?  " + result);
    	return result;
    		
    }

}
