package com.team5.aLife.BaseStation;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.content.res.Resources;
import android.preference.PreferenceManager;

public class PreferenceHandler {
	
	protected static SharedPreferences prefs;         
    private static Resources resources;
    private static Editor editor;
   
    private static int     notificationHistoryDays        = 0;
    private static int     powerHistoryDays     		  = 0;
    private static int	   everRegistered				  = 0;
    private static boolean serialStatus                   = false;
    
    //  Default Values
    
    private static final String	NOTIFICATION_HISTORY_DAYS_DEFAULT_VALUE 	= "30";
    private static final String	POWER_HISTORY_DAYS_DEFAULT_VALUE 			= "30";
    private static final int 	EVER_REGISTERED_DEFAULT_VALUE				=  0;
    private static final boolean SERIAL_STATUS_DEFAULT_VALUE				= true;
	
	private PreferenceHandler()
	{
		//  Does Nothing
	}
    
    static void init(Context context) {
           
            prefs     = PreferenceManager.getDefaultSharedPreferences(context);
            resources = context.getResources();
            editor = prefs.edit();
    }
    
    public static void updatePreferences() {
        
        String key = "";
       
        ////////////////////////////////////////////
        // Logs & Serial Communication
        ///////////////////////////////////////////
        key = (String)resources.getText(R.string.preferences_item_notification_log_key);
        notificationHistoryDays = Integer.parseInt(prefs.getString(key, NOTIFICATION_HISTORY_DAYS_DEFAULT_VALUE));
       
        key = (String)resources.getText(R.string.preferences_item_power_history_log_key);
        powerHistoryDays = Integer.parseInt(prefs.getString(key, POWER_HISTORY_DAYS_DEFAULT_VALUE));
        
        key = "serialStatus";
        serialStatus = prefs.getBoolean(key, SERIAL_STATUS_DEFAULT_VALUE);
        
        everRegistered = prefs.getInt("everRegistered", EVER_REGISTERED_DEFAULT_VALUE);
        
        System.out.println("I updated the value of ever Regsiter to " + everRegistered);
       
    }
    
    public static void loadDefaultPreferences() {
        
        String key = "";
       
        ////////////////////////////////////////////
        // Logs
        ///////////////////////////////////////////
        key = (String)resources.getText(R.string.preferences_item_notification_log_key);
        editor.putString(key, NOTIFICATION_HISTORY_DAYS_DEFAULT_VALUE);
       
        key = (String)resources.getText(R.string.preferences_item_power_history_log_key);
        editor.putString(key, POWER_HISTORY_DAYS_DEFAULT_VALUE);
        
        key = "serialStatus";
        editor.putBoolean(key, SERIAL_STATUS_DEFAULT_VALUE);
       
        editor.commit();
    }

    public static SharedPreferences getSharedPref(){
    	return prefs;
    }
    
    public static boolean isSerialCommunicationEnabled(){
    	return serialStatus;
    }
    
    public static void deviceHasBeenRegistered() {
    	
    	editor.putInt("everRegistered", 1);
    	editor.commit();
    }
    
    //   To be used for testing purposes
    public static void unregisterDevice() {
    	editor.putInt("everRegistered", 0);
    	editor.commit();
    }
    
	public static int getNotificationHistoryDays() {
	        return notificationHistoryDays;
	}
	
	public static int getPowerHistoryDays() {
	        return powerHistoryDays;
	}    
	
	public static boolean isDeviceRegistered(){
		System.out.println("Registration value " + everRegistered);
		return everRegistered > 0;
	}

}
