package com.team5.aLife.BaseStation;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.Preference.OnPreferenceChangeListener;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;

public class PreferencesActivity extends PreferenceActivity {
	
	private Application mApplication;
	private com.team5.aLife.BaseStation.SerialCommunication.SerialPortFinder mSerialPortFinder;
	
	private boolean oldSerialStatus;
	private boolean newSerialStatus;
	
	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        
        Log.i("APP:  ", "Say something first mofo:  " + getApplication().toString());
        mApplication = (Application) getApplication();
		mSerialPortFinder = mApplication.mSerialPortFinder;
        
        addPreferencesFromResource(R.layout.preferences);
        setContentView(R.layout.preferenceshell);
        Button loadDefaultPreferenceButton = (Button)findViewById(R.id.LoadDefault);
		
		//  Loads LTF on click and stores spinner selection in bundle to pass to new activity
		loadDefaultPreferenceButton.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
              
              alert();
              
            }
          });

		// Devices
		final ListPreference devices = (ListPreference)findPreference("DEVICE");
        String[] entries = mSerialPortFinder.getAllDevices();
        String[] entryValues = mSerialPortFinder.getAllDevicesPath();
		devices.setEntries(entries);
		devices.setEntryValues(entryValues);
		devices.setSummary(devices.getValue());
		devices.setOnPreferenceChangeListener(new OnPreferenceChangeListener() {
			public boolean onPreferenceChange(Preference preference, Object newValue) {
				preference.setSummary((String)newValue);
				return true;
			}
		});

		// Baud rates
		final ListPreference baudrates = (ListPreference)findPreference("BAUDRATE");
		baudrates.setSummary(baudrates.getValue());
		baudrates.setOnPreferenceChangeListener(new OnPreferenceChangeListener() {
			public boolean onPreferenceChange(Preference preference, Object newValue) {
				preference.setSummary((String)newValue);
				return true;
			}
		});
		
		oldSerialStatus = PreferenceHandler.isSerialCommunicationEnabled();
		
	}
	
	public void alert()
	{
		AlertDialog.Builder builder = new AlertDialog.Builder(this);
    	builder.setMessage(R.string.quit_really_dialog)
    		   .setTitle(R.string.quit_dialog)
    	       .setCancelable(false)
    	       .setPositiveButton(R.string.yes_dialog, new DialogInterface.OnClickListener() {
    	           public void onClick(DialogInterface dialog, int id) 
    	           {
    	        	   PreferenceHandler.loadDefaultPreferences();
    	               PreferenceHandler.updatePreferences();
    	               
    	               finish();
    	               Intent i = new Intent(PreferencesActivity.this, PreferencesActivity.class);
    	               startActivity(i);
    	           }
    	       })
    	       .setNegativeButton(R.string.no_dialog, new DialogInterface.OnClickListener() {
    	           public void onClick(DialogInterface dialog, int id) 
    	           {
    	                dialog.cancel();
    	           }
    	       });
    	builder.show();
	}
    @Override
    public void onStop() {
        // Cancel the persistent notification.
        
        
        PreferenceHandler.updatePreferences();
        newSerialStatus = PreferenceHandler.isSerialCommunicationEnabled();
        
        if (newSerialStatus && !oldSerialStatus)
        {
        	startService(new Intent(this, BackgroundServices.class));
        }
        
        if (!newSerialStatus && oldSerialStatus)
        {
        	Bundle bundle = new Bundle();
            bundle.putString("STOPSERIAL", "stop");
           
            Intent myIntent = new Intent(this, BackgroundServices.class);
            myIntent.putExtras(bundle);
            
        	startService(myIntent);
        	
        }
        super.onStop();
    }
    
}
