package com.team5.aLife.BaseStation;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;

public class RegisterDeviceActivity extends Activity {

	private Button submit;
	
	private EditText keyCode, userName, password, confirmPassword;
	
	private DBHandler db = new DBHandler(this);
	
	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.registerdevice);
        
        submit = (Button) findViewById(R.id.SubmitUser);
        keyCode = (EditText) findViewById(R.id.KeyCode);
        userName = (EditText) findViewById(R.id.UserName);
        password = (EditText) findViewById(R.id.PasswordUser);
        confirmPassword = (EditText) findViewById(R.id.ReenterPassword);
        
        submit.setOnClickListener(connectListener);
        
    }

    private View.OnClickListener connectListener = new View.OnClickListener() {

        @Override
        public void onClick(View v) {
        	
            if (keyCode.getText().toString().equals("aLife"))
            {
            	if (password.getText().toString().equals(confirmPassword.getText().toString()))
            	{
            		PreferenceHandler.deviceHasBeenRegistered();
            		PreferenceHandler.updatePreferences();
            		
            		db.open();
            		
            		db.insertUser(userName.getText().toString(), 
            					  password.getText().toString(), "Administrator", 0, 0, 0);
            		
            		db.close();
            		
            		Intent myIntent = new Intent();
            		myIntent.setClassName("com.team5.aLife.BaseStation",
                                          "com.team5.aLife.BaseStation.LoginActivity");
                    startActivity(myIntent);
                    finish();
            	}
            	else
            	{
            		//  Alert the user password's are not placed in correctly
                	
                	AlertDialog.Builder builder = new AlertDialog.Builder(RegisterDeviceActivity.this);
                	builder.setMessage("The passwords do not match")
                	       .setCancelable(false)
                	       .setPositiveButton("OK", new DialogInterface.OnClickListener() {
                	           public void onClick(DialogInterface dialog, int id) {
                	        	   //RegisterDeviceActivity.this.finish();
                	           }
                	       });
                	AlertDialog alert = builder.create();
                	alert.show();
            	}
            }
            else
            {
            	//  Alert the user that the key code was incorrect
            	
            	AlertDialog.Builder builder = new AlertDialog.Builder(RegisterDeviceActivity.this);
            	builder.setMessage("Incorrect Key Code")
            	       .setCancelable(false)
            	       .setPositiveButton("OK", new DialogInterface.OnClickListener() {
            	           public void onClick(DialogInterface dialog, int id) {
            	        	   //RegisterDeviceActivity.this.finish();
            	           }
            	       });
            	AlertDialog alert = builder.create();
            	alert.show();
            }
            
        }
    };
	
}
