package com.team5.aLife.BaseStation;

import java.util.ArrayList;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import android.util.Log;

import com.google.gson.Gson;

public final class parseResponse {
	
	private static parseResponse thisParseResponse = new parseResponse();
	Gson gson = new Gson();
	JSONArray jsonArray = null;
	JSONObject json = null;
	ArrayList<Device> al = new ArrayList<Device>();
	
	private static final String tag = "parseResponse:";
	
	
	public parseResponse(){
		
	}

	public static parseResponse instance(){
		return thisParseResponse;
	}
	
	public ArrayList<Device> toArrayList(String in){
		try {
			
			// Create a new JSONObject out of the string
			json = new JSONObject(in);
			
			// Extract the "devices" object out of the JSONObject
			json = json.getJSONObject("devices");
			
			// Extract the JSONArray out of the JSONObject
			// "myArrayList" is a default name I haven't tried to change
			//jsonArray = json.getJSONArray("myArrayList");
			jsonArray = json.getJSONArray("values");
			
			// Loop through all the devices in the JSONArray
			for (int c = 0;c < jsonArray.length(); c++){
					// Move from JSONArray to ArrayList<Device>
					al.add(gson.fromJson(jsonArray.get(c).toString(), Device.class));
			}
			
		} catch (JSONException e) {
			Log.i(tag + "toArrayList","Errors w/ json objects" , e);
		}
				
		// Return the ArrayList
		return al;
	}
	
}
