/*
 * 	DCM.c
 *
 *  Created on: Aug 23, 2010
 *  Author: Jared Rought
 *
 *  Function: Provides the directional cosine matrix for self-stabilization calculations.
 */

#include "DCM.h"
#include "stm32f10x.h"
#include "math.h"
#include "Constrain.h"

#define T .02
#define KPXY 1.25//0.125//0.0001
#define KIXY 0.10//0.000005
#define KPZ 1.2
#define KIZ 0.00005
#define GYRO_FILTER 0.2
#define ACCEL_FILTER 0.2

extern float MAG_X;
extern float MAG_Y;
extern float MAG_Heading;
extern float Heading_X;
extern float Heading_Y;
extern float cos_roll;
extern float sin_roll;
extern float cos_pitch;
extern float sin_pitch;

void matrixMult(float MatOut[3][3], float Mat1[3][3], float Mat2[3][3]);
void matrixAdd(float MatOut[3][3], float Mat1[3][3], float Mat2[3][3]);
void vectorCross(float* CrossOut, float* v1, float* v2);
float vectorDot(float* v1, float* v2);
void vectorAdd(float* vOut, float* v1, float* v2);
void vectorScale(float* vOut, float* vIn, float ScaleFactor);


//Global DCM Variables
float Gyros[3] = {0, 0, 0};
float Accels[3] = {0, 0, 0};
float Mag[3] = {0,0,0};
float Omega[3] = {0, 0, 0};
float OmegaI[3] = {0, 0, 0};
float OmegaP[3] = {0, 0, 0};
float OmegaUpdate[3] = {0,0,0};
float ErrorXY[3] = {0,0,0};
float ScaledOmegaP[3] = {0,0,0};
float ScaledOmegaI[3] = {0,0,0};
float ErrorXYScaled[3] = {0,0,0};
float AccelMag;
float AccelCon;
float errorCourse = 0;


float DCMt;
float roll;
float RmatUpdated[3][3];
float RmatTemp[3][3];

float Xorthog[3] = {0, 0, 0};
float Yorthog[3] = {0, 0, 0};
float Zorthog[3] = {0, 0, 0};
float error;
float normalized;

float OmegaITemp[3] = {0,0,0};
float errorYaw[3] = {0,0,0};;
float Scaled_OmegaI[3];
float Scaled_OmegaP[3];

float MatTemp[3];



//This function updates the rotational matrix based on the measured gyro values,
//Then subsequently normalizes the matrix to compensate for accumulated numerical
//integration errors.
void updateRmat(void){
	//local variables

	 // Update gyros vector and apply signs 1, -1, -1,    -1, 1, 1,     -1, -1, -1};
	Gyros[0] = GyroCon[0];//-(Gyros[0]*(1.0 - GYRO_FILTER)) + (GyroCon[0]*GYRO_FILTER); // x gyro
	Gyros[1] = GyroCon[1];//-(Gyros[1]*(1.0 - GYRO_FILTER)) + (GyroCon[1]*GYRO_FILTER); // y gyro
	Gyros[2] = GyroCon[2];//-(Gyros[2]*(1.0 - GYRO_FILTER)) + (GyroCon[2]*GYRO_FILTER);; // z gyro
	Accels[0] = Accels[0]*0.4 + AccCon[0]*0.6; // x accel
	Accels[1] = Accels[1]*0.4 + AccCon[1]*0.6;// y accel
	Accels[2] = Accels[2]*0.4 + AccCon[2]*0.6; // z accel
	Mag[0] = MagCon[0];
	Mag[1] = MagCon[1];
	Mag[2] = MagCon[2];

	// Add proportional and integral terms
	vectorAdd(&Omega[0], &Gyros[0], &OmegaI[0]);
	vectorAdd(&OmegaUpdate[0], &Omega[0], &OmegaP[0]);

	RmatUpdated[0][0] = 0;
	RmatUpdated[0][1] = -OmegaUpdate[2]*T;  //z
	RmatUpdated[0][2] = OmegaUpdate[1]*T; //-y
	RmatUpdated[1][0] = OmegaUpdate[2]*T; //-z
	RmatUpdated[1][1] = 0;
	RmatUpdated[1][2] = -OmegaUpdate[0]*T; //x
	RmatUpdated[2][0] = -OmegaUpdate[1]*T; //y
	RmatUpdated[2][1] = OmegaUpdate[0]*T;//-x
	RmatUpdated[2][2] = 0;
/*
	RmatUpdated[0][0] = 0;
	RmatUpdated[0][1] = -Gyros[2]*T;  //z
	RmatUpdated[0][2] = Gyros[1]*T; //-y
	RmatUpdated[1][0] = Gyros[2]*T; //-z
	RmatUpdated[1][1] = 0;
	RmatUpdated[1][2] = -Gyros[0]*T; //x
	RmatUpdated[2][0] = -Gyros[1]*T; //y
	RmatUpdated[2][1] = Gyros[0]*T;//-x
	RmatUpdated[2][2] = 0;*/

	matrixMult(&RmatTemp[0], &Rmat[0], &RmatUpdated[0]);
	matrixAdd(&Rmat[0], &Rmat[0], &RmatTemp[0]);

	normRmat();
	DCMt = Rmat[2][0];
	roll = Rmat[2][1];
}

//DCM normalizing function
void normRmat(void){

						//X vector  //Y vector
	error = -vectorDot(&Rmat[0][0], &Rmat[1][0])*0.5; //error scaling factor

	//X orthogonal vector
	vectorScale(&Xorthog[0], &Rmat[1][0], error);
	vectorAdd(&Xorthog[0], &Xorthog[0], &Rmat[0][0]);

	//Y orthogonal vector
	vectorScale(&Yorthog[0], &Rmat[0][0], error);
	vectorAdd(&Yorthog[0], &Yorthog[0], &Rmat[1][0]);

	//Z orthogonal vector
	vectorCross(&Zorthog[0], &Xorthog[0], &Yorthog[0]);

	//Taylor's Expansion
	//X normalized
	normalized = 0.5*(3-vectorDot(&Xorthog[0], &Xorthog[0]));
	vectorScale(&Rmat[0][0], &Xorthog[0], normalized);

	//Y normalized
	normalized = 0.5*(3-vectorDot(&Yorthog[0], &Yorthog[0]));
	vectorScale(&Rmat[1][0], &Yorthog[0], normalized);

	//Z normalized
	normalized = 0.5*(3-vectorDot(&Zorthog[0], &Zorthog[0]));
	vectorScale(&Rmat[2][0], &Zorthog[0], normalized);
}

//Gyro drift compensation function. This function compensates for pitch, roll and yaw drift
void correctRmat(void){
	float error,COGY,COGX;

	//Roll and Pitch Correction
	vectorCross(&ErrorXY[0],&Accels[0],&Rmat[2][0]);
	//ErrorXY[0] = constrain(ErrorXY[0],-50,50);
	//ErrorXY[1] = constrain(ErrorXY[1],-50,50);
	//ErrorXY[2] = constrain(ErrorXY[2],-50,50);
	vectorScale(&OmegaP[0], &ErrorXY[0], KPXY);

	vectorScale(&OmegaITemp[0], &ErrorXY[0], KIXY);
	vectorAdd(&OmegaI[0], &OmegaI[0], &OmegaITemp[0]);

	 //*****YAW***************
	// We make the gyro YAW drift correction based on compass magnetic heading
	errorCourse= (Rmat[0][0]*Heading_Y) - (Rmat[1][0]*Heading_X);

	vectorScale(&errorYaw[0],&Rmat[2][0],errorCourse); //Applys the yaw correction to the XYZ rotation of the aircraft, depeding the position.

	vectorScale(&ScaledOmegaP[0], &errorYaw[0], KPZ);
	vectorAdd(&OmegaP[0], &OmegaP[0], &ScaledOmegaP[0]);

	//errorYaw[0] = constrain(errorYaw[0],-50,50);
	//errorYaw[1] = constrain(errorYaw[1],-50,50);
    //errorYaw[2] = constrain(errorYaw[2],-50,50);

	vectorScale(&ScaledOmegaI[0], &errorYaw[0], KIZ);
	vectorAdd(&OmegaI[0], &OmegaI[0], &ScaledOmegaI[0]);
}

//DCM arithmatic

//Matrix operations
void matrixMult(float MatOut[][3], float Mat1[][3], float Mat2[][3]){


	for(i=0;i<3;i++){
		for(j=0;j<3;j++){
			for(k=0;k<3;k++){
				MatTemp[k] = Mat1[i][k]*Mat2[k][j];
			}
			MatOut[i][j] = MatTemp[0] + MatTemp[1]+ MatTemp[2];
		}
	}
}

void matrixAdd(float MatOut[][3], float Mat1[][3], float Mat2[][3]){


	for(i=0;i<3;i++){
		for(j=0;j<3;j++){
			MatOut[i][j] = Mat1[i][j] + Mat2[i][j];
		}
	}
}

void vectorCross(float* CrossOut, float* v1, float* v2){
	CrossOut[0] = (v1[1]*v2[2]) - (v1[2]*v2[1]);
	CrossOut[1] = (v1[2]*v2[0]) - (v1[0]*v2[2]);
	CrossOut[2] = (v1[0]*v2[1]) - (v1[1]*v2[0]);
}

//Vector Operations
float vectorDot(float* v1, float* v2){
	float dot = 0;


	for(i=0;i<3;i++){
		dot += v1[i]*v2[i];
	}return dot;
}

void vectorAdd(float* vOut, float* v1, float* v2){


	for(i=0;i<3;i++){
		vOut[i] = v1[i] + v2[i];
	}
}

void vectorScale(float* vOut, float* vIn, float ScaleFactor){


	for(i=0;i<3;i++){
		vOut[i] = vIn[i]*ScaleFactor;
	}
}


