#include "stm32f10x.h"
#include "I2CRoutines.h"
#include "DCM.h"
#include "math.h"

#define ADC1_DR_Address    ((u32)0x4001244C)
#define AXCELSEN 0.32865 //axcel sensitivity V/g
#define AXCELBIAS 1.648 //axcel zero g voltage V
#define ADCREF 3.296 //ADC ref. voltage(V)
#define GYROSEN 14.375 //gyro sensitivity LSB/(deg/s)
#define MAGSEN 1300 // mag sensitivity count/mgauss
#define ALTSEN 1024 //Altimeter sensitivit 1024 count/cm
#define PI 3.141592654
#define MAGADDRESS 0x3C
#define GYROADDRESS 0xD2
#define ACCADDRESS 0x00
#define ORDER 5

extern __IO uint8_t Tx_Idx1 , Rx_Idx1;
extern __IO uint8_t Tx_Idx2 , Rx_Idx2;
//extern float Rmat[3][3];
extern float DCMt;
extern float roll;

//Declarations

void RCC_PeriphInit(void);
void GPIO_PeriphInit(void);
void TIM_PeriphInit(void);
void ADC_PeriphInit(void);
void UART_PeriphInit(void);
void I2C_PeriphInit(void);
void IMU_Read(void);//input I2C address of IMU device
void NVIC_Configuration(void);
void Delay(int count); //delay approx. (125 us * count)
void Motorcmd(int cmd);
void Wificom(void);
void motorPitchInc(void);
void motorPitchDec(void);
void motorRollInc(void);
void motorRollDec(void);
void pitchControl(int iphonePitchCMD);
void rollControl(int iphoneRollCMD);

// VARIABLES

GPIO_InitTypeDef GPIO_InitStructure;
TIM_TimeBaseInitTypeDef TIM_TimeBaseStructure;
TIM_OCInitTypeDef  TIM_OCInitStructure;
ADC_InitTypeDef ADC_InitStructure;
DMA_InitTypeDef DMA_InitStructure;
USART_InitTypeDef USART_InitStructure;

//IMU data variables
u8 IMUBuffer[6]; //temp IMU value storage
vs16 AccRead[4];
vs16 MagRead[3];
vs16 GyroRead[3]; //raw gyro data
vs16 GyroCrt[3];
float MagInt;
float COGtheta;
float AccCon[3];
float Altcon;
float MagCon[3];
float GyroCon[3]; //converted gyro data deg/sec
float GyroConTemp[3];
int Mtr1Val, Mtr2IncVal, Mtr3IncVal, Mtr4IncVal, Mtr1DecVal, Mtr2DecVal, Mtr3DecVal, Mtr4DecVal;
int iphonePitchCMD;
int iphoneRollCMD;
//double sqr[4] = {2,4,9,144};
//double root[4];
//configure IMU devices
u8 MAGconfig1[2] = {0x00, 0x18};
u8 MAGconfig2[2] = {0x01, 0x20};
u8 MAGconfig3[2] = {0x02, 0x00};
u8 GYROconfig1[2] = {0x3E, 0x80}; //reset gyro
u8 GYROconfig2[2] = {0x15, 0x13};
u8 GYROconfig3[2] = {0x16, 0x1E}; // set 8kHz sample rate, enable proper operation
u8 GYROconfig4[2] = {0x3E, 0x02}; //set x axis as pll source
u8 Gyrosr[1] = {0x1D}; //start register of gyro values
u8 Magsr[1] ={0x03};

uint8_t Buffer_Rx1[40];
/* Buffer of data to be transmitted by I2C1 */
uint8_t Buffer_Tx1[40];
/* Buffer of data to be received by I2C2 */
uint8_t Buffer_Rx2[1];
/* Buffer of data to be transmitted by I2C2 */
uint8_t Buffer_Tx2[1];
vu16 throttle = 1000;
vu16 dthrottle=1;
vu16 time[5] = {0,0,0,0,0};
int  i, j, k, x, y, z;
int start = 0, stop = 1, takeoff = 2, land = 3, Rx = 0, Tx = 1;
float B;

//Base Rotational Matrix
float Rmat[3][3] = {
		{1,0,0},
		{0,1,0},
		{0,0,1}
};

/*************************************************************************
 * Function Name: main
 * Parameters: none
 * Return: Int32U
 *
 * Description: The main subroutine
 *
 *************************************************************************/


int main(void) {

	RCC_PeriphInit();
	GPIO_PeriphInit();
	NVIC_Configuration();
	TIM_PeriphInit();
	ADC_PeriphInit();
	UART_PeriphInit();
	I2C_PeriphInit();

	z=0;
	//iphone test commands for the motors
	iphonePitchCMD = 0;
	iphoneRollCMD = 0;
	Mtr1Val = 1400;

	Motorcmd(start);

	while(1) {

		while(TIM_GetFlagStatus(TIM1, TIM_FLAG_Update)==RESET);
		TIM1->SR = 0x0000; //clear update flag set by counter reset

		time[0] = TIM1->CNT;

		IMU_Read(); // get and convert IMU data
/*
		if((MagCon[0]>0) && (MagCon[1]>0)) {
			COGtheta = atanf(MagCon[1]/MagCon[0])-MagInt;
		}
		else if((MagCon[0]>0) && (MagCon[1]<0)) {
				MagInt = 2*PI - atanf(MagCon[1]/MagCon[0])-MagInt;
			 }
		else if((MagCon[0]<0) && (MagCon[1]<0)) {
				MagInt =  PI + atanf(MagCon[1]/MagCon[0])-MagInt;
			 }
		else if((MagCon[0]<0) && (MagCon[1]>0)) {
				MagInt =  PI - atanf(MagCon[1]/MagCon[0])-MagInt;
			 }*/
		time[1] = TIM1->CNT; // total IMU read and conversion time

		updateRmat();
		normRmat();
		correctRmat();

		//pitch = Rmat[2][0];

		pitchControl(iphonePitchCMD);
	//	rollControl(iphoneRollCMD);

		time[2] = TIM1->CNT;
		GPIOC->BSRR = GPIO_Pin_12;

		z++;
		if(z>=50) {
			z=0;
			//throttle += dthrottle;
			//TIM1->CCR4 = throttle;
			//TIM_SetCompare4(TIM1, throttle);
			//GPIO_WriteBit(GPIOC,GPIO_Pin_12,Bit_SET); //turn off LED
			GPIOC->BRR = GPIO_Pin_12;
			//if(throttle>2000) {
				//throttle = 1200;

			//}
		}

	}

}


//Functions definitions



void RCC_PeriphInit(void) {

	//RCC_USBCLKConfig(RCC_USBCLKSource_PLLCLK_1Div5);
	RCC_ADCCLKConfig(RCC_PCLK2_Div6);
	RCC_AHBPeriphClockCmd(RCC_AHBPeriph_DMA1, ENABLE);
	RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM2 | RCC_APB1Periph_USART3 | RCC_APB1Periph_I2C1, ENABLE);
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_TIM1 | RCC_APB2Periph_AFIO | RCC_APB2Periph_ADC1 | RCC_APB2Periph_GPIOC | RCC_APB2Periph_GPIOA | RCC_APB2Periph_GPIOB, ENABLE);
	//RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOC | RCC_APB2Periph_GPIOA | RCC_APB2Periph_GPIOB, ENABLE);
	//RCC_APB2PeriphClockCmd(RCC_APB2Periph_AFIO, ENABLE);
}

void GPIO_PeriphInit(void) {

	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_0;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init(GPIOA, &GPIO_InitStructure);

	// Configure PC.12 as output push-pull (LED)
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_12;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init(GPIOC, &GPIO_InitStructure);

	//ADC Pin config
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_1 | GPIO_Pin_2 | GPIO_Pin_3 | GPIO_Pin_7;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AIN;
	GPIO_Init(GPIOA, &GPIO_InitStructure);
	//GPIO_InitStructure.GPIO_Pin = GPIO_Pin_0 | GPIO_Pin_1;
	//GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AIN;
	//GPIO_Init(GPIOB, &GPIO_InitStructure);


	//tim1 PWM pin config
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_8 | GPIO_Pin_9 | GPIO_Pin_10 | GPIO_Pin_11;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init(GPIOA, &GPIO_InitStructure);

	/* Configure USART3 RTS and USART2 Tx as alternate function push-pull */
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_14 | GPIO_Pin_10;
	GPIO_Init(GPIOB, &GPIO_InitStructure);

	/* Configure USART3 CTS and USART2 Rx as input floating */
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_13 | GPIO_Pin_11;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
	GPIO_Init(GPIOB, &GPIO_InitStructure);


}

void TIM_PeriphInit(void) {

	u16 CCR1_Val = 1000; // 10% duty cycle
	u16 CCR2_Val = 1000; // 16.67% duty cycle
	u16 CCR3_Val = 1000; // 13.33% duty cycle
	u16 CCR4_Val = 1000; // 5% duty cycle
	u16 PrescalerValue = 0;

	//TIM2 used for delays
	TIM_TimeBaseStructure.TIM_ClockDivision = TIM_CKD_DIV1;
	TIM_TimeBaseStructure.TIM_CounterMode = TIM_CounterMode_Up;
	TIM_TimeBaseStructure.TIM_Period = 2999; // set 8 kHz timer frequency cnt
	TIM_TimeBaseStructure.TIM_Prescaler = 2; //set 8 kHz timer frequency tim freq
	TIM_TimeBaseInit(TIM2, &TIM_TimeBaseStructure);

	//TIM_ITConfig(TIM2, TIM_IT_Update, Enable);

	TIM_Cmd(TIM2, ENABLE);

	 /* -----------------------------------------------------------------------

		 - Prescaler = (TIM1CLK / TIM1 counter clock) - 1
		TIMCLK is set to 72 MHz

		 TIM1 Frequency = TIM1 counter clock/(ARR + 1); ARR = TIM_Period

		TIM1 Channel1 duty cycle = (TIM1_CCR1/ TIM1_ARR)* 100 = 50%
		TIM1 Channel2 duty cycle = (TIM1_CCR2/ TIM1_ARR)* 100 = 37.5%
		TIM1 Channel3 duty cycle = (TIM1_CCR3/ TIM1_ARR)* 100 = 25%
		TIM1 Channel4 duty cycle = (TIM1_CCR4/ TIM1_ARR)* 100 = 12.5% */
	 // -----------------------------------------------------------------------
	  // Compute the prescaler value
	  PrescalerValue = (uint16_t) (72000000 / 1000000) - 1; //counter clock set to 1000000 Hz
	  // Time base configuration
	  TIM_TimeBaseStructure.TIM_Period = 19999; //TIM frequency set to 50 Hz; 1000000/(19999+1) = 50
	  TIM_TimeBaseStructure.TIM_Prescaler = PrescalerValue;
	  TIM_TimeBaseStructure.TIM_ClockDivision = 0;
	  TIM_TimeBaseStructure.TIM_CounterMode = TIM_CounterMode_Up;
	  TIM_TimeBaseStructure.TIM_RepetitionCounter = 0;

	  TIM_TimeBaseInit(TIM1, &TIM_TimeBaseStructure);

	  // PWM1 Mode configuration: Channel1
	  TIM_OCInitStructure.TIM_OCIdleState = TIM_OCIdleState_Set;
	  TIM_OCInitStructure.TIM_OCNIdleState = TIM_OCNIdleState_Reset;
	  TIM_OCInitStructure.TIM_OCNPolarity = TIM_OCNPolarity_Low;
	  TIM_OCInitStructure.TIM_OutputNState = TIM_OutputNState_Disable;
	  TIM_OCInitStructure.TIM_OCMode = TIM_OCMode_PWM1;
	  TIM_OCInitStructure.TIM_OutputState = TIM_OutputState_Enable;
	  TIM_OCInitStructure.TIM_Pulse = CCR1_Val;
	  TIM_OCInitStructure.TIM_OCPolarity = TIM_OCPolarity_High;

	  TIM_OC1Init(TIM1, &TIM_OCInitStructure);

	  TIM_OC1PreloadConfig(TIM1, TIM_OCPreload_Enable);

	  // PWM1 Mode configuration: Channel2
	  TIM_OCInitStructure.TIM_OutputState = TIM_OutputState_Enable;
	  TIM_OCInitStructure.TIM_Pulse = CCR2_Val;

	  TIM_OC2Init(TIM1, &TIM_OCInitStructure);

	  TIM_OC2PreloadConfig(TIM1, TIM_OCPreload_Enable);

	  // PWM1 Mode configuration: Channel3
	  TIM_OCInitStructure.TIM_OutputState = TIM_OutputState_Enable;
	  TIM_OCInitStructure.TIM_Pulse = CCR3_Val;

	  TIM_OC3Init(TIM1, &TIM_OCInitStructure);

	  TIM_OC3PreloadConfig(TIM1, TIM_OCPreload_Enable);

	  // PWM1 Mode configuration: Channel4
	  TIM_OCInitStructure.TIM_OutputState = TIM_OutputState_Enable;
	  TIM_OCInitStructure.TIM_Pulse = CCR4_Val;

	  TIM_OC4Init(TIM1, &TIM_OCInitStructure);

	  TIM_OC4PreloadConfig(TIM1, TIM_OCPreload_Enable);

	  TIM_ARRPreloadConfig(TIM1, ENABLE);


	  // TIM1 enable counter
	  TIM_Cmd(TIM1, ENABLE);
	  TIM_CtrlPWMOutputs(TIM1, ENABLE); //enable output pins

}

void ADC_PeriphInit(void) {
	// ADC DMA configuration
	DMA_DeInit(DMA1_Channel1);
	DMA_InitStructure.DMA_PeripheralBaseAddr = (u32)ADC1_DR_Address;
	DMA_InitStructure.DMA_MemoryBaseAddr = (vu32)&AccRead;
	DMA_InitStructure.DMA_DIR = DMA_DIR_PeripheralSRC;
	DMA_InitStructure.DMA_BufferSize = 4;
	DMA_InitStructure.DMA_PeripheralInc = DMA_PeripheralInc_Disable;
	DMA_InitStructure.DMA_MemoryInc = DMA_MemoryInc_Enable;
	DMA_InitStructure.DMA_PeripheralDataSize = DMA_PeripheralDataSize_HalfWord;
	DMA_InitStructure.DMA_MemoryDataSize = DMA_MemoryDataSize_HalfWord;
	DMA_InitStructure.DMA_Mode = DMA_Mode_Circular;
	DMA_InitStructure.DMA_Priority = DMA_Priority_High;
	DMA_InitStructure.DMA_M2M = DMA_M2M_Disable;
	DMA_Init(DMA1_Channel1, &DMA_InitStructure);

	DMA_ITConfig(DMA1_Channel1, DMA_IT_TC, ENABLE); //stop conversion while data is used

	// Enable DMA1 Channel1
	DMA_Cmd(DMA1_Channel1, ENABLE);

	// ADC1 configuration ------------------------------------------------------
	ADC_DeInit(ADC1);
	ADC_InitStructure.ADC_Mode = ADC_Mode_Independent;
	ADC_InitStructure.ADC_ScanConvMode = ENABLE;
	ADC_InitStructure.ADC_ContinuousConvMode = ENABLE;
	ADC_InitStructure.ADC_ExternalTrigConv = ADC_ExternalTrigConv_None;
	ADC_InitStructure.ADC_DataAlign = ADC_DataAlign_Right;
	ADC_InitStructure.ADC_NbrOfChannel = 4;
	ADC_Init(ADC1, &ADC_InitStructure);

	/* ADC1 regular channels configuration */
	ADC_RegularChannelConfig(ADC1, ADC_Channel_1 , 1, ADC_SampleTime_239Cycles5);
	ADC_RegularChannelConfig(ADC1, ADC_Channel_2, 2, ADC_SampleTime_239Cycles5);
	ADC_RegularChannelConfig(ADC1, ADC_Channel_3, 3, ADC_SampleTime_239Cycles5);
	ADC_RegularChannelConfig(ADC1, ADC_Channel_7, 4, ADC_SampleTime_239Cycles5);

	/* Enable ADC1 DMA */
	ADC_DMACmd(ADC1, ENABLE);

	/* Enable ADC1 */
	ADC_Cmd(ADC1, ENABLE);

	/* Enable ADC1 reset calibration register */
	ADC_ResetCalibration(ADC1);
	/* Check the end of ADC1 reset calibration register */
	while(ADC_GetResetCalibrationStatus(ADC1));

	/* Start ADC1 calibaration */
	ADC_StartCalibration(ADC1);
	/* Check the end of ADC1 calibration */
	while(ADC_GetCalibrationStatus(ADC1));

	/* Start ADC1 Software Conversion */
	ADC_SoftwareStartConvCmd(ADC1, ENABLE);
}

void I2C_PeriphInit(void) {

	I2C_LowLevel_Init(I2C1); //configure I2C
	Delay(160); // start up time delay for gyro 20 ms and mag 5ms
	I2C_Master_BufferWrite(I2C1, MAGconfig1, 2, Polling, 0x3C);
	I2C_Master_BufferWrite(I2C1, MAGconfig2, 2, Polling, 0x3C);
	I2C_Master_BufferWrite(I2C1, MAGconfig3, 2, Polling, 0x3C);
	I2C_Master_BufferWrite(I2C1, GYROconfig1,2,Polling, 0xD2); //write data to configure IMU
	I2C_Master_BufferWrite(I2C1, GYROconfig2,2,Polling, 0xD2);
	I2C_Master_BufferWrite(I2C1, GYROconfig3,2,Polling, 0xD2);
	I2C_Master_BufferWrite(I2C1, GYROconfig4,2,Polling, 0xD2);
	//Delay(160);
	I2C_Master_BufferWrite(I2C1, Gyrosr,1,Polling, 0xD2);
	I2C_Master_BufferRead(I2C1, IMUBuffer,6,DMA, 0xD2);
	for(x=0; x<3; x++) {
		GyroRead[x] = (IMUBuffer[x*2]<<8) | IMUBuffer[x*2+1];
		GyroCrt[x] = GyroRead[x];
	}
	Delay(4000);
	I2C_Master_BufferWrite(I2C1, Gyrosr,1,Polling, 0xD2);
	I2C_Master_BufferRead(I2C1, IMUBuffer,6,DMA, 0xD2);
	for(x=0; x<3; x++) {
		GyroRead[x] = (IMUBuffer[x*2]<<8) | IMUBuffer[x*2+1];
		GyroCrt[x] = GyroRead[x];
	}
	/*I2C_Master_BufferWrite(I2C1, Magsr,1,Polling, 0x3C);
	I2C_Master_BufferRead(I2C1, IMUBuffer,6,DMA, 0x3C);
	for(x=0; x<3; x++) {
		MagRead[x] = (IMUBuffer[x*2]<<8) | IMUBuffer[x*2+1];
		MagCon[x] = (float)MagRead[x]/MAGSEN; //Mag field values in gauss
	}
	if((MagCon[0]>0) && (MagCon[1]>0)) {
		MagInt = atanf(MagCon[1]/MagCon[0]);
	}
	else if((MagCon[0]>0) && (MagCon[1]<0)) {
			MagInt = 2*PI - atanf(MagCon[1]/MagCon[0]);
		 }
	else if((MagCon[0]<0) && (MagCon[1]<0)) {
			MagInt =  PI + atanf(MagCon[1]/MagCon[0]);
		 }
	else if((MagCon[0]<0) && (MagCon[1]>0)) {
			MagInt =  PI - atanf(MagCon[1]/MagCon[0]);
		 }*/

}

void IMU_Read(void) {
	//ACCEL read and convert
	DMA_ClearFlag(DMA1_FLAG_TC1); //get next set of data
	while(!DMA_GetFlagStatus(DMA1_FLAG_TC1));  //wait for DMA data transfer to finish
	Altcon = (float)AccRead[3]/ALTSEN;
	for(x=0;x<3;x++){ // convert analog value to g's
		AccCon[x] = ((float)AccRead[x]*ADCREF/4095-AXCELBIAS)/AXCELSEN; // axcel g
	}

	//time[0] = TIM1->CNT; // ADC time
	//Mag. read and convert
	I2C_Master_BufferWrite(I2C1, Magsr,1,Polling, 0x3C);
	I2C_Master_BufferRead(I2C1, IMUBuffer,6,DMA, 0x3C);
	for(x=0; x<3; x++) {
		MagRead[x] = (IMUBuffer[x*2]<<8) | IMUBuffer[x*2+1];
		MagCon[x] = (float)MagRead[x]/MAGSEN; //Mag field values in gauss
	}
	//time[2] = TIM1->CNT; //MAG time
	//Gyro read and convert
	I2C_Master_BufferWrite(I2C1, Gyrosr,1,Polling, 0xD2);
	I2C_Master_BufferRead(I2C1, IMUBuffer,6,DMA, 0xD2);
	for(x=0; x<3; x++) {
		GyroRead[x] = ((IMUBuffer[x*2]<<8) | IMUBuffer[x*2+1])-GyroCrt[x];
		GyroCon[x] = (float)GyroRead[x]*(PI/180)/GYROSEN; //Gyro values in rad/sec
	}
	//time[1] = TIM1->CNT;

}

/**
  * @brief  Configures NVIC and Vector Table base location.
  * @param  None
  * @retval : None
  */
void NVIC_Configuration(void)
{

    /* 1 bit for pre-emption priority, 3 bits for subpriority */
    NVIC_PriorityGroupConfig(NVIC_PriorityGroup_4);

    NVIC_SetPriority(I2C1_EV_IRQn, 0x00);
    NVIC_EnableIRQ(I2C1_EV_IRQn);

    NVIC_SetPriority(I2C1_ER_IRQn, 0x01);
    NVIC_EnableIRQ(I2C1_ER_IRQn);


    NVIC_SetPriority(I2C2_EV_IRQn, 0x00);
    NVIC_EnableIRQ(I2C2_EV_IRQn);

    NVIC_SetPriority(I2C2_ER_IRQn, 0x01);
    NVIC_EnableIRQ(I2C2_ER_IRQn);
}

void Delay( int count) { // delays 125us for the amount set in the argument count (delay = 125us*count)
	//time = 0;
	//wait  125 us
	TIM2->EGR = 0x0001; // reset counter before starting
	TIM2->SR = (uint16_t)~TIM_FLAG_Update; //clear update flag set by counter reset
	while(count>0) { //continue until count is depleted
		while(TIM_GetFlagStatus(TIM2, TIM_FLAG_Update)==RESET); // wait until counter overflow at end of 125 us
		count--;
		TIM2->SR = 0x0000; //clear update flag caused by overflow
	}
}

void UART_PeriphInit(void) {
	/* USART3 configuration ------------------------------------------------------*/
	  /* USART3 configured as follow:
	        - BaudRate = 115200 baud
	        - Word Length = 8 Bits
	        - One Stop Bit
	        - No parity
	        - Hardware flow control enabled (RTS and CTS signals)
	        - Receive and transmit enabled
	  */
	  USART_InitStructure.USART_BaudRate = 115200;
	  USART_InitStructure.USART_WordLength = USART_WordLength_8b;
	  USART_InitStructure.USART_StopBits = USART_StopBits_1;
	  USART_InitStructure.USART_Parity = USART_Parity_No ;
	  USART_InitStructure.USART_HardwareFlowControl = USART_HardwareFlowControl_RTS_CTS;
	  USART_InitStructure.USART_Mode = USART_Mode_Rx | USART_Mode_Tx;

	  USART_Init(USART3, &USART_InitStructure);
	  /* Enable the USART3 */
	  USART_Cmd(USART3, ENABLE);

}

void Motorcmd(int cmd) {
	if(cmd == start) {
		TIM1->CCR1 = 0;
		Delay(4000);
		TIM1->CCR2 = 0;
		Delay(4000);
		TIM1->CCR3 = 0;
		Delay(4000);
		TIM1->CCR4 = 1400;
	}
	else if(cmd == stop) {
		TIM1->CCR1 = 1000;
		TIM1->CCR2 = 1000;
		TIM1->CCR3 = 1000;
		TIM1->CCR4 = 1000;
	}
}

void Wificom(void) {

		for(x=0; x<12; x++) {
			while(USART_GetFlagStatus(USART3, USART_FLAG_RXNE) != RESET);
			Buffer_Rx1[x] = USART_ReceiveData(USART3);
			USART_SendData(USART3, Buffer_Tx1[x]);

		}

}

void pitchControl(int iphonePitchCMD)
{
	if(DCMt < 0)
	{
		if(Mtr1Val<2000){
			Mtr1Val += 50;
		}
	}
	else if(DCMt > 0)
	{
		if(Mtr1Val>1400){
			Mtr1Val -= 50;
		}
	}
	TIM1->CCR4 = (vu16)Mtr1Val;

}

void rollControl(int iphoneRollCMD)
{
	if(roll < 0)
	{
		motorRollInc();
	}
	else if(roll > 0);
	{
		motorRollDec();
	}
}

void motorPitchInc(void){
	if(Mtr1Val<2000)
		Mtr1Val = Mtr1Val + 100;
}

void motorPitchDec(void){
	if(Mtr1Val>1400)
		Mtr1Val = Mtr1Val - 100;
}

void motorRollInc(void){
	Mtr1Val = 2000;
	TIM1->CCR4 = (vu16)Mtr1Val;
}

void motorRollDec(void){
	Mtr1Val = 1400;
	TIM1->CCR4 = (vu16)Mtr1Val;
}


