#include "controllerthread.h"
#include <QThread>

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#define JS_EVENT_BUTTON         0x01    /* button pressed/released */
#define JS_EVENT_AXIS           0x02    /* joystick moved */
#define JS_EVENT_INIT           0x80    /* initial state of device */

ContorllerThread::ContorllerThread() : QThread()
{
    cmd = (struct TankBotCommand *)calloc(sizeof(struct TankBotCommand), 1);
}

ContorllerThread::~ContorllerThread()
{
    if(cmd)
        free(cmd);
    cmd = nullptr;
}

void ContorllerThread::run()
{
    int fd = -1;
    int ret = -1;
    int LdistX = 0, LdistY = 0;
    int RdistX = 0, RdistY = 0;
    struct js_event e;

    while(1){
        if(ret < 0){
            // if last read attempt was a fail close file descriptor to try and open again
            if(fd > -1){
                close(fd);
                emit ControllerStatus(false);
            }

            fd = open ("/dev/input/js0", O_RDONLY);
            if(fd < 0)
                continue;

            emit ControllerStatus(true);
        }
        ret = read(fd,&e, sizeof(e));
        if(ret < 0)
            continue;

        switch(e.type){
        case JS_EVENT_BUTTON:
            switch(e.number){
            case BUTTON_LB:
                cmd->fireState = e.value;
                break;
            default:
                break;
            }
            emit ButtonPressed(e.number, e.value);
            break;
        case JS_EVENT_AXIS:
            switch(e.number){
            case LEFT_X_AXIS:
                leftThumb.X = (int)((abs((double)e.value) < DEADBAND) ? 0.0 : e.value < 0 ? -DEADBAND - e.value : DEADBAND - e.value);
                leftThumb.X = (int)((double)leftThumb.X / -22768 * 127);
                LdistX = abs(leftThumb.X - LLastPoint.X);
                cmd->moveDir.X = leftThumb.X;
                break;
            case LEFT_Y_AXIS:
                leftThumb.Y = (int)((abs((double)e.value) < DEADBAND) ? 0.0 : e.value < 0 ? -DEADBAND - e.value: DEADBAND - e.value);
                leftThumb.Y = (int)((double)leftThumb.Y / 22767 * 127);
                LdistY = abs(leftThumb.Y - LLastPoint.Y);
                cmd->moveDir.Y = leftThumb.Y;
                break;
            case RIGHT_X_AXIS:
                rightThumb.X = (int)((abs((double)e.value) < DEADBAND) ? 0.0 : e.value < 0 ? -DEADBAND - e.value : DEADBAND - e.value);
                rightThumb.X = (int)((double)rightThumb.X / -22768 * 127);
                RdistX = abs(rightThumb.X - RLastPoint.X);
                cmd->lookDir.X = rightThumb.X;
                break;
            case RIGHT_Y_AXIS:
                rightThumb.Y = (int)((abs((double)e.value) < DEADBAND) ? 0.0 : e.value < 0 ? -DEADBAND - e.value : DEADBAND - e.value);
                rightThumb.Y = (int)((double)rightThumb.Y / 22767 * 127);
                RdistY = abs(rightThumb.Y - RLastPoint.Y);
                cmd->lookDir.Y = rightThumb.Y;
                break;
            default:
                break;
            }
            break;
        default:
            continue;
        }
        if ((sqrt(LdistY * LdistY + LdistX * LdistX) > 1.0) || (sqrt(RdistY * RdistY + RdistX * RdistX) > 1.0)){
            emit updateUI(cmd);
        }
        RLastPoint = rightThumb;
        LLastPoint = leftThumb;
    }
}

