#ifndef CONTORLLERTHREAD_H
#define CONTORLLERTHREAD_H

#include <QThread>
#include <QtCore>

#define TANKBOT_STANDBY     0x00
#define TANKBOT_FOLLOW      0x01
#define TANKBOT_ATTACK      0x02
#define TANKBOT_RC          0x03

#define DEADBAND 10000

#define LEFT_X_AXIS 0
#define LEFT_Y_AXIS 1
#define RIGHT_X_AXIS 3
#define RIGHT_Y_AXIS 4

#define BUTTON_PRESSED 1
#define BUTTON_RELEASED 0

#define BUTTON_A 0
#define BUTTON_B 1
#define BUTTON_X 2
#define BUTTON_Y 3
#define BUTTON_LB 4
#define BUTTON_RB 5

struct js_event {
    unsigned int time;      /* event timestamp in milliseconds */
    short value;   /* value */
    unsigned char type;     /* event type */
    unsigned char number;   /* axis/button number */
};

struct Point {
    int X;
    int Y;
};

struct vector2D {
    int8_t X;
    int8_t Y;
};

struct __attribute__ ((__packed__)) TankBotCommand {
    struct vector2D moveDir;
    struct vector2D lookDir;
    uint8_t state;
    uint8_t fireState;
    uint8_t validCoordinates;
};

class ContorllerThread : public QThread
{
    Q_OBJECT
public:
    ContorllerThread();
    ~ContorllerThread();

    void run();

public slots:

signals:
    void updateUI(struct TankBotCommand *cmd);
    void ControllerStatus(bool connected);
    void ButtonPressed(int button, int state);

private:
    struct TankBotCommand *cmd;
    struct Point leftThumb, rightThumb, LLastPoint, RLastPoint;

};

#endif // CONTORLLERTHREAD_H
