#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QtMultimediaWidgets/QVideoWidget>
#include <QtMultimedia/QMediaPlayer>
#include <QtMultimedia/QMediaPlaylist>
#include <QFile>
#include <QHBoxLayout>
#include <udpclient.h>

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = nullptr);
    ~MainWindow();

public slots:
    void ControllerUpdateUI(struct TankBotCommand *cmd);
    void ControllerConnected(bool connected);
    void ControllerButtonPressed(int button, int state);

private slots:
    void on_ButtonRefresh_clicked();

    void on_TankBotStates_currentIndexChanged(int index);

    void on_ButtonFire_pressed();

    void on_ButtonFire_released();

private:
    QString m_sSettingsFile;
    Ui::MainWindow *ui;
    UDPClient *client;
    QString ip_addr;
    QString stream_url;
    QMediaPlayer *player;
    QVideoWidget *vw;
    QHBoxLayout *layout;
};

#endif // MAINWINDOW_H
