#include "udpclient.h"
#include <sys/socket.h>
#include <netinet/in.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <arpa/inet.h>
#include <errno.h>
#include <QtCore>

#define PORT 5000

UDPClient::UDPClient(QString ip_addr)
{
    const char *addr;
    addr = ip_addr.toStdString().c_str();
    sockID = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if (sockID == -1) {
        qDebug("Could not create socket: %s\n",strerror(errno));
    }
    qDebug("Got %d as socket id\n", sockID);

    memset(&server_addr, 0, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(PORT);
    server_addr.sin_addr.s_addr = inet_addr(addr);
}

int UDPClient::sendBytes(void *data, size_t len)
{
    int bytesSent = sendto(sockID, data, len, 0, (struct sockaddr *)&server_addr, sizeof(server_addr));
    if (bytesSent == -1)
        qWarning("Failed to send to connection: %s\n", strerror(errno));

    return bytesSent;
}
