# ATTENTION AWS AND MONGODB ATLAS CREDENTIALS ARE NEEDED FOR THIS PROJECT TO COMPILE

import os
from django.contrib.messages import constants as messages

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

SECRET_KEY = 'o5486n(pml)d)%xit9lw+va@uu!)2&=&t$s^iy&x=t9&q3%s-h'

DEBUG = False

ALLOWED_HOSTS = ['*']

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django.contrib.sites',

    # Apps
    'docs.apps.DocsConfig',
    'accounts.apps.AccountsConfig',
    'dashboard.apps.DashboardConfig',
    'lights.apps.LightsConfig',
    'outlets.apps.OutletsConfig',
    'hvac.apps.HvacConfig',
    'firedetector.apps.FiredetectorConfig',
    'motionsensor.apps.MotionsensorConfig',
    'tasks.apps.TasksConfig',

    # Services
    'crispy_forms',
    'widget_tweaks',
    'rest_framework',
    'friendship',
    'background_task',
    'tempus_dominus',
    'storages',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'HSAS.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [
            os.path.join(BASE_DIR, 'templates')
            ],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'HSAS.wsgi.application'


# Database

DATABASES = {
    'default': {
        'ENGINE': 'djongo',
        'HOST': '' # INSERT MONGODB ATLAS CREDENTIALS HERE
    }
}

# Password validation

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]

SITE_ID=1

# Internationalization

LANGUAGE_CODE = 'en-us'

USE_TZ = True

TIME_ZONE = 'America/New_York'

USE_I18N = True

USE_L10N = True

# Messages

MESSAGE_TAGS = {
    messages.DEBUG: 'alert-info',
    messages.INFO: 'alert-info',
    messages.SUCCESS: 'alert-success',
    messages.WARNING: 'alert-warning',
    messages.ERROR: 'alert-danger',
}

SITE_ID = 1

# Static files
STATICFILES_DIRS = [
    os.path.join(BASE_DIR, 'static'),
]

STATICFILES_STORAGE = 'storages.backends.s3boto3.S3Boto3Storage'

DATA_UPLOAD_MAX_NUMBER_FIELDS = 10000

AUTHENTICATION_BACKENDS = (
    "django.contrib.auth.backends.ModelBackend",
)

# Redirects

LOGIN_REDIRECT_URL = 'home'
LOGOUT_REDIRECT_URL = 'login'

CRISPY_TEMPLATE_PACK = 'bootstrap4'

# REST Framework

REST_FRAMEWORK = {
    'DEFAULT_PERMISSION_CLASSES': [
        'rest_framework.permissions.DjangoModelPermissionsOrAnonReadOnly'
    ]
}

# Email Configuration

EMAIL_BACKEND = 'django_ses.SESBackend'

DEFAULT_FROM_EMAIL = "no-reply@example.com"

# AWS Configuration

# INSERT AWS CREDENTIALS HERE
AWS_ACCESS_KEY_ID = ''
AWS_SECRET_ACCESS_KEY = ''

AWS_SES_REGION_NAME = ''
AWS_SES_REGION_ENDPOINT = ''
AWS_STORAGE_BUCKET_NAME = ''
AWS_AUTO_CREATE_BUCKET = 'True'
AWS_DEFAULT_ACL = None

AWS_S3_OBJECT_PARAMETERS = {
    'CacheControl': 'max-age=86400',
}
AWS_LOCATION = 'static'
AWS_S3_CUSTOM_DOMAIN = '%s.s3.amazonaws.com' % AWS_STORAGE_BUCKET_NAME

STATIC_URL = 'https://%s/%s/' % (AWS_S3_CUSTOM_DOMAIN, AWS_LOCATION)