from django.contrib import admin
from django.urls import include, path
from django.conf.urls import include
from . import views
from django.views.generic import TemplateView
from django.contrib.auth.models import User
from rest_framework import routers, serializers, viewsets

urlpatterns = [
    # Choosing Documentation or Web App
    path('', views.Landing, name='Landing'),

    # Documentation URL
    path('docs/', include('docs.urls')),

    # Web App
    path('dashboard/', include('dashboard.urls')),

    # Account Management
    path('accounts/', include('accounts.urls')),
    path('accounts/', include('django.contrib.auth.urls')),
    #path('accounts/', include('allauth.urls')),
    path('friendship/', include('friendship.urls')),

    # Led Control - Testing
    #path('led/', include('led.urls')),

    # API
    path('', include('lights.urls')),
    path('', include('outlets.urls')),
    path('', include('hvac.urls')),
    path('', include('firedetector.urls')),
    path('', include('motionsensor.urls')),
    path('api-auth/', include('rest_framework.urls', namespace='rest_framework')),

    # Admin URL
    path('admin/', admin.site.urls)
]
