from django.urls import path
from django.views.generic.base import TemplateView
from django.contrib.auth.views import (
    LoginView, LogoutView, PasswordChangeView, PasswordChangeDoneView, PasswordResetView,
    PasswordResetDoneView, PasswordResetConfirmView, PasswordResetCompleteView
)
from . import views

urlpatterns = [
    
    # Registration
    path('register/', views.register , name='register'),
    
    # Login
    path('login/', views.login_view, name='login'),
    
    # Logout
    path('logout/', LogoutView.as_view(template_name='registration/logout.html'), name='logout'),

    # View Profile
	path('profile/view/', views.view_profile, name='view_profile'),

    # Edit Profile
    path('profile/edit/', views.edit_profile, name='edit_profile'),
    
    # Dependent
    path('profile/add_dependent/', views.add_dependent, name='add_dependent'),
    path('profile/manage_dependents/', views.manage_dependents, name='manage_dependents'),
    path('profile/accept_dependent/', views.accept_dependent, name='accept_dependent'),
    path('profile/decline_dependent/', views.decline_dependent, name='decline_dependent'),
    path('profile/delete_dependent/<int:pk>/', views.delete_dependent, name='delete_dependent'),

    # Password Management
    path('password-reset/', PasswordResetView.as_view(template_name='registration/password_reset.html'),
        name='password_reset'),
    path('password-reset-confirm/<uidb64>/<token>/', PasswordResetConfirmView.as_view(template_name='registration/password_reset_confirm.html'),
        name='password_reset_done'),
    path('password-reset/done', PasswordResetDoneView.as_view(template_name='registration/password_reset_done.html'),
        name='password_reset_done'),
    path('password-reset-complete', PasswordResetCompleteView.as_view(template_name='registration/password_reset_complete.html'),
        name='password_reset_complete'),
    path('password-change/', views.change_password, name='password_change'),

    # Deactivate Account
    path('profile/deactivate/', views.deactivate_account, name="deactivate_account"),
]

