from django.urls import path, include
from django.views.generic.base import TemplateView
from .views import (index,
                    create_ms,
                    update_ms,
                    delete_ms,
                    toggle_ms,
                    create_fd,
                    update_fd,
                    toggle_fd,
                    delete_fd,
                    create_hvac,
                    update_hvac,
                    delete_hvac,
                    toggle_hvac,
                    create_switch,
                    update_switch,
                    delete_switch,
                    toggle_switch,
                    create_outlet,
                    update_outlet,
                    toggle_outlet,
                    delete_outlet)

urlpatterns = [
    path('home/', index, name='home'),

    # Fire Detector URLs
    path('home/add_fd/', create_fd, name='create_fd'),
    path('home/update_fd/<int:sn>/', update_fd, name='update_fd'),
    path('home/toggle_fd/<int:sn>/', toggle_fd, name='toggle_fd'),
    path('home/delete_fd/<int:sn>/', delete_fd, name='delete_fd'),

    # HVAC URLs
    path('home/add_hvac/', create_hvac, name='create_hvac'),
    path('home/update_hvac/<int:sn>/', update_hvac, name='update_hvac'),
    path('home/toggle_hvac/<int:sn>/', toggle_hvac, name='toggle_hvac'),
    path('home/delete_hvac/<int:sn>/', delete_hvac, name='delete_hvac'),

    # Switches URLs
    path('home/add_switch/', create_switch, name='create_switch'),
    path('home/update_switch/<int:sn>/', update_switch, name='update_switch'),
    path('home/toggle_switch/<int:sn>/', toggle_switch, name='toggle_switch'),
    path('home/delete_switch/<int:sn>/', delete_switch, name='delete_switch'),

    # Motion Sensor URLs
    path('home/add_ms/', create_ms, name='create_ms'),
    path('home/update_ms/<int:sn>/', update_ms, name='update_ms'),
    path('home/delete_ms/<int:sn>/', delete_ms, name='delete_ms'),
    path('home/toggle_ms/<int:sn>/', toggle_ms, name='toggle_ms'),

    # Outlet URLs
    path('home/add_outlet/', create_outlet, name='create_outlet'),
    path('home/update_outlet/<int:sn>/', update_outlet, name='update_outlet'),
    path('home/toggle_outlet/<int:sn>/', toggle_outlet, name='toggle_outlet'),
    path('home/delete_outlet/<int:sn>/', delete_outlet, name='delete_outlet'),

    path('tasks/', include('tasks.urls')),
]