from django.db import models
from django.contrib.auth import get_user_model
#from django.contrib.auth.models import User

User = get_user_model()

class FireDetector(models.Model):
    sn = models.IntegerField(primary_key=True, default=100, error_messages={'unique': u"A Fire Detector System with this Serial Number already exists.",})
    deviceType = models.CharField(default="FireDetector", max_length=20)
    status = models.CharField(default="OK", max_length=20)
    pin = models.IntegerField(default=1, null=True, error_messages={'unique': u"This Pin is already being used.",})
    owner = models.ForeignKey(User, related_name="fd", on_delete=models.DO_NOTHING, null=True)
    time_triggered = models.DateTimeField(null=True)

    class Meta:
        verbose_name = 'Fire Detector'
        verbose_name_plural = 'Fire Detector'

    def __str__(self):
        return str(self.sn)

