from django.db import models
from django.contrib.auth import get_user_model
#from django.contrib.auth.models import User

User = get_user_model()

class HVAC(models.Model):
    sn = models.IntegerField(primary_key=True, default=200)
    deviceType = models.CharField(default="HVAC", max_length=50)
    setTemperature = models.IntegerField(null=True, default=80)
    temperature = models.IntegerField(null=True, default=100)
    on = models.IntegerField(default=1)
    humidity = models.IntegerField(default=70)
    cooling = models.IntegerField(default=1)    
    owner = models.ForeignKey(User, related_name="hvac", on_delete=models.DO_NOTHING, null=True)

    class Meta:
        verbose_name = 'HVAC'
        verbose_name_plural = 'HVAC'