from django.db import models
from django.contrib.auth import get_user_model

User = get_user_model()

class Switch(models.Model):
    sn = models.IntegerField(primary_key=True, default=300, error_messages={'unique': u"A Switch with this Serial Number is already registered.",})
    deviceType = models.CharField(default="Switch", max_length=10)
    status = models.IntegerField(default=1)
    location = models.CharField(max_length=100)
    owner = models.ForeignKey(User, related_name="switches", on_delete=models.DO_NOTHING, null=True)

    class Meta:
        verbose_name = 'Switch'
        verbose_name_plural = 'Switches'

    def __str__(self):
        return str(self.sn)
