from django.db import models
#from django.contrib.auth.models import User
from django.contrib.auth import get_user_model
from lights.models import Lights
from outlets.models import Outlets

User = get_user_model()


class MotionSensor(models.Model):
    sn = models.IntegerField(primary_key=True, default=400, error_messages={'unique': u"A Motion Sensor with this Serial Number is already registered.",})
    status = models.CharField(default="No Activity", max_length=20)
    deviceType = models.CharField(default="Sensor", max_length=10)
    pin = models.IntegerField(default=10, error_messages={'unique': u"This Pin is already being used.",})
    owner = models.ForeignKey(User, related_name="motionsensor", on_delete=models.DO_NOTHING, null=True)
    #light_rel = models.ForeignKey(Lights, related_name="ms_light", on_delete=models.DO_NOTHING, null=True)
    light_rel = models.ForeignKey(Outlets, related_name="ms_light", on_delete=models.DO_NOTHING, null=True, blank=True)
    time_triggered = models.DateTimeField(null=True)
    timeout = models.IntegerField(default=5, null=True, blank=True)

    class Meta:
        verbose_name = 'Motion Sensor'
        verbose_name_plural = 'Motion Sensor'

    def __str__(self):
        return str(self.sn)