from django.db import models
from django.contrib.auth import get_user_model
#from django.contrib.auth.models import User

User = get_user_model()

class Outlets(models.Model):
    sn = models.IntegerField(primary_key=True, default=500, error_messages={'unique': u"An Outlet with this Serial Number is already registered.",})
    status = models.IntegerField(default=1)
    location = models.CharField(max_length=100)
    owner = models.ForeignKey(User, related_name="Outlet", on_delete=models.CASCADE, null=True)

    class Meta:
        verbose_name = 'Outlet'
        verbose_name_plural = 'Outlets'

    def __str__(self):
        return str(self.sn)