from django import forms
from django.forms import ModelForm
from django.utils.translation import gettext_lazy as _
from motionsensor.models import MotionSensor
from outlets.models import Outlets
from .models import ( ms,
                    outlets)
from tempus_dominus.widgets import DatePicker, TimePicker, DateTimePicker

class MSTaskForm(forms.ModelForm):
    run_on = forms.DateTimeField(widget=DateTimePicker(
            options={
                'useCurrent': False,
                'collapse': False,
                'sideBySide': True,
                'maxDate': '2020-12-31'
            },
            attrs={
                'append': 'fas fa-calendar-alt',
                'icon_toggle': True,
            }
        ))
    class Meta:
        model = ms
        fields = ['action','outlet_sn','run_on']
        labels = {
            'outlet_sn': _('Outlet Serial Number'),
        }
    
    def __init__(self, user, *args, **kwargs):
        super(MSTaskForm, self).__init__(*args, **kwargs)
        self.fields['outlet_sn'].queryset = Outlets.objects.filter(owner=user)


class OutletsTaskForm(forms.ModelForm):
    run_on = forms.DateTimeField(widget=DateTimePicker(
        options={
            'useCurrent': False,
            'collapse': False,
            'sideBySide': True,
            'maxDate': '2020-12-31'
        },
        attrs={
            'append': 'fas fa-calendar-alt',
            'icon_toggle': True,
        }
    ))
    class Meta:
        model = outlets
        fields = ['related_sn','action','run_on']
        labels = {
            'related_sn': _('Outlet Serial Number'),
        }

    def __init__(self, user, *args, **kwargs):
        super(OutletsTaskForm, self).__init__(*args, **kwargs)
        self.fields['related_sn'].queryset = Outlets.objects.filter(owner=user)
