from django.db import models
from motionsensor.models import MotionSensor
from outlets.models import Outlets

class ms(models.Model):
    ON = 'Turn Outlet On'
    MS_CHOICES = [
        (ON, 'Turn Outlet On')
    ]
    related_sn = models.ForeignKey(MotionSensor, on_delete=models.DO_NOTHING)
    outlet_sn = models.ForeignKey(Outlets, on_delete=models.DO_NOTHING, blank=True, null=True)
    action = models.CharField(max_length=500, blank=False, choices=MS_CHOICES, null=True)
    run_on = models.DateTimeField(blank=False, null=True)

    class Meta:
        verbose_name = 'Motion Sensor Tasks'
        verbose_name_plural = 'Motion Sensor Tasks'

class outlets(models.Model):
    TOGGLE = 'Toggle'
    ON = 'Turn On'
    OFF = 'Turn Off'
    OUTLETS_CHOICES = [
        (TOGGLE, 'Toggle'),
        (ON, 'Turn On'),
        (OFF, 'Turn Off'),
    ]
    related_sn = models.ForeignKey(Outlets, on_delete=models.DO_NOTHING)
    action = models.CharField(max_length=500, blank=False, choices=OUTLETS_CHOICES, null=True)
    run_on = models.DateTimeField(blank=False, null=True)

    class Meta:
        verbose_name = 'Outlets Tasks'
        verbose_name_plural = 'Outlets Tasks'