from django.utils import timezone
from django.contrib.auth.models import User
from background_task import background
from motionsensor.models import MotionSensor
from outlets.models import Outlets

# Motion Sensor Tasks
@background(schedule=5)
def schedule_ms(ms_sn, o_sn):
    """Task to Toggle Motion Sensor"""

    ms = MotionSensor.objects.filter(sn=ms_sn).first()
    outlet = Outlets.objects.filter(sn=o_sn).first()
    if ms.status == "No Activity":
        ms.status = "Activity Detected"
        ms.time_triggered = timezone.now()
        print('MS Toggled Through Task')
        ms.save()
    else:
        ms.status = "No Activity"
        outlet.status = 1
        print('Outlet Turned On Through MS Task')
        outlet.save()
        ms.save()


# Outlets Tasks
@background(schedule=5)
def schedule_outlets_toggle(sn):
    """Task to Toggle Outlet"""

    outlet = Outlets.objects.filter(sn=sn).first()
    if outlet.status == 0:
        outlet.status = 1
        print('Outlet Toggled Through Task')
        outlet.save()
    else:
        outlet.status = 0
        print('Outlet Toggled Through Task')
        outlet.save()

@background(schedule=5)
def schedule_outlets_on(sn):
    """Task to Turn On Outlet"""

    outlet = Outlets.objects.filter(sn=sn).first()
    outlet.status = 1
    print('Outlet Turned On Through Task')
    outlet.save()

@background(schedule=5)
def schedule_outlets_off(sn):
    """Task to Turn Off Outlet"""

    outlet = Outlets.objects.filter(sn=sn).first()
    outlet.status = 0
    print('Outlet Turned Off Through Task')
    outlet.save()